/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView.views;

import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewIconUpdater;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPanel;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.SolutionAnalysisIssuesState;
import com.jetbrains.rider.model.SolutionAnalysisModel;
import com.jetbrains.rider.problemsView.toolset.RiderToolsetProblemsStorage;
import com.jetbrains.rider.solutionAnalysis.SolutionAnalysisHost;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderProblemsViewIndicationService", "(Lcom/intellij/openapi/project/Project;)V", "solutionModel", "Lcom/jetbrains/rider/model/SolutionAnalysisModel;", "problemsStorage", "Lcom/jetbrains/rider/problemsView/toolset/RiderToolsetProblemsStorage;", "Companion", "RiderProblemsViewDaemonListener", "intellij.rider"})
public final class RiderProblemsViewIndicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SolutionAnalysisModel solutionModel;
    @NotNull
    private final RiderToolsetProblemsStorage problemsStorage;

    public RiderProblemsViewIndicationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.solutionModel = SolutionAnalysisHost.Companion.getInstance(this.project).getModel();
        this.problemsStorage = RiderToolsetProblemsStorage.Companion.getInstance(this.project);
        this.solutionModel.getIssuesState().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> RiderProblemsViewIndicationService.G(this, arg_0));
        this.problemsStorage.getProblemsAppeared().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> RiderProblemsViewIndicationService.G(this, arg_0));
        this.problemsStorage.getProblemsDisappeared().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> RiderProblemsViewIndicationService.b(this, arg_0));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null));
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        messageBusConnection.subscribe(topic, (Object)new RiderProblemsViewDaemonListener(this.project));
    }

    private static final Unit G(RiderProblemsViewIndicationService riderProblemsViewIndicationService, SolutionAnalysisIssuesState solutionAnalysisIssuesState) {
        Intrinsics.checkNotNullParameter((Object)solutionAnalysisIssuesState, (String)"it");
        ProblemsViewIconUpdater.Companion.update(riderProblemsViewIndicationService.project);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderProblemsViewIndicationService riderProblemsViewIndicationService, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        ProblemsViewIconUpdater.Companion.update(riderProblemsViewIndicationService.project);
        return Unit.INSTANCE;
    }

    private static final Unit b(RiderProblemsViewIndicationService riderProblemsViewIndicationService, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        ProblemsViewIconUpdater.Companion.update(riderProblemsViewIndicationService.project);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService$Companion;", "", "RiderProblemsViewIndicationService$Companion", "()V", "getInstance", "Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderProblemsViewIndicationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(RiderProblemsViewIndicationService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RiderProblemsViewIndicationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService$RiderProblemsViewDaemonListener;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzer$DaemonListener;", "project", "Lcom/intellij/openapi/project/Project;", "RiderProblemsViewIndicationService$RiderProblemsViewDaemonListener", "(Lcom/intellij/openapi/project/Project;)V", "daemonFinished", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderProblemsViewIndicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProblemsViewIndicationService.kt\ncom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService$RiderProblemsViewDaemonListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1755#2,3:76\n*S KotlinDebug\n*F\n+ 1 RiderProblemsViewIndicationService.kt\ncom/jetbrains/rider/problemsView/views/RiderProblemsViewIndicationService$RiderProblemsViewDaemonListener\n*L\n53#1:76,3\n*E\n"})
    public static final class RiderProblemsViewDaemonListener
    implements DaemonCodeAnalyzer.DaemonListener {
        @NotNull
        private final Project project;

        public RiderProblemsViewDaemonListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void daemonFinished() {
            boolean bl;
            block6: {
                ProblemsViewPanel problemsViewPanel = ProblemsView.getSelectedPanel((Project)this.project);
                HighlightingPanel highlightingPanel = problemsViewPanel instanceof HighlightingPanel ? (HighlightingPanel)problemsViewPanel : null;
                if (highlightingPanel == null) {
                    return;
                }
                HighlightingPanel highlightingPanel2 = highlightingPanel;
                Root root2 = highlightingPanel2.getTreeModel().getRoot();
                if (root2 == null) {
                    return;
                }
                Root root3 = root2;
                VirtualFile virtualFile = highlightingPanel2.getCurrentFile();
                if (virtualFile == null) {
                    return;
                }
                problemsViewPanel = virtualFile;
                Iterable iterable = root3.getChildren((VirtualFile)problemsViewPanel);
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : iterable) {
                        Node node = (Node)t;
                        boolean bl3 = false;
                        ProblemNode problemNode = node instanceof ProblemNode ? (ProblemNode)node : null;
                        Integer n = problemNode != null ? Integer.valueOf(problemNode.getSeverity()) : null;
                        if (!(n != null && n >= HighlightSeverity.ERROR.myVal)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            boolean bl4 = bl;
            Unit unit = bl4 ? ProblemsViewIconUpdater.Companion.update(this.project) : ProblemsViewIconUpdater.Companion.update(this.project);
            super.daemonFinished();
        }
    }
}

