/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.panels;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdNuGetConfigFile;
import com.jetbrains.rider.model.RdNuGetFeedDetails;
import com.jetbrains.rider.model.RdNuGetUltraConfig;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.RiderNuGetReloadAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetShowSettingsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetSourcesSplitterToggleAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetToolbarRestoreAction;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigList;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigListState;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigPropertiesPanel;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedTable;
import com.jetbrains.rider.nuget.helpers.RiderNuGetActionHelper;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConsoleHelper;
import com.jetbrains.rider.nuget.panels.RiderNuGetPanelBase;
import com.jetbrains.rider.nuget.panels.components.NuGetConfigDetailedView;
import com.jetbrains.rider.nuget.panels.components.NuGetSourcesMainSplitter;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u00010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010!\u001a\u00020\"2\b\b\u0001\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000b2\b\b\u0003\u0010&\u001a\u00020$H\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u001a\u0010(\u001a\u00020\"2\b\b\u0001\u0010)\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u0013H\u0014J\b\u0010.\u001a\u00020/H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel;", "Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelBase;", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "RiderNuGetSourcesPanel", "(Lcom/jetbrains/rider/nuget/RiderNuGetFacade;)V", "getFacade", "()Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "configList", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigList;", "configDetailedView", "Ljavax/swing/JTextPane;", "feedTable", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedTable;", "propertiesPanel", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigPropertiesPanel;", "errorConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "errorPane", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "G", "Ljavax/swing/Icon;", "invert", "", "mainSplitterToggleAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetSourcesSplitterToggleAction;", "mainSplitter", "Lcom/jetbrains/rider/nuget/panels/components/NuGetSourcesMainSplitter;", "reloadAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetReloadAction;", "mainPanel", "mainPanelSync", "Ljava/lang/Object;", "G", "", "text", "", "textPane", "prefix", "console", "G", "line", "G", "config", "Lcom/jetbrains/rider/model/RdNuGetConfigFile;", "build", "buildToolbar", "Ljavax/swing/JComponent;", "ConsoleType", "intellij.rider"})
public final class RiderNuGetSourcesPanel
extends RiderNuGetPanelBase {
    @NotNull
    private final RiderNuGetFacade facade;
    @NotNull
    private final RiderNuGetConfigList configList;
    @NotNull
    private final JTextPane configDetailedView;
    @NotNull
    private final RiderNuGetFeedTable feedTable;
    @NotNull
    private final RiderNuGetConfigPropertiesPanel propertiesPanel;
    @NotNull
    private final ConsoleViewImpl errorConsole;
    @NotNull
    private final BorderLayoutPanel errorPane;
    @NotNull
    private final RiderNuGetSourcesSplitterToggleAction mainSplitterToggleAction;
    @NotNull
    private final NuGetSourcesMainSplitter mainSplitter;
    @NotNull
    private final RiderNuGetReloadAction reloadAction;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    @NotNull
    private final Object mainPanelSync;

    public RiderNuGetSourcesPanel(@NotNull RiderNuGetFacade facade) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(RiderNugetBundle.Companion.message("tab.title.sources", new Object[0]));
        this.facade = facade;
        this.configList = new RiderNuGetConfigList(this.facade);
        this.configDetailedView = new NuGetConfigDetailedView();
        this.feedTable = new RiderNuGetFeedTable(this.facade, this.facade.getHost().getConfigManager());
        this.propertiesPanel = new RiderNuGetConfigPropertiesPanel((Lifetime)this.facade.getLifetime(), this.facade.getProject(), this.facade.getHost().getConfigManager());
        this.errorConsole = RiderNuGetConsoleHelper.Companion.createConsole(this.facade.getProject());
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        RiderNuGetSourcesPanel riderNuGetSourcesPanel = this;
        boolean bl = false;
        borderLayoutPanel2.setVisible(false);
        borderLayoutPanel2.addToCenter((Component)this.errorConsole.getComponent());
        Editor editor2 = this.errorConsole.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        editor2.getSettings().setCaretRowShown(true);
        riderNuGetSourcesPanel.errorPane = borderLayoutPanel;
        this.mainSplitterToggleAction = new RiderNuGetSourcesSplitterToggleAction(this.facade, (Function0<? extends Icon>)((Function0)() -> RiderNuGetSourcesPanel.G(this)));
        this.mainSplitter = new NuGetSourcesMainSplitter(this.configList, this.feedTable, this.propertiesPanel, this.configDetailedView, this.facade, (Function1<? super Boolean, ? extends Icon>)((Function1)arg_0 -> RiderNuGetSourcesPanel.G(this, arg_0)));
        this.reloadAction = new RiderNuGetReloadAction(this.facade);
        borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        riderNuGetSourcesPanel = this;
        bl = false;
        borderLayoutPanel2.addToCenter((Component)((Object)this.mainSplitter));
        RiderNuGetActionHelper.INSTANCE.applyRefreshActionShortcut(this.reloadAction, (JComponent)borderLayoutPanel2);
        riderNuGetSourcesPanel.mainPanel = borderLayoutPanel;
        this.mainPanelSync = new Object();
        Disposer.register((Disposable)((Disposable)this.facade.getProject()), (Disposable)((Disposable)this.errorConsole));
        this.facade.getHost().getConfigManager().getConfigFiles().advise((Lifetime)this.facade.getLifetime(), arg_0 -> RiderNuGetSourcesPanel.G(this, arg_0));
        this.facade.getHost().getConfigManager().getUltraConfig().advise((Lifetime)this.facade.getLifetime(), arg_0 -> RiderNuGetSourcesPanel.G(this, arg_0));
        this.configList.getOnConfigSelection().advise((Lifetime)this.facade.getLifetime(), arg_0 -> RiderNuGetSourcesPanel.G(this, arg_0));
        InterfacesKt.fire((ISignal)this.facade.getHost().getConfigManager().getReload());
        this.facade.getViewSettings().getSourcesSplitterOrientation().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> RiderNuGetSourcesPanel.G(this, arg_0)));
    }

    @NotNull
    public final RiderNuGetFacade getFacade() {
        return this.facade;
    }

    private final Icon G(boolean bl) {
        Icon icon;
        boolean bl2 = this.facade.getViewSettings().getSourcesSplitterOrientation().getValue() ^ bl;
        if (bl2) {
            Icon icon2 = AllIcons.Actions.SplitHorizontally;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SplitHorizontally");
        } else if (!bl2) {
            Icon icon3 = AllIcons.Actions.SplitVertically;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SplitVertically");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon;
    }

    static /* synthetic */ Icon getMainSplitterIcon$default(RiderNuGetSourcesPanel riderNuGetSourcesPanel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return riderNuGetSourcesPanel.G(bl);
    }

    private final void G(@Nls String string, JTextPane jTextPane, @Nls String string2) {
        Object object = new char[]{'\n'};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])object, (boolean)false, (int)0, (int)6, null);
        object = list2.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            this.G(string2 + string3, jTextPane);
        }
    }

    static /* synthetic */ void addText$default(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string, JTextPane jTextPane, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        riderNuGetSourcesPanel.G(string, jTextPane, string2);
    }

    private final void G(String string, ConsoleViewImpl consoleViewImpl) {
        Object object = new char[]{'\n'};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])object, (boolean)false, (int)0, (int)6, null);
        object = list2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            consoleViewImpl.print(string2 + "\n", ConsoleType.Companion.getError());
        }
    }

    private final void G(@Nls String string, JTextPane jTextPane) {
        JTextPane jTextPane2;
        Color color;
        if (StringsKt.startsWith$default((String)string, (String)"###", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.VsPalette.Companion.getModifierBlue();
        } else if (StringsKt.startsWith$default((String)string, (String)"*", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.CommonPalette.Companion.getLightGreen();
        } else if (StringsKt.startsWith$default((String)string, (String)"!", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.CommonPalette.Companion.getRed();
        } else {
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
            color = (Color)jBColor;
        }
        Color color2 = color;
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = null;
        attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color2);
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.FontFamily, "Lucida Console");
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Alignment, 3);
        JTextPane jTextPane3 = jTextPane2 = jTextPane;
        boolean bl = false;
        jTextPane3.setCaretPosition(jTextPane3.getDocument().getLength());
        jTextPane3.setCharacterAttributes(attributeSet, false);
        jTextPane3.replaceSelection(string + "\n");
    }

    private final void G(RdNuGetConfigFile rdNuGetConfigFile) {
        JTextPane jTextPane;
        JTextPane jTextPane2 = jTextPane = this.configDetailedView;
        boolean bl = false;
        jTextPane2.setEditable(true);
        jTextPane2.setText("");
        RiderNuGetSourcesPanel.G(this, rdNuGetConfigFile.getDetailedInfoHeader());
        RiderNuGetSourcesPanel.b(this, "");
        RiderNuGetSourcesPanel.b(this, "### " + RiderNugetBundle.Companion.message("restore.consent", new Object[0]));
        RiderNuGetSourcesPanel.b(this, "    " + RiderNugetBundle.Companion.message("nuget.config.is.granted", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isGranted() + ", " + RiderNugetBundle.Companion.message("nuget.config.is.granted.in.settings", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isGrantedInSettings() + ", " + RiderNugetBundle.Companion.message("nuget.config.is.automatic", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isAutomatic());
        RiderNuGetSourcesPanel.b(this, "");
        RiderNuGetSourcesPanel.b(this, "### " + RiderNugetBundle.Companion.message("feeds", new Object[0]));
        Iterator iterator2 = rdNuGetConfigFile.getFeeds().iterator();
        while (iterator2.hasNext()) {
            CharSequence charSequence;
            Object object;
            RdNuGetFeedDetails rdNuGetFeedDetails;
            RdNuGetFeedDetails rdNuGetFeedDetails2 = rdNuGetFeedDetails = (object = (RdNuGetFeedDetails)iterator2.next());
            boolean bl2 = false;
            RiderNuGetSourcesPanel.b(this, "* " + rdNuGetFeedDetails2.getName() + (String)((charSequence = (CharSequence)rdNuGetFeedDetails2.getDescription()) == null || charSequence.length() == 0 ? "" : " (" + rdNuGetFeedDetails2.getDescription() + ")"));
            RiderNuGetSourcesPanel.G(this, rdNuGetFeedDetails2.getDetailedInfo());
            RiderNuGetSourcesPanel.b(this, "");
        }
        if (CollectionsKt.any((Iterable)rdNuGetConfigFile.getFallbackFolders())) {
            RiderNuGetSourcesPanel.b(this, "### " + RiderNugetBundle.Companion.message("nuget.config.fallback.folders", new Object[0]));
            for (Object object : rdNuGetConfigFile.getFallbackFolders()) {
                RiderNuGetSourcesPanel.b(this, "* " + (String)object);
            }
        }
        jTextPane2.setEditable(false);
    }

    @NotNull
    protected BorderLayoutPanel build() {
        return this.mainPanel;
    }

    @Override
    @NotNull
    protected JComponent buildToolbar() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        defaultActionGroup2.add((AnAction)new RiderNuGetToolbarRestoreAction((Lifetime)this.facade.getLifetime(), this.facade));
        defaultActionGroup2.add((AnAction)this.reloadAction);
        defaultActionGroup2.add((AnAction)this.mainSplitterToggleAction);
        defaultActionGroup2.add((AnAction)new RiderNuGetShowSettingsAction(this.facade.getProject()));
        defaultActionGroup2.add((AnAction)this.facade.getHelpAction());
        DefaultActionGroup defaultActionGroup3 = defaultActionGroup;
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup3, false).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private static final Icon G(RiderNuGetSourcesPanel riderNuGetSourcesPanel) {
        return RiderNuGetSourcesPanel.getMainSplitterIcon$default(riderNuGetSourcesPanel, false, 1, null);
    }

    private static final Icon G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, boolean bl) {
        return riderNuGetSourcesPanel.G(true);
    }

    private static final Unit G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, List list2) {
        RiderNuGetConfigList riderNuGetConfigList;
        Intrinsics.checkNotNullParameter((Object)list2, (String)"newFiles");
        RiderNuGetConfigList riderNuGetConfigList2 = riderNuGetConfigList = riderNuGetSourcesPanel.configList;
        boolean bl = false;
        RiderNuGetConfigListState riderNuGetConfigListState = riderNuGetConfigList2.getState();
        riderNuGetConfigList2.getRiderModel().removeAllElements();
        for (RdNuGetConfigFile rdNuGetConfigFile : list2) {
            riderNuGetConfigList2.getRiderModel().addElement(rdNuGetConfigFile);
        }
        riderNuGetConfigList2.applyState(riderNuGetConfigListState);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, RdNuGetUltraConfig rdNuGetUltraConfig) {
        Intrinsics.checkNotNullParameter((Object)rdNuGetUltraConfig, (String)"ultra");
        Object object = riderNuGetSourcesPanel.mainPanelSync;
        synchronized (object) {
            boolean bl = false;
            CharSequence charSequence = rdNuGetUltraConfig.getErrorMessage();
            boolean bl2 = !(charSequence == null || charSequence.length() == 0);
            boolean bl3 = riderNuGetSourcesPanel.errorPane.isVisible() ^ bl2;
            if (riderNuGetSourcesPanel.errorPane.isVisible() && !bl2) {
                riderNuGetSourcesPanel.mainPanel.remove((Component)riderNuGetSourcesPanel.errorPane);
                riderNuGetSourcesPanel.mainPanel.addToCenter((Component)((Object)riderNuGetSourcesPanel.mainSplitter));
            }
            if (!riderNuGetSourcesPanel.errorPane.isVisible() && bl2) {
                riderNuGetSourcesPanel.mainPanel.remove((Component)((Object)riderNuGetSourcesPanel.mainSplitter));
                riderNuGetSourcesPanel.mainPanel.addToCenter((Component)riderNuGetSourcesPanel.errorPane);
            }
            riderNuGetSourcesPanel.errorConsole.clear();
            String string = rdNuGetUltraConfig.getErrorMessage();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            riderNuGetSourcesPanel.G(string2, riderNuGetSourcesPanel.errorConsole);
            riderNuGetSourcesPanel.errorPane.setVisible(bl2);
            if (bl3) {
                riderNuGetSourcesPanel.mainPanel.invalidate();
                riderNuGetSourcesPanel.mainPanel.repaint();
            }
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, RdNuGetConfigFile rdNuGetConfigFile) {
        Intrinsics.checkNotNullParameter((Object)rdNuGetConfigFile, (String)"it");
        riderNuGetSourcesPanel.G(rdNuGetConfigFile);
        riderNuGetSourcesPanel.feedTable.displayConfig(rdNuGetConfigFile);
        riderNuGetSourcesPanel.propertiesPanel.displayConfig(rdNuGetConfigFile);
        return Unit.INSTANCE;
    }

    private static final Unit G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, boolean bl) {
        riderNuGetSourcesPanel.mainSplitter.setOrientation(bl);
        riderNuGetSourcesPanel.mainSplitter.updateUI();
        return Unit.INSTANCE;
    }

    private static final void G(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string) {
        RiderNuGetSourcesPanel.addText$default(riderNuGetSourcesPanel, string, riderNuGetSourcesPanel.configDetailedView, null, 4, null);
    }

    private static final void b(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string) {
        riderNuGetSourcesPanel.G(string, riderNuGetSourcesPanel.configDetailedView);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel$ConsoleType;", "", "RiderNuGetSourcesPanel$ConsoleType", "()V", "Companion", "intellij.rider"})
    private static final class ConsoleType {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final ConsoleViewContentType error = new ConsoleViewContentType("NUGET_ERROR", ConsoleHighlighter.RED);

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel$ConsoleType$Companion;", "", "RiderNuGetSourcesPanel$ConsoleType$Companion", "()V", "error", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getError", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ConsoleViewContentType getError() {
                return error;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

