/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.management.chosen;

import com.jetbrains.rider.model.RdNuGetImplicitVersion;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u0016\u001a\u00020\u0005J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/nuget/management/chosen/RiderNuGetTargetProject;", "", "projectId", "", "title", "", "explicitVersion", "integratedVersion", "Lcom/jetbrains/rider/model/RdNuGetImplicitVersion;", "autoReferenced", "", "RiderNuGetTargetProject", "(ILjava/lang/String;Ljava/lang/String;Lcom/jetbrains/rider/model/RdNuGetImplicitVersion;Z)V", "getProjectId", "()I", "getTitle", "()Ljava/lang/String;", "getExplicitVersion", "getIntegratedVersion", "()Lcom/jetbrains/rider/model/RdNuGetImplicitVersion;", "getApplyOperation", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation;", "targetVersion", "getRemoveOperation", "getAllOperations", "", "toString", "intellij.rider"})
public final class RiderNuGetTargetProject {
    private final int projectId;
    @NotNull
    private final String title;
    @NotNull
    private final String explicitVersion;
    @Nullable
    private final RdNuGetImplicitVersion integratedVersion;
    private final boolean autoReferenced;

    public RiderNuGetTargetProject(int projectId, @NotNull String title2, @NotNull String explicitVersion, @Nullable RdNuGetImplicitVersion integratedVersion, boolean autoReferenced) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)explicitVersion, (String)"explicitVersion");
        this.projectId = projectId;
        this.title = title2;
        this.explicitVersion = explicitVersion;
        this.integratedVersion = integratedVersion;
        this.autoReferenced = autoReferenced;
    }

    public final int getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getExplicitVersion() {
        return this.explicitVersion;
    }

    @Nullable
    public final RdNuGetImplicitVersion getIntegratedVersion() {
        return this.integratedVersion;
    }

    @Nullable
    public final RiderNuGetOperation getApplyOperation(@NotNull String targetVersion) {
        Intrinsics.checkNotNullParameter((Object)targetVersion, (String)"targetVersion");
        return !Intrinsics.areEqual((Object)this.explicitVersion, (Object)targetVersion) && !Intrinsics.areEqual((Object)targetVersion, (Object)"") && !this.autoReferenced ? RiderNuGetOperation.Companion.resolve(this.explicitVersion, targetVersion) : null;
    }

    @Nullable
    public final RiderNuGetOperation getRemoveOperation() {
        return Intrinsics.areEqual((Object)this.explicitVersion, (Object)"") ? null : (this.autoReferenced ? null : RiderNuGetOperation.Companion.resolve(this.explicitVersion, ""));
    }

    @NotNull
    public final List<RiderNuGetOperation> getAllOperations(@NotNull String targetVersion) {
        Intrinsics.checkNotNullParameter((Object)targetVersion, (String)"targetVersion");
        Object[] objectArray = new RiderNuGetOperation[]{this.getApplyOperation(targetVersion), this.getRemoveOperation()};
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public String toString() {
        return this.title + " v" + this.explicitVersion;
    }
}

