/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderNuGetProjects", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "allProjectEntities", "", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getAllProjectEntities", "()Ljava/util/List;", "allProjectIds", "", "getAllProjectIds", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetProjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetProjects.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetProjects\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1053#2:38\n1611#2,9:39\n1863#2:48\n1864#2:50\n1620#2:51\n1#3:49\n*S KotlinDebug\n*F\n+ 1 RiderNuGetProjects.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetProjects\n*L\n36#1:38\n36#1:39,9\n36#1:48\n36#1:50\n36#1:51\n36#1:49\n*E\n"})
public final class RiderNuGetProjects {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public RiderNuGetProjects(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<ProjectModelEntity> getAllProjectEntities() {
        return WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project));
    }

    @NotNull
    public final List<Integer> getAllProjectIds() {
        Iterable iterable = this.getAllProjectEntities();
        boolean bl = false;
        iterable = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)projectModelEntity.getName());
                projectModelEntity = (ProjectModelEntity)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)projectModelEntity.getName())));
            }
        });
        bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            Integer n;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)t2;
            boolean bl5 = false;
            if (ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)this.project) == null) continue;
            boolean bl6 = false;
            collection.add(n);
        }
        return (List)collection;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects$Companion;", "", "RiderNuGetProjects$Companion", "()V", "isSharedProject", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isDockerProject", "isSqlProject", "isNodeJsProject", "isWixProject", "isCppProject", "isUnrealProject", "isValidNuGetProject", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSharedProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("shproj") : false;
        }

        public final boolean isDockerProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("dcproj") : false;
        }

        public final boolean isSqlProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("sqlproj") : false;
        }

        public final boolean isNodeJsProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("njsproj") : false;
        }

        public final boolean isWixProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("wixproj") : false;
        }

        public final boolean isCppProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return object != null && (object = object.getUrl()) != null && (object = VirtualFileUrls.getVirtualFile((VirtualFileUrl)object)) != null && (object = object.getExtension()) != null ? ((String)object).equals("vcxproj") : false;
        }

        public final boolean isUnrealProject(@NotNull ProjectModelEntity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            return (projectModelEntity != null && (projectModelEntity = projectModelEntity.getDescriptor()) != null ? ProjectModelNodeExtensionKt.getUnrealProjectMark((RdProjectModelItemDescriptor)projectModelEntity) : null) != null;
        }

        public final boolean isValidNuGetProject(@Nullable ProjectModelEntity entity) {
            return entity != null && ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity) && !this.isSharedProject(entity) && !this.isDockerProject(entity) && !this.isSqlProject(entity) && !this.isNodeJsProject(entity) && !this.isWixProject(entity) && !this.isCppProject(entity) && !this.isUnrealProject(entity);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

