/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import com.jetbrains.rider.ui.RiderUI;
import icons.RiderIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB?\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0012\u001a\u00020\u00032\b\b\u0001\u0010\u0013\u001a\u00020\u00032\b\b\u0001\u0010\u0014\u001a\u00020\u0003H\u0007J\u001c\u0010\u0015\u001a\u00020\u00032\b\b\u0001\u0010\u0013\u001a\u00020\u00032\b\b\u0001\u0010\u0014\u001a\u00020\u0003H\u0007J\u001c\u0010\u0016\u001a\u00020\u00032\b\b\u0001\u0010\u0013\u001a\u00020\u00032\b\b\u0001\u0010\u0014\u001a\u00020\u0003H\u0007J6\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00032\b\b\u0001\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d0\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation;", "", "title", "", "description", "question", "icon", "Ljavax/swing/Icon;", "isApply", "", "isPureInstall", "RiderNuGetOperation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;ZZ)V", "getTitle", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "()Z", "getHtmlDescription", "packageTitle", "projectTitle", "getHtmlQuestion", "getPlainTextDescription", "toButton", "Ljavax/swing/JButton;", "buttonSize", "", "action", "Lkotlin/Function1;", "", "Companion", "Version", "intellij.rider"})
public final class RiderNuGetOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String title;
    @NotNull
    private final String description;
    @NotNull
    private final String question;
    @NotNull
    private final Icon icon;
    private final boolean isApply;
    private final boolean isPureInstall;
    @NotNull
    private static final String packagePlaceholder = "(package)";
    @NotNull
    private static final String projectPlaceholder = "(project)";

    public RiderNuGetOperation(@Nls @NotNull String title2, @Nls @NotNull String description, @Nls @NotNull String question, @NotNull Icon icon, boolean isApply, boolean isPureInstall) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)question, (String)"question");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.title = title2;
        this.description = description;
        this.question = question;
        this.icon = icon;
        this.isApply = isApply;
        this.isPureInstall = isPureInstall;
    }

    public /* synthetic */ RiderNuGetOperation(String string, String string2, String string3, Icon icon, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(string, string2, string3, icon, bl, bl2);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    public final boolean isApply() {
        return this.isApply;
    }

    public final boolean isPureInstall() {
        return this.isPureInstall;
    }

    @NlsSafe
    @NotNull
    public final String getHtmlDescription(@NlsSafe @NotNull String packageTitle, @NlsSafe @NotNull String projectTitle) {
        Intrinsics.checkNotNullParameter((Object)packageTitle, (String)"packageTitle");
        Intrinsics.checkNotNullParameter((Object)projectTitle, (String)"projectTitle");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("<html>" + this.description + "</html>"), (String)packagePlaceholder, (String)packageTitle, (boolean)false, (int)4, null), (String)projectPlaceholder, (String)projectTitle, (boolean)false, (int)4, null);
    }

    @NlsSafe
    @NotNull
    public final String getHtmlQuestion(@NlsSafe @NotNull String packageTitle, @NlsSafe @NotNull String projectTitle) {
        Intrinsics.checkNotNullParameter((Object)packageTitle, (String)"packageTitle");
        Intrinsics.checkNotNullParameter((Object)projectTitle, (String)"projectTitle");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)("<html>" + this.question + "</html>"), (String)packagePlaceholder, (String)packageTitle, (boolean)false, (int)4, null), (String)projectPlaceholder, (String)projectTitle, (boolean)false, (int)4, null);
    }

    @NlsSafe
    @NotNull
    public final String getPlainTextDescription(@NlsSafe @NotNull String packageTitle, @Nls @NotNull String projectTitle) {
        Intrinsics.checkNotNullParameter((Object)packageTitle, (String)"packageTitle");
        Intrinsics.checkNotNullParameter((Object)projectTitle, (String)"projectTitle");
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.getHtmlDescription(packageTitle, projectTitle), (String)"<html>", (String)"", (boolean)false, (int)4, null), (String)"</html>", (String)"", (boolean)false, (int)4, null), (String)"<b>", (String)"", (boolean)false, (int)4, null), (String)"</b>", (String)"", (boolean)false, (int)4, null))).toString();
    }

    @NotNull
    public final JButton toButton(@NotNull String packageTitle, @Nls @NotNull String projectTitle, int buttonSize, @NotNull Function1<? super RiderNuGetOperation, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)packageTitle, (String)"packageTitle");
        Intrinsics.checkNotNullParameter((Object)projectTitle, (String)"projectTitle");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        RiderNuGetOperation riderNuGetOperation = this;
        Dimension dimension = new Dimension(JBUI.scale((int)buttonSize), JBUI.scale((int)buttonSize));
        return new JButton(riderNuGetOperation, dimension, packageTitle, projectTitle, action2){
            {
                this.setIcon($op.getIcon());
                this.setDisabledIcon(IconLoader.getDisabledIcon((Icon)$op.getIcon()));
                this.setMinimumSize($size);
                this.setMaximumSize($size);
                this.setPreferredSize($size);
                this.setBorder(JBUI.Borders.empty((int)0));
                this.setMargin((Insets)new JBInsets(0, 0, 0, 0));
                this.setToolTipText($op.getHtmlDescription($packageTitle, $projectTitle));
                this.addActionListener(arg_0 -> toButton.1.G($action, $op, arg_0));
            }

            public Color getBackground() {
                Color color = this.hasFocus() ? UIUtil.getTableSelectionBackground((boolean)true) : RiderUI.Companion.getUsualBackgroundColor();
                Intrinsics.checkNotNull((Object)color);
                return color;
            }

            private static final void G(Function1 function1, RiderNuGetOperation riderNuGetOperation, ActionEvent actionEvent) {
                function1.invoke((Object)riderNuGetOperation);
            }
        };
    }

    public static /* synthetic */ JButton toButton$default(RiderNuGetOperation riderNuGetOperation, String string, String string2, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 32;
        }
        return riderNuGetOperation.toButton(string, string2, n, (Function1<? super RiderNuGetOperation, Unit>)function1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0003J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Companion;", "", "RiderNuGetOperation$Companion", "()V", "packagePlaceholder", "", "projectPlaceholder", "G", "version", "a", "F", "B", "r", "I", "b", "D", "resolve", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation;", "oldVersion", "newVersion", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nls
        private final String G(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.remove.description", objectArray);
        }

        @Nls
        private final String a(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.install.description", objectArray);
        }

        @Nls
        private final String F(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.upgrade.description", objectArray);
        }

        @Nls
        private final String B(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.downgrade.description", objectArray);
        }

        @Nls
        private final String r(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.remove.question", objectArray);
        }

        @Nls
        private final String I(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.install.question", objectArray);
        }

        @Nls
        private final String b(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.upgrade.question", objectArray);
        }

        @Nls
        private final String D(String string) {
            Object[] objectArray = new Object[]{RiderNuGetOperation.packagePlaceholder, string, RiderNuGetOperation.projectPlaceholder};
            return RiderNugetBundle.Companion.message("nuget.operator.downgrade.question", objectArray);
        }

        @Nullable
        public final RiderNuGetOperation resolve(@NotNull String oldVersion, @NotNull String newVersion) {
            RiderNuGetOperation riderNuGetOperation;
            Intrinsics.checkNotNullParameter((Object)oldVersion, (String)"oldVersion");
            Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
            if (StringsKt.isBlank((CharSequence)oldVersion) && StringsKt.isBlank((CharSequence)newVersion)) {
                riderNuGetOperation = null;
            } else if (StringsKt.isBlank((CharSequence)oldVersion) && !StringsKt.isBlank((CharSequence)newVersion)) {
                String string = RiderNugetBundle.Companion.message("nuget.operator.install.title", new Object[0]);
                String string2 = this.a(newVersion);
                String string3 = this.I(newVersion);
                Icon icon = RiderIcons.Nuget.NugetInstall;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NugetInstall");
                riderNuGetOperation = new RiderNuGetOperation(string, string2, string3, icon, true, true);
            } else if (!StringsKt.isBlank((CharSequence)oldVersion) && StringsKt.isBlank((CharSequence)newVersion)) {
                String string = RiderNugetBundle.Companion.message("nuget.operator.remove.title", new Object[0]);
                String string4 = this.G(oldVersion);
                String string5 = this.r(oldVersion);
                Icon icon = RiderIcons.Nuget.NugetRemove;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"NugetRemove");
                riderNuGetOperation = new RiderNuGetOperation(string, string4, string5, icon, false, false, 32, null);
            } else if (Version.Companion.parse(oldVersion).compareTo(Version.Companion.parse(newVersion)) < 0) {
                String string = RiderNugetBundle.Companion.message("nuget.operator.upgrade.title", new Object[0]);
                String string6 = this.F(newVersion);
                String string7 = this.b(newVersion);
                Icon icon = RiderIcons.Nuget.Upgrade;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Upgrade");
                riderNuGetOperation = new RiderNuGetOperation(string, string6, string7, icon, true, false, 32, null);
            } else if (Version.Companion.parse(oldVersion).compareTo(Version.Companion.parse(newVersion)) > 0) {
                String string = RiderNugetBundle.Companion.message("nuget.operator.downgrade.title", new Object[0]);
                String string8 = this.B(newVersion);
                String string9 = this.D(newVersion);
                Icon icon = RiderIcons.Nuget.Downgrade;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Downgrade");
                riderNuGetOperation = new RiderNuGetOperation(string, string8, string9, icon, true, false, 32, null);
            } else {
                riderNuGetOperation = Version.Companion.parse(oldVersion).compareTo(Version.Companion.parse(newVersion)) == 0 ? null : null;
            }
            return riderNuGetOperation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u0003H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "", "major", "", "minor", "build", "revision", "label", "", "originalString", "RiderNuGetOperation$Version", "(IIIILjava/lang/String;Ljava/lang/String;)V", "getMajor", "()I", "getMinor", "getBuild", "getRevision", "getLabel", "()Ljava/lang/String;", "getOriginalString", "compareTo", "other", "equals", "", "", "hashCode", "toString", "Companion", "intellij.rider"})
    public static final class Version
    implements Comparable<Version> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int major;
        private final int minor;
        private final int build;
        private final int revision;
        @NotNull
        private final String label;
        @NotNull
        private final String originalString;

        public Version(int major, int minor, int build2, int revision, @NotNull String label2, @NotNull String originalString) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            Intrinsics.checkNotNullParameter((Object)originalString, (String)"originalString");
            this.major = major;
            this.minor = minor;
            this.build = build2;
            this.revision = revision;
            this.label = label2;
            this.originalString = originalString;
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getBuild() {
            return this.build;
        }

        public final int getRevision() {
            return this.revision;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String getOriginalString() {
            return this.originalString;
        }

        @Override
        public int compareTo(@NotNull Version other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.major != other.major ? this.major - other.major : (this.minor != other.minor ? this.minor - other.minor : (this.build != other.build ? this.build - other.build : (this.revision != other.revision ? this.revision - other.revision : (Intrinsics.areEqual((Object)this.label, (Object)"") && !Intrinsics.areEqual((Object)other.label, (Object)"") ? 1 : (!Intrinsics.areEqual((Object)this.label, (Object)"") && Intrinsics.areEqual((Object)other.label, (Object)"") ? -1 : Companion.compareLabels(this.label, other.label))))));
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.rider.nuget.helpers.RiderNuGetOperation.Version");
            Version cfr_ignored_0 = (Version)other;
            if (this.major != ((Version)other).major) {
                return false;
            }
            if (this.minor != ((Version)other).minor) {
                return false;
            }
            if (this.build != ((Version)other).build) {
                return false;
            }
            if (this.revision != ((Version)other).revision) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)((Version)other).label)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.originalString, (Object)((Version)other).originalString);
        }

        public int hashCode() {
            int n = this.major;
            n = 31 * n + this.minor;
            n = 31 * n + this.build;
            n = 31 * n + this.revision;
            n = 31 * n + this.label.hashCode();
            n = 31 * n + this.originalString.hashCode();
            return n;
        }

        @NotNull
        public String toString() {
            return this.originalString;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version$Companion;", "", "RiderNuGetOperation$Version$Companion", "()V", "parse", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "s", "", "compareLabels", "", "label1", "label2", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Version parse(@NotNull String s) {
                char[] cArray;
                List list2;
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                String string = s.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)string, (Object)"not installed")) {
                    return new Version(0, 0, 0, 0, "", s);
                }
                String string2 = s;
                String string3 = "";
                if (StringsKt.contains$default((CharSequence)string2, (char)'-', (boolean)false, (int)2, null)) {
                    int n = StringsKt.indexOf$default((CharSequence)string2, (char)'-', (int)0, (boolean)false, (int)6, null);
                    String string4 = string2.substring(n + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    string3 = string4;
                    String string5 = s.substring(0, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string2 = string5;
                }
                int n = !((Collection)(list2 = StringsKt.split$default((CharSequence)string2, (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null))).isEmpty() && !StringsKt.isBlank((CharSequence)((CharSequence)list2.get(0))) ? Integer.parseInt((String)list2.get(0)) : 0;
                int n2 = list2.size() > 1 ? Integer.parseInt((String)list2.get(1)) : 0;
                int n3 = list2.size() > 2 ? Integer.parseInt((String)list2.get(2)) : 0;
                int n4 = list2.size() > 3 ? Integer.parseInt((String)list2.get(3)) : 0;
                return new Version(n, n2, n3, n4, string3, s);
            }

            public final int compareLabels(@NotNull String label1, @NotNull String label2) {
                Intrinsics.checkNotNullParameter((Object)label1, (String)"label1");
                Intrinsics.checkNotNullParameter((Object)label2, (String)"label2");
                Object object = new char[]{'.'};
                List list2 = StringsKt.split$default((CharSequence)label1, (char[])object, (boolean)false, (int)0, (int)6, null);
                char[] cArray = new char[]{'.'};
                object = StringsKt.split$default((CharSequence)label2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                int n = Math.min(list2.size(), object.size());
                for (int j = 0; j < n; ++j) {
                    if (Intrinsics.areEqual(list2.get(j), object.get(j))) continue;
                    Integer n2 = StringsKt.toIntOrNull((String)((String)list2.get(j)));
                    Integer n3 = StringsKt.toIntOrNull((String)((String)object.get(j)));
                    if (n2 != null && n3 != null) {
                        return n2 - n3;
                    }
                    return ((String)list2.get(j)).compareTo((String)object.get(j));
                }
                return n < object.size() ? -1 : (n < list2.size() ? 1 : 0);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

