/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.jetbrains.rider.model.RdNuGetNotification;
import com.jetbrains.rider.model.RdNuGetNotificationButton;
import com.jetbrains.rider.model.RdNuGetNotificationContext;
import com.jetbrains.rider.model.RdNuGetNotificationLevel;
import com.jetbrains.rider.nuget.RiderNuGetToolWindowFactory;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.RiderNuGetOpenPackagesFolderAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetShowSettingsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetToolWindowActions;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewIndicationService;
import icons.RiderIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J2\u0010#\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\"2\b\b\u0001\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001bH\u0002J\u000f\u0010+\u001a\t\u0018\u00010,\u00a2\u0006\u0002\b-H\u0002J4\u0010.\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\"2\b\b\u0001\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001bH\u0002J\"\u0010/\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001b2\n\b\u0001\u00100\u001a\u0004\u0018\u00010\"H\u0002J\u000e\u0010.\u001a\u0002012\u0006\u00102\u001a\u00020\u000bJ\"\u00103\u001a\u00020$2\b\b\u0001\u0010%\u001a\u00020\"2\b\b\u0001\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(J\u0010\u00104\u001a\u0004\u0018\u00010\u000b2\u0006\u00105\u001a\u00020\nJ\u000e\u00106\u001a\u00020\r2\u0006\u00105\u001a\u00020\nJ\f\u00107\u001a\u00020\u0016*\u00020*H\u0002J\f\u00108\u001a\u00020(*\u000209H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006<"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderNuGetNotifier", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "lastNotification", "", "Lcom/jetbrains/rider/model/RdNuGetNotificationContext;", "Lcom/jetbrains/rider/model/RdNuGetNotification;", "amountOfFailedNotifications", "", "openPackagesFolderAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetOpenPackagesFolderAction;", "showSettingsAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetShowSettingsAction;", "showSourcesAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "showLogAction", "logActionInfo", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier$NuGetNotificationButtonActionInfo;", "packageFolderActionInfo", "settingsActionInfo", "sourcesActionInfo", "actionsList", "", "listener", "Lcom/intellij/notification/NotificationListener$Adapter;", "getListener", "()Lcom/intellij/notification/NotificationListener$Adapter;", "G", "href", "", "b", "Lcom/intellij/notification/Notification;", "title", "message", "type", "Lcom/intellij/notification/NotificationType;", "buttons", "Lcom/jetbrains/rider/model/RdNuGetNotificationButton;", "G", "Lcom/intellij/ui/content/Content;", "Lorg/jetbrains/annotations/Nullable;", "notify", "G", "contents", "", "notification", "notifyFromFrontend", "getLastNotification", "context", "getAmountOfFailedNotifications", "G", "G", "Lcom/jetbrains/rider/model/RdNuGetNotificationLevel;", "Companion", "NuGetNotificationButtonActionInfo", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetNotifier.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n230#2,2:167\n*S KotlinDebug\n*F\n+ 1 RiderNuGetNotifier.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier\n*L\n69#1:167,2\n*E\n"})
public final class RiderNuGetNotifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<RdNuGetNotificationContext, RdNuGetNotification> lastNotification;
    @NotNull
    private final Map<RdNuGetNotificationContext, Integer> amountOfFailedNotifications;
    @NotNull
    private final RiderNuGetOpenPackagesFolderAction openPackagesFolderAction;
    @NotNull
    private final RiderNuGetShowSettingsAction showSettingsAction;
    @NotNull
    private final AnAction showSourcesAction;
    @NotNull
    private final AnAction showLogAction;
    @NotNull
    private final NuGetNotificationButtonActionInfo logActionInfo;
    @NotNull
    private final NuGetNotificationButtonActionInfo packageFolderActionInfo;
    @NotNull
    private final NuGetNotificationButtonActionInfo settingsActionInfo;
    @NotNull
    private final NuGetNotificationButtonActionInfo sourcesActionInfo;
    @NotNull
    private final List<NuGetNotificationButtonActionInfo> actionsList;
    @NotNull
    private final NotificationListener.Adapter listener;
    @NotNull
    private static final String NO_BREAK_SPACE = "&nbsp;";
    @NotNull
    public static final String HYPERLINK_TEMPLATE = "<a href='%s'>%s</a>";
    @NotNull
    public static final String HYPERLINK_DELIMITER = "&nbsp;&nbsp;&nbsp;";

    public RiderNuGetNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lastNotification = new LinkedHashMap();
        this.amountOfFailedNotifications = new LinkedHashMap();
        this.openPackagesFolderAction = new RiderNuGetOpenPackagesFolderAction(this.project);
        this.showSettingsAction = new RiderNuGetShowSettingsAction(this.project);
        this.showSourcesAction = RiderNuGetToolWindowActions.Companion.getShowSources();
        this.showLogAction = RiderNuGetToolWindowActions.Companion.getShowLog();
        this.logActionInfo = new NuGetNotificationButtonActionInfo(RdNuGetNotificationButton.Log, RiderNugetBundle.Companion.message("button.log", new Object[0]), "log", this.showLogAction);
        this.packageFolderActionInfo = new NuGetNotificationButtonActionInfo(RdNuGetNotificationButton.PackagesFolder, RiderNugetBundle.Companion.message("button.packages.folder", new Object[0]), "packages", this.openPackagesFolderAction);
        this.settingsActionInfo = new NuGetNotificationButtonActionInfo(RdNuGetNotificationButton.Settings, RiderNugetBundle.Companion.message("button.settings", new Object[0]), "settings", this.showSettingsAction);
        this.sourcesActionInfo = new NuGetNotificationButtonActionInfo(RdNuGetNotificationButton.Sources, RiderNugetBundle.Companion.message("button.sources", new Object[0]), "sources", this.showSourcesAction);
        Object[] objectArray = new NuGetNotificationButtonActionInfo[]{this.logActionInfo, this.packageFolderActionInfo, this.settingsActionInfo, this.sourcesActionInfo};
        this.actionsList = CollectionsKt.listOf((Object[])objectArray);
        this.listener = new NotificationListener.Adapter(this){
            final /* synthetic */ RiderNuGetNotifier this$0;
            {
                this.this$0 = $receiver;
            }

            protected void hyperlinkActivated(Notification notification2, HyperlinkEvent e2) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
                if (!this.this$0.getProject().isDisposed()) {
                    AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)DataManager.getInstance().getDataContext());
                    Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
                    AnActionEvent anActionEvent2 = anActionEvent;
                    String string = e2.getDescription();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                    RiderNuGetNotifier.access$hrefToAction(this.this$0, string).actionPerformed(anActionEvent2);
                    notification2.hideBalloon();
                }
            }
        };
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NotificationListener.Adapter getListener() {
        return this.listener;
    }

    private final AnAction G(String string) {
        Object t2;
        block1: {
            Iterable iterable = this.actionsList;
            boolean bl = false;
            for (Object t2 : iterable) {
                NuGetNotificationButtonActionInfo nuGetNotificationButtonActionInfo = (NuGetNotificationButtonActionInfo)t2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)nuGetNotificationButtonActionInfo.getHref(), (Object)string)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((NuGetNotificationButtonActionInfo)t2).getAction();
    }

    private final Notification b(@NlsContexts.NotificationTitle String string, @NlsContexts.NotificationContent String string2, NotificationType notificationType, List<? extends RdNuGetNotificationButton> list2) {
        String string3 = string;
        Object object = string2;
        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
            object = string3;
            string3 = "";
        }
        Content content = this.G();
        String string4 = content != null ? content.getDisplayName() : null;
        String string5 = this.G(list2, string4);
        object = (String)object + string5;
        String string6 = WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()] == 1 ? "ProblemsView Notification" : "NuGet";
        Notification notification2 = new Notification(string6, string3, (String)object, notificationType).setListener((NotificationListener)this.listener);
        Intrinsics.checkNotNullExpressionValue((Object)notification2, (String)"setListener(...)");
        Notification notification3 = notification2;
        notification3.setIcon(RiderIcons.Toolwindows.ToolWindowNuGet);
        return notification3;
    }

    private final Content G() {
        ContentManager contentManager = Companion.getContentManager(this.project);
        return contentManager != null ? contentManager.getSelectedContent() : null;
    }

    private final Notification G(@NlsContexts.NotificationTitle String string, @NlsContexts.NotificationContent String string2, NotificationType notificationType, List<? extends RdNuGetNotificationButton> list2) {
        Notification notification2 = this.b(string, string2, notificationType, list2);
        notification2.notify(this.project);
        if (notificationType == NotificationType.ERROR) {
            RiderProblemsViewIndicationService.Companion.getInstance(this.project);
        }
        return notification2;
    }

    static /* synthetic */ Notification notify$default(RiderNuGetNotifier riderNuGetNotifier, String string, String string2, NotificationType notificationType, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return riderNuGetNotifier.G(string, string2, notificationType, list2);
    }

    private final String G(List<? extends RdNuGetNotificationButton> list2, @NlsContexts.Button String string) {
        List list3 = new ArrayList();
        for (RdNuGetNotificationButton rdNuGetNotificationButton : list2) {
            NuGetNotificationButtonActionInfo nuGetNotificationButtonActionInfo = this.G(rdNuGetNotificationButton);
            if (Intrinsics.areEqual((Object)string, (Object)nuGetNotificationButtonActionInfo.getDisplayName())) continue;
            String string2 = HYPERLINK_TEMPLATE;
            Object[] objectArray = new Object[]{nuGetNotificationButtonActionInfo.getHref(), nuGetNotificationButtonActionInfo.getDisplayName()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            list3.add(string3);
        }
        return "<br/>" + CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)HYPERLINK_DELIMITER, null, null, (int)0, null, null, (int)62, null);
    }

    public final void notify(@NotNull RdNuGetNotification notification2) {
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
        this.lastNotification.put(notification2.getContext(), notification2);
        if (!this.amountOfFailedNotifications.containsKey(notification2.getContext())) {
            this.amountOfFailedNotifications.put(notification2.getContext(), 0);
        }
        if (notification2.getLevel() == RdNuGetNotificationLevel.Error || notification2.getLevel() == RdNuGetNotificationLevel.Exception) {
            RdNuGetNotificationContext rdNuGetNotificationContext = notification2.getContext();
            Integer n = this.amountOfFailedNotifications.get(notification2.getContext());
            Intrinsics.checkNotNull((Object)n);
            this.amountOfFailedNotifications.put(rdNuGetNotificationContext, ((Number)n).intValue() + 1);
        }
        NotificationType notificationType = this.G(notification2.getLevel());
        this.G(notification2.getTitle(), notification2.getMessage(), notificationType, notification2.getButtons());
    }

    @NotNull
    public final Notification notifyFromFrontend(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return RiderNuGetNotifier.notify$default(this, title2, message2, type, null, 8, null);
    }

    @Nullable
    public final RdNuGetNotification getLastNotification(@NotNull RdNuGetNotificationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.lastNotification.get(context);
    }

    public final int getAmountOfFailedNotifications(@NotNull RdNuGetNotificationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Integer n = this.amountOfFailedNotifications.get(context);
        return n != null ? n : 0;
    }

    private final NuGetNotificationButtonActionInfo G(RdNuGetNotificationButton rdNuGetNotificationButton) {
        return switch (WhenMappings.$EnumSwitchMapping$1[rdNuGetNotificationButton.ordinal()]) {
            case 1 -> this.settingsActionInfo;
            case 2 -> this.logActionInfo;
            case 3 -> this.packageFolderActionInfo;
            case 4 -> this.sourcesActionInfo;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final NotificationType G(RdNuGetNotificationLevel rdNuGetNotificationLevel) {
        return switch (WhenMappings.$EnumSwitchMapping$2[rdNuGetNotificationLevel.ordinal()]) {
            case 1 -> NotificationType.INFORMATION;
            case 2 -> NotificationType.WARNING;
            case 3 -> NotificationType.ERROR;
            case 4 -> NotificationType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final /* synthetic */ AnAction access$hrefToAction(RiderNuGetNotifier $this, String href) {
        return $this.G(href);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier$Companion;", "", "RiderNuGetNotifier$Companion", "()V", "NO_BREAK_SPACE", "", "HYPERLINK_TEMPLATE", "HYPERLINK_DELIMITER", "getContentManager", "Lcom/intellij/ui/content/ContentManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ContentManager getContentManager(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = RiderNuGetToolWindowFactory.Companion.getToolWindow(project);
            return toolWindow != null ? toolWindow.getContentManager() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J6\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\r\b\u0002\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier$NuGetNotificationButtonActionInfo;", "", "button", "Lcom/jetbrains/rider/model/RdNuGetNotificationButton;", "displayName", "", "Lcom/intellij/openapi/util/NlsContexts$Button;", "href", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "RiderNuGetNotifier$NuGetNotificationButtonActionInfo", "(Lcom/jetbrains/rider/model/RdNuGetNotificationButton;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/actionSystem/AnAction;)V", "getButton", "()Lcom/jetbrains/rider/model/RdNuGetNotificationButton;", "getDisplayName", "()Ljava/lang/String;", "getHref", "getAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    private static final class NuGetNotificationButtonActionInfo {
        @NotNull
        private final RdNuGetNotificationButton button;
        @NotNull
        private final String displayName;
        @NotNull
        private final String href;
        @NotNull
        private final AnAction action;

        public NuGetNotificationButtonActionInfo(@NotNull RdNuGetNotificationButton button, @NotNull String displayName, @NotNull String href, @NotNull AnAction action2) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            this.button = button;
            this.displayName = displayName;
            this.href = href;
            this.action = action2;
        }

        @NotNull
        public final RdNuGetNotificationButton getButton() {
            return this.button;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final String getHref() {
            return this.href;
        }

        @NotNull
        public final AnAction getAction() {
            return this.action;
        }

        @NotNull
        public final RdNuGetNotificationButton component1() {
            return this.button;
        }

        @NotNull
        public final String component2() {
            return this.displayName;
        }

        @NotNull
        public final String component3() {
            return this.href;
        }

        @NotNull
        public final AnAction component4() {
            return this.action;
        }

        @NotNull
        public final NuGetNotificationButtonActionInfo copy(@NotNull RdNuGetNotificationButton button, @NotNull String displayName, @NotNull String href, @NotNull AnAction action2) {
            Intrinsics.checkNotNullParameter((Object)button, (String)"button");
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            return new NuGetNotificationButtonActionInfo(button, displayName, href, action2);
        }

        public static /* synthetic */ NuGetNotificationButtonActionInfo copy$default(NuGetNotificationButtonActionInfo nuGetNotificationButtonActionInfo, RdNuGetNotificationButton rdNuGetNotificationButton, String string, String string2, AnAction anAction, int n, Object object) {
            if ((n & 1) != 0) {
                rdNuGetNotificationButton = nuGetNotificationButtonActionInfo.button;
            }
            if ((n & 2) != 0) {
                string = nuGetNotificationButtonActionInfo.displayName;
            }
            if ((n & 4) != 0) {
                string2 = nuGetNotificationButtonActionInfo.href;
            }
            if ((n & 8) != 0) {
                anAction = nuGetNotificationButtonActionInfo.action;
            }
            return nuGetNotificationButtonActionInfo.copy(rdNuGetNotificationButton, string, string2, anAction);
        }

        @NotNull
        public String toString() {
            return "NuGetNotificationButtonActionInfo(button=" + this.button + ", displayName=" + this.displayName + ", href=" + this.href + ", action=" + this.action + ")";
        }

        public int hashCode() {
            int n = this.button.hashCode();
            n = n * 31 + this.displayName.hashCode();
            n = n * 31 + this.href.hashCode();
            n = n * 31 + this.action.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NuGetNotificationButtonActionInfo)) {
                return false;
            }
            NuGetNotificationButtonActionInfo nuGetNotificationButtonActionInfo = (NuGetNotificationButtonActionInfo)other;
            if (this.button != nuGetNotificationButtonActionInfo.button) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.displayName, (Object)nuGetNotificationButtonActionInfo.displayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.href, (Object)nuGetNotificationButtonActionInfo.href)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.action, (Object)nuGetNotificationButtonActionInfo.action);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RdNuGetNotificationButton.values().length];
            try {
                nArray[RdNuGetNotificationButton.Settings.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationButton.Log.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationButton.PackagesFolder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationButton.Sources.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[RdNuGetNotificationLevel.values().length];
            try {
                nArray[RdNuGetNotificationLevel.Info.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationLevel.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationLevel.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetNotificationLevel.Exception.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

