/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.credentials.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.jcef.JBCefBrowser;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u001d\u0010\u0011\u001a\u0012\u0012\u000e\u0012\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00150\u0012H\u0014\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/nuget/credentials/dialogs/OAuthBrowserDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "url", "Ljava/net/URI;", "dialogTitle", "", "startupSize", "Ljava/awt/Dimension;", "authorizationCodeUrlPrefix", "OAuthBrowserDialog", "(Ljava/net/URI;Ljava/lang/String;Ljava/awt/Dimension;Ljava/lang/String;)V", "browser", "Lcom/intellij/ui/jcef/JBCefBrowser;", "authorizationCode", "getAuthorizationCode", "createCenterPanel", "Ljavax/swing/JComponent;", "createActions", "", "Ljavax/swing/Action;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "()[Ljavax/swing/Action;", "getPreferredFocusedComponent", "intellij.rider"})
public final class OAuthBrowserDialog
extends DialogWrapper {
    @NotNull
    private final URI url;
    @NotNull
    private final String dialogTitle;
    @NotNull
    private final Dimension startupSize;
    @NotNull
    private final String authorizationCodeUrlPrefix;
    @NotNull
    private final JBCefBrowser browser;
    @Nullable
    private String authorizationCode;

    public OAuthBrowserDialog(@NotNull URI url2, @NlsContexts.DialogTitle @NotNull String dialogTitle, @NotNull Dimension startupSize, @NotNull String authorizationCodeUrlPrefix) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)dialogTitle, (String)"dialogTitle");
        Intrinsics.checkNotNullParameter((Object)startupSize, (String)"startupSize");
        Intrinsics.checkNotNullParameter((Object)authorizationCodeUrlPrefix, (String)"authorizationCodeUrlPrefix");
        super(true);
        this.url = url2;
        this.dialogTitle = dialogTitle;
        this.startupSize = startupSize;
        this.authorizationCodeUrlPrefix = authorizationCodeUrlPrefix;
        this.browser = new JBCefBrowser();
        this.setTitle(this.dialogTitle);
        this.setModal(true);
        this.init();
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component2 = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component2, disposable);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.browser));
        this.browser.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadStart(CefBrowser browser, CefFrame frame2, CefRequest.TransitionType transitionType) {
                1 var4_4 = this;
                OAuthBrowserDialog oAuthBrowserDialog = this;
                1 var6_6 = var4_4;
                boolean bl = false;
                if (browser != null) {
                    String string = browser.getURL();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getURL(...)");
                    if (StringsKt.startsWith((String)string, (String)oAuthBrowserDialog.authorizationCodeUrlPrefix, (boolean)true)) {
                        String string2 = browser.getURL();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getURL(...)");
                        int n = StringsKt.indexOf$default((CharSequence)string2, (String)"code=", (int)0, (boolean)false, (int)6, null);
                        if (n > 0) {
                            Object v3;
                            OAuthBrowserDialog oAuthBrowserDialog2;
                            block6: {
                                URIBuilder uRIBuilder = new URIBuilder(browser.getURL());
                                List list2 = uRIBuilder.getQueryParams();
                                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getQueryParams(...)");
                                Iterable iterable = list2;
                                oAuthBrowserDialog2 = oAuthBrowserDialog;
                                boolean bl2 = false;
                                for (Object t : iterable) {
                                    NameValuePair nameValuePair = (NameValuePair)t;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)nameValuePair.getName(), (Object)"code")) continue;
                                    v3 = t;
                                    break block6;
                                }
                                v3 = null;
                            }
                            Object object = v3;
                            oAuthBrowserDialog2.authorizationCode = object != null ? object.getValue() : null;
                            object = oAuthBrowserDialog.authorizationCode;
                            if (!(object == null || object.length() == 0)) {
                                SwingUtilities.invokeLater(() -> 1.b(oAuthBrowserDialog));
                            } else {
                                SwingUtilities.invokeLater(() -> 1.G(oAuthBrowserDialog));
                            }
                        }
                    }
                }
            }

            private static final void b(OAuthBrowserDialog oAuthBrowserDialog) {
                oAuthBrowserDialog.doOKAction();
            }

            private static final void G(OAuthBrowserDialog oAuthBrowserDialog) {
                oAuthBrowserDialog.doCancelAction();
            }
        }, this.browser.getCefBrowser());
        this.browser.getComponent().setMinimumSize(this.startupSize);
        this.browser.loadURL(this.url.toString());
    }

    @Nullable
    public final String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        this.setTitle(this.dialogTitle);
        JComponent jComponent = this.browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        return actionArray;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.browser.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }
}

