/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.configs;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR/\u0010\u000b\u001a#\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u000f0\u000f0\f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedColorManager;", "", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "RiderNuGetFeedColorManager", "(Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;)V", "feeds", "", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "G", "()Ljava/util/List;", "colorMap", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "G", "", "getColor", "feed", "Companion", "intellij.rider"})
public final class RiderNuGetFeedColorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RiderNuGetFeedManager feedManager;
    @NotNull
    private final HashMap<String, Color> colorMap;
    @NotNull
    private static final Color[] sourceColors;

    public RiderNuGetFeedColorManager(@NotNull RiderNuGetFeedManager feedManager) {
        Intrinsics.checkNotNullParameter((Object)feedManager, (String)"feedManager");
        this.feedManager = feedManager;
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.colorMap = hashMap;
        this.G();
        this.feedManager.addListChangesListener((Function0<Unit>)((Function0)() -> RiderNuGetFeedColorManager.G(this)));
    }

    private final List<RdNuGetFeed> G() {
        return this.feedManager.getAllFeeds();
    }

    private final void G() {
        this.colorMap.clear();
        int n = 0;
        for (RdNuGetFeed rdNuGetFeed : this.G()) {
            Color color = null;
            if (n >= sourceColors.length) {
                Color color2;
                double d = (double)(n / sourceColors.length) / (double)(this.G().size() / sourceColors.length);
                Intrinsics.checkNotNullExpressionValue((Object)ColorUtil.mix((Color)sourceColors[n % sourceColors.length], (Color)sourceColors[(n + 1) % sourceColors.length], (double)d), (String)"mix(...)");
                int n2 = (int)(Math.abs(d - 0.5) * 2.0 * (double)(this.G().size() / sourceColors.length) + 1.0);
                color = (Color)new JBColor(ColorUtil.darker((Color)color2, (int)n2), ColorUtil.brighter((Color)color2, (int)(2 * n2)));
            } else {
                color = sourceColors[n];
            }
            ++n;
            this.colorMap.put(rdNuGetFeed.getFeedId(), color);
        }
    }

    @NotNull
    public final Color getColor(@NotNull RdNuGetFeed feed) {
        Intrinsics.checkNotNullParameter((Object)feed, (String)"feed");
        Color color = this.colorMap.get(feed.getFeedId());
        if (color == null) {
            color = RiderNuGetFeedColorManager.Companion.G();
        }
        return color;
    }

    private static final Unit G(RiderNuGetFeedColorManager riderNuGetFeedColorManager) {
        riderNuGetFeedColorManager.G();
        return Unit.INSTANCE;
    }

    static {
        Color[] colorArray = new Color[]{JBColor.GREEN, JBColor.ORANGE, JBColor.CYAN, JBColor.MAGENTA, JBColor.PINK, JBColor.YELLOW, JBColor.BLUE};
        sourceColors = colorArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedColorManager$Companion;", "", "RiderNuGetFeedColorManager$Companion", "()V", "sourceColors", "", "Ljava/awt/Color;", "kotlin.jvm.PlatformType", "[Ljava/awt/Color;", "defaultRootColor", "G", "()Ljava/awt/Color;", "getBackgroundColor", "Lcom/intellij/ui/JBColor;", "baseRootColor", "getIndicatorColor", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        private final Color G() {
            Color color = UIUtil.getTableBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTableBackground(...)");
            return color;
        }

        @NotNull
        public final JBColor getBackgroundColor(@NotNull Color baseRootColor) {
            Intrinsics.checkNotNullParameter((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor(() -> Companion.G(baseRootColor));
        }

        @NotNull
        public final JBColor getIndicatorColor(@NotNull Color baseRootColor) {
            Intrinsics.checkNotNullParameter((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor(() -> Companion.b(baseRootColor));
        }

        private static final Color G(Color color) {
            return ColorUtil.mix((Color)color, (Color)UIUtil.getTableBackground(), (double)0.75);
        }

        private static final Color b(Color color) {
            return UIUtil.isUnderDarcula() ? color : ColorUtil.darker((Color)ColorUtil.softer((Color)color), (int)3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

