/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdNuGetDependencyBehavior;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetHost;
import com.jetbrains.rider.model.RdNuGetHost_PregeneratedKt;
import com.jetbrains.rider.model.RdNuGetInstallOneRequest;
import com.jetbrains.rider.model.RdNuGetInstallRequest;
import com.jetbrains.rider.model.RdNuGetNotificationMode;
import com.jetbrains.rider.model.RdNuGetOperator;
import com.jetbrains.rider.model.RdNuGetPackageIdentity;
import com.jetbrains.rider.model.RdNuGetPackageMetadata;
import com.jetbrains.rider.model.RdNuGetProject;
import com.jetbrains.rider.model.RdNuGetProjects;
import com.jetbrains.rider.model.RdNuGetRemoteVersion;
import com.jetbrains.rider.model.RdNuGetRemovePackageVersionResult;
import com.jetbrains.rider.model.RdNuGetRestoreRequest;
import com.jetbrains.rider.model.RdNuGetRestoreRequestSource;
import com.jetbrains.rider.model.RdNuGetRestoreStrategy;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.model.RdNuGetStateInfo;
import com.jetbrains.rider.model.RdNuGetUltraConfig;
import com.jetbrains.rider.model.RdNuGetUninstallRequest;
import com.jetbrains.rider.model.RdNuGetUpdateAllRequest;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.rider.nuget.RiderNuGetProjectModel;
import com.jetbrains.rider.nuget.RiderNuGetViewSettings;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.rider.nuget.confirmations.RiderNuGetInstallConfirmationDialog;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConstants;
import com.jetbrains.rider.nuget.helpers.RiderNuGetNotifier;
import com.jetbrains.rider.nuget.helpers.RiderNuGetProjects;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u0099\u00012\u00020\u0001:\u0002\u0099\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u00100\u001a\u00020*J\u000e\u0010I\u001a\u00020*2\u0006\u0010J\u001a\u00020;J\u0016\u0010K\u001a\u00020L2\u0006\u0010J\u001a\u00020;2\u0006\u0010M\u001a\u00020;J\u000e\u0010N\u001a\u00020*2\u0006\u0010O\u001a\u000203J\u000e\u0010P\u001a\u00020*2\u0006\u0010Q\u001a\u000203J\u000e\u0010R\u001a\u00020*2\u0006\u0010S\u001a\u00020TJ\u0006\u0010U\u001a\u00020*J\u0006\u0010V\u001a\u00020*J\u0006\u0010W\u001a\u00020*J\u000e\u0010X\u001a\u00020*2\u0006\u0010Y\u001a\u00020;J\u0014\u0010^\u001a\u0002032\f\u0010_\u001a\b\u0012\u0004\u0012\u00020B0AJ\u000e\u0010`\u001a\u00020;2\u0006\u0010J\u001a\u00020.J\u0006\u0010a\u001a\u00020*J\u0006\u0010b\u001a\u00020*J\u001e\u0010c\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020[2\u0006\u0010J\u001a\u00020;2\u0006\u0010M\u001a\u00020;J\u0016\u0010d\u001a\u00020*2\u0006\u0010J\u001a\u00020;2\u0006\u0010M\u001a\u00020;J\u001e\u0010e\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020;2\u0006\u0010J\u001a\u00020;2\u0006\u0010M\u001a\u00020;J\u0006\u0010f\u001a\u000203J\f\u0010g\u001a\u000203*\u00020;H\u0002J\f\u0010g\u001a\u000203*\u00020BH\u0002J\u0014\u0010h\u001a\u000203*\u00020B2\u0006\u0010i\u001a\u00020jH\u0002J\u000e\u0010k\u001a\u00020*2\u0006\u0010l\u001a\u000203J\u0016\u0010m\u001a\u00020*2\u0006\u0010\u0018\u001a\u00020[2\u0006\u0010n\u001a\u00020;J\u000e\u0010o\u001a\u00020*2\u0006\u0010n\u001a\u00020;J\u0016\u0010p\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020;2\u0006\u0010J\u001a\u00020;J\"\u0010q\u001a\u00020*2\u0006\u0010r\u001a\u00020s2\b\b\u0002\u0010t\u001a\u00020u2\b\b\u0002\u0010v\u001a\u00020wJ\u0010\u0010x\u001a\u00020*2\b\b\u0002\u0010t\u001a\u00020uJ\u0010\u0010y\u001a\u00020*2\b\b\u0002\u0010t\u001a\u00020uJ$\u0010z\u001a\u00020*2\b\b\u0002\u0010{\u001a\u00020|2\u0012\u0010}\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020*0~J'\u0010\u0081\u0001\u001a\u00020*2\t\b\u0002\u0010\u0082\u0001\u001a\u0002032\t\b\u0002\u0010\u0083\u0001\u001a\u0002032\b\b\u0002\u0010{\u001a\u00020|J'\u0010\u0084\u0001\u001a\u00020;\"\u000b\b\u0000\u0010\u0085\u0001\u0018\u0001*\u00020\u00012\u000e\u0010\u0086\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0085\u000102H\u0082\bJ\u0007\u0010\u008b\u0001\u001a\u00020*J\u0010\u0010\u008c\u0001\u001a\u00020*2\u0007\u0010\u008d\u0001\u001a\u000203J\r\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020.0AJ\t\u0010\u008f\u0001\u001a\u0004\u0018\u00010;J\u0010\u0010\u0090\u0001\u001a\u00020*2\u0007\u0010\u0091\u0001\u001a\u00020;J\u0010\u0010\u0092\u0001\u001a\u0002032\u0007\u0010\u0093\u0001\u001a\u00020;J\u0018\u0010\u0094\u0001\u001a\u00020*2\u0006\u0010n\u001a\u00020;2\u0007\u0010\u0095\u0001\u001a\u00020.J\u001b\u0010\u0096\u0001\u001a\u0002032\u0006\u0010n\u001a\u00020;2\b\u0010\u0097\u0001\u001a\u00030\u0098\u0001H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020.0)\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,R\u0017\u00101\u001a\b\u0012\u0004\u0012\u000203028F\u00a2\u0006\u0006\u001a\u0004\b1\u00104R\u0011\u00105\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010=R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010=R\u0011\u0010G\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010=R\u0011\u0010Z\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010]R\u000f\u0010\u007f\u001a\u00030\u0080\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0087\u0001\u001a\u00030\u0088\u0001\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001\u00a8\u0006\u009a\u0001"}, d2={"Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderNuGetFacade", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "host", "Lcom/jetbrains/rider/model/RdNuGetHost;", "getHost", "()Lcom/jetbrains/rider/model/RdNuGetHost;", "operator", "Lcom/jetbrains/rider/model/RdNuGetOperator;", "getOperator", "()Lcom/jetbrains/rider/model/RdNuGetOperator;", "notifier", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier;", "getNotifier", "()Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier;", "projects", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects;", "getProjects", "()Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects;", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "getFeedManager", "()Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "viewSettings", "Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "getViewSettings", "()Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "projectModel", "Lcom/jetbrains/rider/nuget/RiderNuGetProjectModel;", "getProjectModel", "()Lcom/jetbrains/rider/nuget/RiderNuGetProjectModel;", "focusSearchBox", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getFocusSearchBox", "()Lcom/jetbrains/rd/util/reactive/Signal;", "selectPanel", "", "getSelectPanel", "selectPackagesPanel", "isBusy", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "isBusyRightNow", "()Z", "contextProjectId", "getContextProjectId", "()I", "contextProjectTitle", "", "getContextProjectTitle", "()Ljava/lang/String;", "contextUniqueProjectTitle", "getContextUniqueProjectTitle", "foundPackages", "", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "getFoundPackages", "()Ljava/util/List;", "targetPackageId", "getTargetPackageId", "targetPackageFeedId", "getTargetPackageFeedId", "choosePackage", "id", "choosePackageAndWait", "Lcom/jetbrains/rider/model/RdNuGetPackageMetadata;", "version", "setRemoveDependenciesOption", "removeDependencies", "setForceRemoveOption", "forceRemove", "setDependencyBehaviour", "behaviour", "Lcom/jetbrains/rider/model/RdNuGetDependencyBehavior;", "readNuGetConfig", "clearChosenPackage", "clearCache", "setSearchTerm", "term", "allProjects", "Lcom/jetbrains/rider/model/RdNuGetProjects;", "getAllProjects", "()Lcom/jetbrains/rider/model/RdNuGetProjects;", "hasUpdates", "packages", "getUniqueProjectNameById", "zeroLatencyUpdate", "zeroLatencyUpdateAndWait", "install", "installForAllProjects", "installForProject", "hasUpdatesInContext", "G", "G", "installedPackage", "Lcom/jetbrains/rider/model/RdNuGetPackageIdentity;", "upgradeAllInContext", "confirmation", "uninstall", "packageId", "uninstallFromAllProjects", "uninstallFromProject", "restore", "mode", "Lcom/jetbrains/rider/model/RdNuGetNotificationMode;", "strategy", "Lcom/jetbrains/rider/model/RdNuGetRestoreStrategy;", "source", "Lcom/jetbrains/rider/model/RdNuGetRestoreRequestSource;", "forceRestore", "silentRestore", "runAndWait", "timeout", "Ljava/time/Duration;", "action", "Lkotlin/Function1;", "runTaskCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "waitForSteadyState", "clearCaches", "validConfig", "G", "T", "property", "helpAction", "Lcom/intellij/ide/actions/ContextHelpAction;", "getHelpAction", "()Lcom/intellij/ide/actions/ContextHelpAction;", "toggleIncludePrerelease", "setIncludePrerelease", "value", "getContextProjectIds", "getErrorMessageUltraConfig", "setFeedByName", "feedName", "isNuGetOrgFeed", "feedId", "showLastPackageVersionDialog", "projectId", "G", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,314:1\n264#1:346\n264#1:347\n264#1:348\n264#1:349\n1755#2,3:315\n295#2,2:318\n1557#2:320\n1628#2,3:321\n1755#2,3:324\n1734#2,3:329\n1755#2,3:332\n1863#2,2:335\n774#2:337\n865#2:338\n295#2,2:339\n866#2:341\n295#2,2:342\n295#2,2:344\n1069#3,2:327\n*S KotlinDebug\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade\n*L\n240#1:346\n256#1:347\n257#1:348\n258#1:349\n103#1:315,3\n111#1:318,2\n133#1:320\n133#1:321,3\n139#1:324,3\n146#1:329,3\n150#1:332,3\n171#1:335,2\n181#1:337\n181#1:338\n185#1:339,2\n181#1:341\n283#1:342,2\n161#1:344,2\n143#1:327,2\n*E\n"})
public final class RiderNuGetFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LifetimeDefinition lifetime;
    @NotNull
    private final RdNuGetHost host;
    @NotNull
    private final RdNuGetOperator operator;
    @NotNull
    private final RiderNuGetNotifier notifier;
    @NotNull
    private final RiderNuGetProjects projects;
    @NotNull
    private final RiderNuGetFeedManager feedManager;
    @NotNull
    private final Signal<Unit> focusSearchBox;
    @NotNull
    private final Signal<Integer> selectPanel;
    @NotNull
    private final AtomicInteger runTaskCount;
    @NotNull
    private final ContextHelpAction helpAction;
    @NotNull
    private static final String LAST_PACKAGE_VERSION_DIALOG_PROPERTY = "lastPackageVersionDialogProperty";

    public RiderNuGetFacade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.host = RdNuGetHost_PregeneratedKt.getNuGetHost((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        this.operator = this.host.getNuGetOperator();
        this.notifier = new RiderNuGetNotifier(this.project);
        this.projects = new RiderNuGetProjects(this.project);
        this.feedManager = new RiderNuGetFeedManager((Lifetime)this.lifetime, this.host.getConfigManager());
        this.focusSearchBox = Signal.Companion.Void();
        this.selectPanel = new Signal();
        this.runTaskCount = new AtomicInteger();
        this.helpAction = new ContextHelpAction("Reference_Windows_NuGet");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RdNuGetHost getHost() {
        return this.host;
    }

    @NotNull
    public final RdNuGetOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public final RiderNuGetNotifier getNotifier() {
        return this.notifier;
    }

    @NotNull
    public final RiderNuGetProjects getProjects() {
        return this.projects;
    }

    @NotNull
    public final RiderNuGetFeedManager getFeedManager() {
        return this.feedManager;
    }

    @NotNull
    public final RiderNuGetViewSettings getViewSettings() {
        return RiderNuGetViewSettings.Companion.getInstance(this.project);
    }

    @NotNull
    public final RiderNuGetProjectModel getProjectModel() {
        return RiderNuGetProjectModel.Companion.getInstance(this.project);
    }

    @NotNull
    public final Signal<Unit> getFocusSearchBox() {
        return this.focusSearchBox;
    }

    @NotNull
    public final Signal<Integer> getSelectPanel() {
        return this.selectPanel;
    }

    public final void selectPackagesPanel() {
        this.selectPanel.fire((Object)0);
    }

    @NotNull
    public final IOptProperty<Boolean> isBusy() {
        return this.operator.isBusy();
    }

    public final boolean isBusyRightNow() {
        return (Boolean)InterfacesKt.valueOrDefault(this.isBusy(), (Object)true);
    }

    public final int getContextProjectId() {
        return ((Number)InterfacesKt.valueOrDefault((IOptProperty)this.host.getContextProjectId(), (Object)-1)).intValue();
    }

    @NotNull
    public final String getContextProjectTitle() {
        return this.getProjectModel().getProjectNameById(this.getContextProjectId());
    }

    @NotNull
    public final String getContextUniqueProjectTitle() {
        return this.getUniqueProjectNameById(this.getContextProjectId());
    }

    @NotNull
    public final List<RdNuGetSmartMetadata> getFoundPackages() {
        return (List)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), RiderNuGetConstants.Companion.getEmptyPackages());
    }

    @NotNull
    public final String getTargetPackageId() {
        return (String)InterfacesKt.valueOrDefault((IOptProperty)this.host.getTargetPackageId(), (Object)"");
    }

    @NotNull
    public final String getTargetPackageFeedId() {
        return (String)InterfacesKt.valueOrDefault((IOptProperty)this.host.getTargetPackageFeedId(), (Object)"");
    }

    public final void choosePackage(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (!Intrinsics.areEqual((Object)this.getTargetPackageId(), (Object)id2)) {
            this.host.getTargetPackageId().set((Object)id2);
            this.zeroLatencyUpdate();
        }
    }

    @NotNull
    public final RdNuGetPackageMetadata choosePackageAndWait(@NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        LifetimeDefinition lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        this.host.getChosenPackageMeta().advise(lifetimeDefinition.getLifetime(), arg_0 -> RiderNuGetFacade.G(objectRef, lifetimeDefinition, arg_0));
        this.choosePackage(id2);
        Lifetime lifetime = (Lifetime)this.lifetime;
        Function0 function0 = () -> RiderNuGetFacade.G(objectRef);
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump$default((Lifetime)lifetime, (Function0)function0, (Duration)duration, null, (int)8, null);
        Object object = objectRef.element;
        Intrinsics.checkNotNull((Object)object);
        return (RdNuGetPackageMetadata)object;
    }

    public final void setRemoveDependenciesOption(boolean removeDependencies) {
        this.host.getRemoveDependencies().set((Object)removeDependencies);
    }

    public final void setForceRemoveOption(boolean forceRemove) {
        this.host.getForceRemove().set((Object)forceRemove);
    }

    public final void setDependencyBehaviour(@NotNull RdNuGetDependencyBehavior behaviour) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        this.host.getDependencyBehavior().set((Object)behaviour);
    }

    public final void readNuGetConfig() {
        InterfacesKt.fire((ISignal)this.host.getConfigManager().getReload());
    }

    public final void clearChosenPackage() {
        this.choosePackage("");
    }

    public final void clearCache() {
        InterfacesKt.fire((ISignal)this.host.getClearCache());
    }

    public final void setSearchTerm(@NotNull String term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.host.getSearchTerm().set((Object)term);
    }

    @NotNull
    public final RdNuGetProjects getAllProjects() {
        return new RdNuGetProjects(this.projects.getAllProjectIds());
    }

    public final boolean hasUpdates(@NotNull List<RdNuGetSmartMetadata> packages) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(packages, (String)"packages");
            Iterable iterable = packages;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata = (RdNuGetSmartMetadata)t;
                    boolean bl3 = false;
                    if (!rdNuGetSmartMetadata.getCanBeUpdated()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String getUniqueProjectNameById(int id2) {
        Object v1;
        Object object;
        List<ProjectModelEntity> list2;
        block2: {
            if (id2 == -1) {
                return "Solution";
            }
            list2 = this.projects.getAllProjectEntities();
            object = list2;
            boolean bl = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                boolean bl2 = false;
                Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)this.project);
                int n2 = id2;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        ProjectModelEntity projectModelEntity = v1;
        object = ProjectModelEntityExtensionsKt.withUniqueNames(list2, (Project)this.project);
        return object.getOrDefault(projectModelEntity, "Loading...");
    }

    public final void zeroLatencyUpdate() {
        InterfacesKt.fire((ISignal)this.host.getZeroLatencyUpdate());
    }

    public final void zeroLatencyUpdateAndWait() {
        LifetimeDefinition lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        Lifetime lifetime = lifetimeDefinition.getLifetime();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        this.host.getZeroLatencyUpdateFinished().advise(lifetime, arg_0 -> RiderNuGetFacade.G(booleanRef, arg_0));
        InterfacesKt.fire((ISignal)this.host.getZeroLatencyUpdate());
        Function0 function0 = () -> RiderNuGetFacade.G(booleanRef);
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump$default((Lifetime)lifetime, (Function0)function0, (Duration)duration, null, (int)8, null);
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
    }

    public final void install(@NotNull RdNuGetProjects projects, @NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (CollectionsKt.any((Iterable)projects.getProjectIds()) && !Intrinsics.areEqual((Object)id2, (Object)"") && !Intrinsics.areEqual((Object)version, (Object)"")) {
            Iterable iterable = projects.getProjectIds();
            ISignal iSignal = this.operator.getInstall();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                int n = ((Number)t).intValue();
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new RdNuGetInstallOneRequest(n, id2, version));
            }
            List list2 = (List)collection;
            iSignal.fire((Object)new RdNuGetInstallRequest(list2));
        }
    }

    public final void installForAllProjects(@NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.install(this.getAllProjects(), id2, version);
    }

    public final void installForProject(@NotNull String project, @NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.install(this.getProjectModel().getProjectsByName(project), id2, version);
    }

    public final boolean hasUpdatesInContext() {
        boolean bl;
        block3: {
            Iterable iterable = (Iterable)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), (Object)CollectionsKt.emptyList());
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata = (RdNuGetSmartMetadata)t;
                    boolean bl3 = false;
                    if (!(rdNuGetSmartMetadata.getCanBeUpdated() && this.G(rdNuGetSmartMetadata))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean G(String string) {
        boolean bl;
        block1: {
            Object object = new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*')};
            Set set = SetsKt.setOf((Object[])object);
            object = string;
            boolean bl2 = false;
            for (int j = 0; j < object.length(); ++j) {
                char c;
                char c2 = c = object.charAt(j);
                boolean bl3 = false;
                if (!set.contains(Character.valueOf(c2))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean G(RdNuGetSmartMetadata rdNuGetSmartMetadata) {
        boolean bl;
        block3: {
            Iterable iterable = rdNuGetSmartMetadata.getVersionRanges();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl3 = false;
                    if (this.G(string)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean G(RdNuGetSmartMetadata rdNuGetSmartMetadata, RdNuGetPackageIdentity rdNuGetPackageIdentity) {
        boolean bl;
        boolean bl2;
        block3: {
            bl2 = CollectionsKt.any((Iterable)rdNuGetSmartMetadata.getAvailableVersions()) && !Intrinsics.areEqual((Object)((RdNuGetRemoteVersion)CollectionsKt.last((List)rdNuGetSmartMetadata.getAvailableVersions())).getVersion(), (Object)rdNuGetPackageIdentity.getVersion());
            Iterable iterable = rdNuGetSmartMetadata.getVersionRanges();
            boolean bl3 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl4 = false;
                    if (!(!this.G(string))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        return bl2 && !bl5;
    }

    public final void upgradeAllInContext(boolean confirmation) {
        List<RdNuGetInstallOneRequest> list2;
        int n;
        Object object2;
        List<RdNuGetInstallOneRequest> list3 = new ArrayList();
        List list4 = (List)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), (Object)CollectionsKt.emptyList());
        int n2 = this.getContextProjectId();
        if (n2 == -1) {
            Iterable iterable = this.projects.getAllProjectIds();
            boolean bl = false;
            for (Object object2 : iterable) {
                n = ((Number)object2).intValue();
                boolean bl2 = false;
                RiderNuGetFacade.G(this, list4, list3, n);
            }
        } else {
            RiderNuGetFacade.G(this, list4, list3, n2);
        }
        boolean bl = confirmation;
        if (bl) {
            Object[] objectArray = new Object[]{this.getContextProjectTitle()};
            list2 = RiderNuGetInstallConfirmationDialog.INSTANCE.show(this.getProjectModel(), RiderNugetBundle.Companion.message("RiderNuGetFacade.dialog.title.upgrade.all.packages.in", objectArray), RiderActionsBundle.Companion.message("action.upgrade.text", new Object[0]), list3);
        } else if (!bl) {
            list2 = list3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Iterable iterable = list2;
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        object2 = new ArrayList();
        n = 0;
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object v1;
            String string;
            Object object3;
            Object t;
            block12: {
                t = iterator2.next();
                RdNuGetInstallOneRequest rdNuGetInstallOneRequest = (RdNuGetInstallOneRequest)t;
                boolean bl4 = false;
                object3 = this.getProjectModel().getProjectInfoById(rdNuGetInstallOneRequest.getProjectId()).getExplicitPackages();
                string = rdNuGetInstallOneRequest.getPackageVersion();
                boolean bl5 = false;
                Iterator iterator3 = object3.iterator();
                while (iterator3.hasNext()) {
                    Object t2 = iterator3.next();
                    RdNuGetPackageIdentity rdNuGetPackageIdentity = (RdNuGetPackageIdentity)t2;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)rdNuGetPackageIdentity.getId(), (Object)rdNuGetInstallOneRequest.getPackageId())) continue;
                    v1 = t2;
                    break block12;
                }
                v1 = null;
            }
            RdNuGetPackageIdentity rdNuGetPackageIdentity = v1;
            boolean bl7 = !Intrinsics.areEqual((Object)string, (Object)(rdNuGetPackageIdentity != null && (object3 = rdNuGetPackageIdentity.getVersion()) != null ? object3 : ""));
            if (!bl7) continue;
            object2.add(t);
        }
        List list5 = (List)object2;
        if (CollectionsKt.any((Iterable)list5) && list3.size() == list5.size() && StringsKt.isBlank((CharSequence)((CharSequence)InterfacesKt.valueOrDefault((IOptProperty)this.host.getSearchTerm(), (Object)"")))) {
            this.operator.getUpdateAll().fire((Object)new RdNuGetUpdateAllRequest(this.getContextProjectId()));
        } else if (CollectionsKt.any((Iterable)list5)) {
            this.operator.getInstall().fire((Object)new RdNuGetInstallRequest(list5));
        }
    }

    public final void uninstall(@NotNull RdNuGetProjects projects, @NotNull String packageId) {
        Intrinsics.checkNotNullParameter((Object)projects, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        if (CollectionsKt.any((Iterable)projects.getProjectIds()) && !Intrinsics.areEqual((Object)packageId, (Object)"")) {
            this.operator.getUninstall().fire((Object)new RdNuGetUninstallRequest(projects, packageId));
        }
    }

    public final void uninstallFromAllProjects(@NotNull String packageId) {
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        this.uninstall(this.getAllProjects(), packageId);
    }

    public final void uninstallFromProject(@NotNull String project, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.uninstall(this.getProjectModel().getProjectsByName(project), id2);
    }

    public final void restore(@NotNull RdNuGetNotificationMode mode, @NotNull RdNuGetRestoreStrategy strategy, @NotNull RdNuGetRestoreRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.operator.getRestore().fire((Object)new RdNuGetRestoreRequest(mode, strategy, source));
    }

    public static /* synthetic */ void restore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetNotificationMode rdNuGetNotificationMode, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, RdNuGetRestoreRequestSource rdNuGetRestoreRequestSource, int n, Object object) {
        if ((n & 2) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        if ((n & 4) != 0) {
            rdNuGetRestoreRequestSource = RdNuGetRestoreRequestSource.Default;
        }
        riderNuGetFacade.restore(rdNuGetNotificationMode, rdNuGetRestoreStrategy, rdNuGetRestoreRequestSource);
    }

    public final void forceRestore(@NotNull RdNuGetRestoreStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        RiderNuGetFacade.restore$default(this, RiderNuGetConstants.Companion.getForceMode(), strategy, null, 4, null);
    }

    public static /* synthetic */ void forceRestore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, int n, Object object) {
        if ((n & 1) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        riderNuGetFacade.forceRestore(rdNuGetRestoreStrategy);
    }

    public final void silentRestore(@NotNull RdNuGetRestoreStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        RiderNuGetFacade.restore$default(this, RiderNuGetConstants.Companion.getSilentMode(), strategy, null, 4, null);
    }

    public static /* synthetic */ void silentRestore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, int n, Object object) {
        if ((n & 1) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        riderNuGetFacade.silentRestore(rdNuGetRestoreStrategy);
    }

    public final void runAndWait(@NotNull Duration timeout, @NotNull Function1<? super RiderNuGetFacade, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)this);
        RiderNuGetFacade.waitForSteadyState$default(this, false, false, timeout, 3, null);
    }

    public static /* synthetic */ void runAndWait$default(RiderNuGetFacade riderNuGetFacade, Duration duration, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            duration = Duration.ofSeconds(500L);
        }
        riderNuGetFacade.runAndWait(duration, (Function1<? super RiderNuGetFacade, Unit>)function1);
    }

    public final void waitForSteadyState(boolean clearCaches, boolean validConfig, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        if (clearCaches) {
            this.clearCache();
        }
        this.zeroLatencyUpdateAndWait();
        RdNuGetStateInfo rdNuGetStateInfo = this.host.getStateInfo();
        ExtensionsKt.waitAndPump((Lifetime)((Lifetime)this.lifetime), () -> RiderNuGetFacade.G(this, rdNuGetStateInfo, validConfig), (Duration)timeout, () -> RiderNuGetFacade.G(this, rdNuGetStateInfo));
        this.zeroLatencyUpdateAndWait();
        ExtensionsKt.waitAndPump((Lifetime)((Lifetime)this.lifetime), () -> RiderNuGetFacade.G(this, rdNuGetStateInfo), (Duration)timeout, () -> RiderNuGetFacade.b(this, rdNuGetStateInfo));
    }

    public static /* synthetic */ void waitForSteadyState$default(RiderNuGetFacade riderNuGetFacade, boolean bl, boolean bl2, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            duration = Duration.ofSeconds(500L);
        }
        riderNuGetFacade.waitForSteadyState(bl, bl2, duration);
    }

    private final /* synthetic */ <T> String G(IOptProperty<T> iOptProperty) {
        boolean bl = false;
        Object object = iOptProperty.getValueOrNull();
        if (object == null || (object = object.toString()) == null) {
            object = "NA";
        }
        return object;
    }

    @NotNull
    public final ContextHelpAction getHelpAction() {
        return this.helpAction;
    }

    public final void toggleIncludePrerelease() {
        this.host.getIncludePrerelease().set((Object)(!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.host.getIncludePrerelease())) ? 1 : 0));
    }

    public final void setIncludePrerelease(boolean value2) {
        this.host.getIncludePrerelease().set((Object)value2);
    }

    @NotNull
    public final List<Integer> getContextProjectIds() {
        return this.getContextProjectId() == -1 ? this.getAllProjects().getProjectIds() : CollectionsKt.listOf((Object)this.getContextProjectId());
    }

    @Nullable
    public final String getErrorMessageUltraConfig() {
        RdNuGetUltraConfig rdNuGetUltraConfig = (RdNuGetUltraConfig)this.host.getConfigManager().getUltraConfig().getValueOrNull();
        return rdNuGetUltraConfig != null ? rdNuGetUltraConfig.getErrorMessage() : null;
    }

    public final void setFeedByName(@NotNull String feedName) {
        Intrinsics.checkNotNullParameter((Object)feedName, (String)"feedName");
        RdNuGetFeed rdNuGetFeed = this.feedManager.getFeedByName(feedName);
        Intrinsics.checkNotNull((Object)rdNuGetFeed);
        this.feedManager.setVisibleOnly(rdNuGetFeed);
    }

    public final boolean isNuGetOrgFeed(@NotNull String feedId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)feedId, (String)"feedId");
            Iterable iterable = BeGetterExtensionsKt.valueOrEmpty((IOptProperty)this.host.getConfigManager().getKnownFeeds());
            boolean bl = false;
            for (Object t : iterable) {
                RdNuGetFeed rdNuGetFeed = (RdNuGetFeed)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)rdNuGetFeed.getFeedId(), (Object)feedId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        RdNuGetFeed rdNuGetFeed = v0;
        return rdNuGetFeed != null ? rdNuGetFeed.isNuGetOrg() : false;
    }

    public final void showLastPackageVersionDialog(@NotNull String packageId, int projectId) {
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.project);
        boolean bl = propertiesComponent.getBoolean(LAST_PACKAGE_VERSION_DIALOG_PROPERTY, false);
        if (!bl) {
            Intrinsics.checkNotNull((Object)propertiesComponent);
            if (this.G(packageId, propertiesComponent)) {
                this.host.getNuGetOperator().getRequestRemovePackageVersionAccept().fire((Object)new RdNuGetRemovePackageVersionResult(projectId, packageId));
            }
            return;
        }
        this.host.getNuGetOperator().getRequestRemovePackageVersionAccept().fire((Object)new RdNuGetRemovePackageVersionResult(projectId, packageId));
    }

    private final boolean G(String string, PropertiesComponent propertiesComponent) {
        Object[] objectArray = new Object[]{string};
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(RiderBundle.message("dialog.title.you.ve.deleted.last.packagereference.for.in.this.solution", objectArray), RiderBundle.message("dialog.message.do.you.want.to.also.delete.packageversion.item.for.this.package", new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(propertiesComponent){
            final /* synthetic */ PropertiesComponent $properties;
            {
                this.$properties = $properties;
            }

            public boolean isSelectedByDefault() {
                return false;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                this.$properties.setValue("lastPackageVersionDialogProperty", isSelected);
            }
        })).ask(this.project);
    }

    private static final Unit G(Ref.ObjectRef objectRef, LifetimeDefinition lifetimeDefinition, RdNuGetPackageMetadata rdNuGetPackageMetadata) {
        if (rdNuGetPackageMetadata != null) {
            objectRef.element = rdNuGetPackageMetadata;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean G(Ref.ObjectRef objectRef) {
        return objectRef.element != null;
    }

    private static final Unit G(Ref.BooleanRef booleanRef, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        booleanRef.element = true;
        return Unit.INSTANCE;
    }

    private static final boolean G(Ref.BooleanRef booleanRef) {
        return booleanRef.element;
    }

    private static final void G(RiderNuGetFacade riderNuGetFacade, List<RdNuGetSmartMetadata> list2, List<RdNuGetInstallOneRequest> list3, int n) {
        RdNuGetProject rdNuGetProject = riderNuGetFacade.getProjectModel().getProjectInfoById(n);
        for (RdNuGetPackageIdentity rdNuGetPackageIdentity : rdNuGetProject.getExplicitPackages()) {
            RdNuGetSmartMetadata rdNuGetSmartMetadata;
            Object v0;
            block2: {
                Iterable iterable = list2;
                boolean bl = false;
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata2 = (RdNuGetSmartMetadata)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)rdNuGetSmartMetadata2.getId(), (Object)rdNuGetPackageIdentity.getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((rdNuGetSmartMetadata = (RdNuGetSmartMetadata)v0) == null || !rdNuGetSmartMetadata.getCanBeUpdated() || !riderNuGetFacade.G(rdNuGetSmartMetadata, rdNuGetPackageIdentity)) continue;
            list3.add(new RdNuGetInstallOneRequest(n, rdNuGetPackageIdentity.getId(), ((RdNuGetRemoteVersion)CollectionsKt.last((List)rdNuGetSmartMetadata.getAvailableVersions())).getVersion()));
        }
    }

    private static final boolean G(RiderNuGetFacade riderNuGetFacade, RdNuGetStateInfo rdNuGetStateInfo, boolean bl) {
        return (Boolean)InterfacesKt.valueOrDefault(riderNuGetFacade.isBusy(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)rdNuGetStateInfo.isFetching(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)rdNuGetStateInfo.getPackageReferenceTrackerIsBusy(), (Object)true) == false && (((Number)InterfacesKt.valueOrDefault((IOptProperty)rdNuGetStateInfo.getTotalFetched(), (Object)0)).intValue() > 0 || !bl) && riderNuGetFacade.runTaskCount.get() == 0;
    }

    private static final String G(RiderNuGetFacade riderNuGetFacade, RdNuGetStateInfo rdNuGetStateInfo) {
        RiderNuGetFacade riderNuGetFacade2 = riderNuGetFacade;
        IOptProperty<Boolean> iOptProperty = riderNuGetFacade.isBusy();
        boolean bl = false;
        Object object = iOptProperty.getValueOrNull();
        if (object == null || (object = object.toString()) == null) {
            object = "NA";
        }
        return "IsBusy: " + (String)object + ", State: (" + RiderNuGetExtensionsKt.toUserString((RdNuGetStateInfo)rdNuGetStateInfo) + "), RunTaskCount: " + riderNuGetFacade.runTaskCount.get();
    }

    private static final boolean G(RiderNuGetFacade riderNuGetFacade, RdNuGetStateInfo rdNuGetStateInfo) {
        return (Boolean)InterfacesKt.valueOrDefault(riderNuGetFacade.isBusy(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)rdNuGetStateInfo.isFetching(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)rdNuGetStateInfo.getPackageReferenceTrackerIsBusy(), (Object)true) == false && riderNuGetFacade.runTaskCount.get() == 0;
    }

    private static final String b(RiderNuGetFacade riderNuGetFacade, RdNuGetStateInfo rdNuGetStateInfo) {
        RiderNuGetFacade riderNuGetFacade2 = riderNuGetFacade;
        IOptProperty iOptProperty = riderNuGetFacade.isBusy();
        boolean bl = false;
        Object object = iOptProperty.getValueOrNull();
        if (object == null || (object = object.toString()) == null) {
            object = "NA";
        }
        riderNuGetFacade2 = riderNuGetFacade;
        iOptProperty = rdNuGetStateInfo.isFetching();
        bl = false;
        Object object2 = iOptProperty.getValueOrNull();
        if (object2 == null || (object2 = object2.toString()) == null) {
            object2 = "NA";
        }
        riderNuGetFacade2 = riderNuGetFacade;
        iOptProperty = rdNuGetStateInfo.getPackageReferenceTrackerIsBusy();
        bl = false;
        Object object3 = iOptProperty.getValueOrNull();
        if (object3 == null || (object3 = object3.toString()) == null) {
            object3 = "NA";
        }
        return "IsBusy: " + (String)object + ", IsFetching: " + (String)object2 + ", PackageReferenceTrackerIsBusy: " + (String)object3 + ", RunTaskCount: " + riderNuGetFacade.runTaskCount.get();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/nuget/RiderNuGetFacade$Companion;", "", "RiderNuGetFacade$Companion", "()V", "LAST_PACKAGE_VERSION_DIALOG_PROPERTY", "", "getInstance", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,314:1\n31#2,2:315\n*S KotlinDebug\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade$Companion\n*L\n35#1:315,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderNuGetFacade getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RiderNuGetFacade> clazz = RiderNuGetFacade.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RiderNuGetFacade)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

