/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.ui;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsUiUtilsKt;
import icons.ReSharperIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\u001e\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0019R\u0011\u0010 \u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0011\u0010\"\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0019R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "", "foreColor", "Ljava/awt/Color;", "backColor", "foreSelectionColor", "selectionColor", "dragSuccessColor", "dragFailColor", "XcAssetsStyle", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "getForeColor", "()Ljava/awt/Color;", "getBackColor", "getForeSelectionColor", "getSelectionColor", "getDragSuccessColor", "getDragFailColor", "noPreviewIcon", "Ljavax/swing/Icon;", "getNoPreviewIcon", "()Ljavax/swing/Icon;", "borderCornerRadius", "", "getBorderCornerRadius", "()I", "borderThickness", "getBorderThickness", "horizontalSeparatorOffset", "getHorizontalSeparatorOffset", "verticalSeparatorOffset", "getVerticalSeparatorOffset", "innerGroupGap", "getInnerGroupGap", "assetGroupGap", "getAssetGroupGap", "itemInsets", "Ljava/awt/Insets;", "getItemInsets", "()Ljava/awt/Insets;", "textOffset", "getTextOffset", "assetItemContentSize", "Ljava/awt/Dimension;", "getAssetItemContentSize", "()Ljava/awt/Dimension;", "G", "value", "intellij.rider"})
public final class XcAssetsStyle {
    @NotNull
    private final Color foreColor;
    @NotNull
    private final Color backColor;
    @NotNull
    private final Color foreSelectionColor;
    @NotNull
    private final Color selectionColor;
    @NotNull
    private final Color dragSuccessColor;
    @NotNull
    private final Color dragFailColor;
    @NotNull
    private final Icon noPreviewIcon;

    public XcAssetsStyle(@NotNull Color foreColor, @NotNull Color backColor, @NotNull Color foreSelectionColor, @NotNull Color selectionColor, @NotNull Color dragSuccessColor, @NotNull Color dragFailColor) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)foreColor, (String)"foreColor");
        Intrinsics.checkNotNullParameter((Object)backColor, (String)"backColor");
        Intrinsics.checkNotNullParameter((Object)foreSelectionColor, (String)"foreSelectionColor");
        Intrinsics.checkNotNullParameter((Object)selectionColor, (String)"selectionColor");
        Intrinsics.checkNotNullParameter((Object)dragSuccessColor, (String)"dragSuccessColor");
        Intrinsics.checkNotNullParameter((Object)dragFailColor, (String)"dragFailColor");
        this.foreColor = foreColor;
        this.backColor = backColor;
        this.foreSelectionColor = foreSelectionColor;
        this.selectionColor = selectionColor;
        this.dragSuccessColor = dragSuccessColor;
        this.dragFailColor = dragFailColor;
        Icon icon2 = ReSharperIcons.Xamarin.NoPreview;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NoPreview");
        Icon icon3 = icon2;
        if (icon3.getIconWidth() <= this.getAssetItemContentSize().width && icon3.getIconHeight() <= this.getAssetItemContentSize().height) {
            icon = icon3;
        } else {
            BufferedImage bufferedImage = ImageUtil.createImage((int)icon3.getIconWidth(), (int)icon3.getIconHeight(), (int)6);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage bufferedImage2 = bufferedImage;
            icon3.paintIcon(null, bufferedImage2.createGraphics(), 0, 0);
            Image image = XcAssetsUiUtilsKt.shrinkPicture(bufferedImage2, this.getAssetItemContentSize());
            icon = new ImageIcon(image);
        }
        this.noPreviewIcon = icon;
    }

    @NotNull
    public final Color getForeColor() {
        return this.foreColor;
    }

    @NotNull
    public final Color getBackColor() {
        return this.backColor;
    }

    @NotNull
    public final Color getForeSelectionColor() {
        return this.foreSelectionColor;
    }

    @NotNull
    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    @NotNull
    public final Color getDragSuccessColor() {
        return this.dragSuccessColor;
    }

    @NotNull
    public final Color getDragFailColor() {
        return this.dragFailColor;
    }

    @NotNull
    public final Icon getNoPreviewIcon() {
        return this.noPreviewIcon;
    }

    public final int getBorderCornerRadius() {
        return this.G(8);
    }

    public final int getBorderThickness() {
        int n = this.G(1);
        return n < 1 ? 1 : n;
    }

    public final int getHorizontalSeparatorOffset() {
        return this.G(50);
    }

    public final int getVerticalSeparatorOffset() {
        return this.G(20);
    }

    public final int getInnerGroupGap() {
        return this.G(20);
    }

    public final int getAssetGroupGap() {
        return this.G(100);
    }

    @NotNull
    public final Insets getItemInsets() {
        return (Insets)new JBInsets(15, 5, 5, 5);
    }

    public final int getTextOffset() {
        return this.G(5);
    }

    @NotNull
    public final Dimension getAssetItemContentSize() {
        return (Dimension)new JBDimension(80, 80);
    }

    private final int G(int n) {
        return JBUIScale.scale((int)n);
    }
}

