/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconScale;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.MultiPlatformImageSubtype;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetImageItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItemWithFile;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.AssetEnvironment;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageReadResults;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcImageAssetItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import java.awt.image.BufferedImage;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageItemPresenter;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageAssetItemPresenterBase;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageItem;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "environment", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;", "XcImageItemPresenter", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageItem;Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;)V", "caption", "", "getCaption", "()Ljava/lang/String;", "tooltip", "getTooltip", "G", "scale", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/IconScale;", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "readImage", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageReadResults;", "file", "Ljava/io/File;", "intellij.rider"})
public final class XcImageItemPresenter
extends XcImageAssetItemPresenterBase<XcAssetImageItem> {
    @NotNull
    private final Project project;

    public XcImageItemPresenter(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull XcAssetImageItem model, @NotNull AssetEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(lifetime, (XcAssetItemWithFile)model, environment);
        this.project = project;
    }

    @Override
    @NotNull
    protected String getCaption() {
        StringBuilder stringBuilder = new StringBuilder((String)(((XcAssetImageItem)this.getModel()).getSubtype() == MultiPlatformImageSubtype.RETINA4 ? "R4" : (((XcAssetImageItem)this.getModel()).getScale() == null ? "Vector" : (((XcAssetImageItem)this.getModel()).getMultiPlatformWatchScreenWidth() != null ? ((XcAssetImageItem)this.getModel()).getMultiPlatformWatchScreenWidth().getText() + " " + this.G(((XcAssetImageItem)this.getModel()).getScale()) : this.G(((XcAssetImageItem)this.getModel()).getScale())))));
        stringBuilder.append("\r" + ModelUtilsKt.getLuminosity((XcAssetItem)this.getModel()) + " appearance").append('\n');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getTooltip() {
        String string = PresenterUtilsKt.getImageTooltipText(this.getImageInfo(), this.getCurrentFile(), this.getErrorStateMessage());
        if (string == null) {
            string = RiderMultiPlatformBundle.Companion.message("rider.xcassets.imageset.notset.tooltip", new Object[0]);
        }
        return string;
    }

    private final String G(IconScale iconScale) {
        return iconScale.getValue() + "x";
    }

    @Override
    @NotNull
    public XcItemOperationResult handleAddAction() {
        File file2 = PresenterUtilsKt.selectWithFileDialogOrNull(this.project, RiderMultiPlatformBundle.Companion.message("rider.xcassets.imageset.selectfile.title", new Object[0]));
        if (file2 == null) {
            return XcItemOperationResult.Canceled;
        }
        File file3 = file2;
        return this.trySetupNewImage(file3);
    }

    @Override
    @NotNull
    protected ImageReadResults readImage(@Nullable File file2) {
        if (file2 == null || !file2.exists()) {
            return ImageReadResults.Companion.failed$default(ImageReadResults.Companion, XcItemOperationResult.FileNotFound, null, 2, null);
        }
        BufferedImage bufferedImage = PresenterUtilsKt.openImageOrNull(file2);
        if (bufferedImage != null) {
            return ImageReadResults.Companion.success(bufferedImage);
        }
        Object[] objectArray = new Object[]{file2.getName()};
        return ImageReadResults.Companion.failed(XcItemOperationResult.WrongFormat, RiderMultiPlatformBundle.Companion.message("rider.xcassets.imageset.selectfile.invalidFile", objectArray));
    }
}

