/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColor;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColorAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcJsonModelsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.ColoredRect;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import icons.ReSharperIcons;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\fH\u0014J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010!\u001a\u00020$H\u0014J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0014J\b\u0010(\u001a\u00020\fH\u0002J\u0010\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "hint", "", "onColorChanged", "Lkotlin/Function0;", "", "XcColorItemPresenter", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getHint", "()Ljava/lang/String;", "caption", "getCaption", "tooltip", "getTooltip", "isEmpty", "", "()Z", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "handleDeleteAction", "createContentUI", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/ColoredRect;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "afterDraw", "tryDrag", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "tryDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "createPopupMenuItems", "", "Lcom/intellij/openapi/ui/JBMenuItem;", "r", "G", "color", "Ljava/awt/Color;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcColorItemPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcColorItemPresenter.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n1#2:115\n12567#3,2:116\n12567#3,2:118\n*S KotlinDebug\n*F\n+ 1 XcColorItemPresenter.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter\n*L\n68#1:116,2\n71#1:118,2\n*E\n"})
public final class XcColorItemPresenter
extends XcItemPresenterBase<XcColorAssetItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final String hint;

    public XcColorItemPresenter(@NotNull Lifetime lifetime, @NotNull Project project, @NotNull XcColorAssetItem model, @NotNull String hint, @NotNull Function0<Unit> onColorChanged) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter(onColorChanged, (String)"onColorChanged");
        super(lifetime, model, onColorChanged);
        this.project = project;
        this.hint = hint;
    }

    public /* synthetic */ XcColorItemPresenter(Lifetime lifetime, Project project, XcColorAssetItem xcColorAssetItem, String string, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "";
        }
        if ((n & 0x10) != 0) {
            function0 = XcColorItemPresenter::b;
        }
        this(lifetime, project, xcColorAssetItem, string, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    protected String getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    protected String getCaption() {
        return ModelUtilsKt.getLuminosity((XcAssetItem)this.getModel()) + " appearance";
    }

    @Override
    @NotNull
    protected String getTooltip() {
        String string;
        if (this.isEmpty()) {
            string = this.getCaption() + "\r\n" + RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.notSet.tooltip", new Object[0]);
        } else {
            String string2 = this.getCaption();
            Object object = ((XcColorAssetItem)this.getModel()).getColor();
            if (object == null || (object = ((XcColor)object).getColor()) == null) {
                object = Color.BLACK;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            String string3 = this.G((Color)object2).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            string = string2 + "\r\n" + string3;
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        XcColor xcColor = ((XcColorAssetItem)this.getModel()).getColor();
        return (xcColor != null ? xcColor.getComponents() : null) == null;
    }

    @Override
    @NotNull
    public XcItemOperationResult handleAddAction() {
        Object object = ((XcColorAssetItem)this.getModel()).getColor();
        if (object == null || (object = ((XcColor)object).getColor()) == null) {
            object = Color.BLACK;
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        PresenterUtilsKt.selectColorFromColorPicker(this.project, (Color)object2, (Function1<? super Color, Unit>)((Function1)arg_0 -> XcColorItemPresenter.G(this, arg_0)));
        return XcItemOperationResult.Success;
    }

    @Override
    public void handleDeleteAction() {
        ((XcColorAssetItem)this.getModel()).setColor(new XcColor("srgb", null));
        this.r();
        this.modelChanged();
    }

    @Override
    @NotNull
    protected ColoredRect createContentUI(@NotNull XcAssetsStyle style) {
        ColoredRect coloredRect;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        ColoredRect coloredRect2 = coloredRect = new ColoredRect(style.getAssetItemContentSize(), style.getBorderThickness(), style.getBorderCornerRadius(), style.getBackColor(), Color.red);
        boolean bl = false;
        coloredRect2.setBackground(null);
        return coloredRect;
    }

    @Override
    protected void afterDraw() {
        this.r();
    }

    @Override
    protected boolean tryDrag(@NotNull DropTargetDragEvent dtde) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
            DataFlavor[] dataFlavorArray = dtde.getTransferable().getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] objectArray = dataFlavorArray;
            boolean bl2 = false;
            for (Object object : objectArray) {
                DataFlavor dataFlavor = (DataFlavor)object;
                boolean bl3 = false;
                if (!dataFlavor.isFlavorTextType()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    protected XcItemOperationResult tryDrop(@NotNull DropTargetDropEvent dtde) {
        XcItemOperationResult xcItemOperationResult;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
            DataFlavor[] dataFlavorArray = dtde.getTransferable().getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] object = dataFlavorArray;
            boolean color2 = false;
            for (Object object2 : object) {
                DataFlavor dataFlavor = (DataFlavor)object2;
                boolean bl2 = false;
                if (!dataFlavor.isFlavorTextType()) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (!bl) {
            return XcItemOperationResult.InvalidDndContent;
        }
        String string = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
        Color color = PresenterUtilsKt.tryParseColor(string);
        if (color == null) {
            return XcItemOperationResult.InvalidDndContent;
        }
        Color color2 = color;
        XcColor xcColor = ((XcColorAssetItem)this.getModel()).getColor();
        if (Intrinsics.areEqual((Object)(xcColor != null ? xcColor.getColor() : null), (Object)color2)) {
            return XcItemOperationResult.NotAffected;
        }
        if (!this.isEmpty() && Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.replace.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return XcItemOperationResult.Canceled;
        }
        ((XcColorAssetItem)this.getModel()).setColor(new XcColor("srgb", XcJsonModelsKt.colorComponentFromColor(color2)));
        this.modelChanged();
        try {
            this.r();
            xcItemOperationResult = XcItemOperationResult.Success;
        }
        catch (Exception exception) {
            xcItemOperationResult = XcItemOperationResult.Exception;
        }
        return xcItemOperationResult;
    }

    @Override
    @NotNull
    protected List<JBMenuItem> createPopupMenuItems() {
        JBMenuItem jBMenuItem;
        JBMenuItem jBMenuItem2 = jBMenuItem = new JBMenuItem(RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.openpicker.menuItem", new Object[0]), ReSharperIcons.Common.ColorSelection16x16);
        boolean bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcColorItemPresenter.G(this, arg_0));
        return CollectionsKt.listOf((Object)jBMenuItem);
    }

    private final void r() {
        block1: {
            Object object = ((XcColorAssetItem)this.getModel()).getColor();
            if (object == null || (object = ((XcColor)object).getColor()) == null) {
                object = new Color(0, 0, 0, 0);
            }
            Object object2 = object;
            AssetItemControl assetItemControl = this.getAssetControl();
            JComponent jComponent = assetItemControl != null ? assetItemControl.getContentUI() : null;
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.rider.multiPlatform.xcAssets.ui.ColoredRect");
            ColoredRect coloredRect = (ColoredRect)jComponent;
            coloredRect.setCurrentColor((Color)object2);
            AssetItemControl assetItemControl2 = this.getAssetControl();
            if (assetItemControl2 == null) break block1;
            AssetItemControl.enableContent$default(assetItemControl2, new StringSelection(this.G((Color)object2)), null, 2, null);
        }
    }

    private final String G(Color color) {
        String string = "%02x";
        Object[] objectArray = new Object[]{color.getRed()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getGreen()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getBlue()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getAlpha()};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        return "#" + string2 + string3 + string4 + string5;
    }

    private static final Unit b() {
        return Unit.INSTANCE;
    }

    private static final Unit G(XcColorItemPresenter xcColorItemPresenter, Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"it");
        XcColor xcColor = ((XcColorAssetItem)xcColorItemPresenter.getModel()).getColor();
        if (Intrinsics.areEqual((Object)(xcColor != null ? xcColor.getColor() : null), (Object)color)) {
            return Unit.INSTANCE;
        }
        ((XcColorAssetItem)xcColorItemPresenter.getModel()).setColor(new XcColor("srgb", XcJsonModelsKt.colorComponentFromColor(color)));
        xcColorItemPresenter.r();
        xcColorItemPresenter.modelChanged();
        return Unit.INSTANCE;
    }

    private static final void G(XcColorItemPresenter xcColorItemPresenter, ActionEvent actionEvent) {
        xcColorItemPresenter.handleAddAction();
    }
}

