/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00150\u0014J\u0006\u0010\u0018\u001a\u00020\u0015J\u0012\u0010\u0019\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0006\u0010\u001b\u001a\u00020\u0015J\u0006\u0010\u001c\u001a\u00020\u0015J\u0012\u0010\u001d\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u001e\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006J\u0012\u0010\u001f\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006J\b\u0010 \u001a\u00020\u0015H\u0002J\u0014\u0010!\u001a\u00020\u00152\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002R&\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00150\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "", "SelectionLogic", "()V", "allOrderedItems", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "Lkotlin/collections/ArrayList;", "currentlySelectedItems", "lastSelectionIndex", "", "registratedCount", "getRegistratedCount", "()I", "selectedItems", "", "getSelectedItems", "()Ljava/util/List;", "selectedListChangedObservers", "", "Lkotlin/Function1;", "", "addSelectedListChangedChanged", "delegate", "removeAllListeners", "registrate", "item", "unregistrateAll", "deselectAll", "select", "selectWithShift", "selectWithControl", "G", "G", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSelectionLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLogic.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1863#2,2:112\n1863#2,2:114\n*S KotlinDebug\n*F\n+ 1 SelectionLogic.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic\n*L\n45#1:112,2\n104#1:114,2\n*E\n"})
public final class SelectionLogic {
    @NotNull
    private final ArrayList<XcItemPresenterBase<?>> allOrderedItems = new ArrayList();
    @NotNull
    private final ArrayList<XcItemPresenterBase<?>> currentlySelectedItems = new ArrayList();
    private int lastSelectionIndex;
    @NotNull
    private final List<Function1<SelectionLogic, Unit>> selectedListChangedObservers = new ArrayList();

    public final int getRegistratedCount() {
        return this.allOrderedItems.size();
    }

    @NotNull
    public final List<XcItemPresenterBase<?>> getSelectedItems() {
        return this.currentlySelectedItems;
    }

    public final void addSelectedListChangedChanged(@NotNull Function1<? super SelectionLogic, Unit> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.selectedListChangedObservers.add(delegate);
    }

    public final void removeAllListeners() {
        this.selectedListChangedObservers.clear();
    }

    public final void registrate(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.allOrderedItems.add(item);
        item.setSelectionOrder(((Collection)this.allOrderedItems).size() - 1);
    }

    public final void unregistrateAll() {
        this.allOrderedItems.clear();
        this.lastSelectionIndex = 0;
        this.currentlySelectedItems.clear();
    }

    public final void deselectAll() {
        Iterable iterable = this.allOrderedItems;
        boolean bl = false;
        for (Object t : iterable) {
            XcItemPresenterBase xcItemPresenterBase = (XcItemPresenterBase)t;
            boolean bl2 = false;
            xcItemPresenterBase.setSelected(false);
        }
        if (this.currentlySelectedItems.size() > 0) {
            this.currentlySelectedItems.clear();
            this.G();
        }
    }

    public final void select(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.deselectAll();
        this.G(item);
        this.G();
    }

    public final void selectWithShift(@NotNull XcItemPresenterBase<?> item) {
        int n;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (this.currentlySelectedItems.isEmpty() || this.lastSelectionIndex < 0) {
            this.select(item);
            return;
        }
        int n2 = Math.min(item.getSelectionOrder(), this.lastSelectionIndex);
        int n3 = n2;
        if (n3 <= (n = Math.max(item.getSelectionOrder(), this.lastSelectionIndex))) {
            while (true) {
                XcItemPresenterBase<?> xcItemPresenterBase;
                Intrinsics.checkNotNullExpressionValue(this.allOrderedItems.get(n3), (String)"get(...)");
                if (!xcItemPresenterBase.isSelected()) {
                    xcItemPresenterBase.setSelected(true);
                    this.currentlySelectedItems.add(xcItemPresenterBase);
                }
                if (n3 == n) break;
                ++n3;
            }
        }
        this.G();
    }

    public final void selectWithControl(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (!item.isSelected()) {
            this.G(item);
            return;
        }
        item.setSelected(false);
        this.currentlySelectedItems.remove(item);
        if (this.lastSelectionIndex == item.getSelectionOrder()) {
            Iterator<XcItemPresenterBase<?>> iterator2 = this.currentlySelectedItems.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<XcItemPresenterBase<?>> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                XcItemPresenterBase<?> xcItemPresenterBase;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), (String)"next(...)");
                this.lastSelectionIndex = Math.min(this.lastSelectionIndex, xcItemPresenterBase.getSelectionOrder());
            }
        }
        this.G();
    }

    private final void G() {
        Iterable iterable = this.selectedListChangedObservers;
        boolean bl = false;
        for (Object t : iterable) {
            Function1 function1 = (Function1)t;
            boolean bl2 = false;
            function1.invoke((Object)this);
        }
    }

    private final void G(XcItemPresenterBase<?> xcItemPresenterBase) {
        xcItemPresenterBase.setSelected(true);
        this.currentlySelectedItems.add(xcItemPresenterBase);
        this.lastSelectionIndex = xcItemPresenterBase.getSelectionOrder();
    }
}

