/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorPicker;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.FileTransferable;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageInfo;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u001a*\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005\u001a\u0013\u0010\u0014\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a-\u0010\u0018\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\b\u001a\u0004\u0018\u00010\u00012\n\b\u0003\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u001a\u0015\u0010\u001c\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00152\b\b\u0001\u0010\u000b\u001a\u00020\u0005\u001a\u0006\u0010\u001d\u001a\u00020\u001a\u001a\u0010\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0007\u00a8\u0006 "}, d2={"selectWithFileDialogOrNull", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "caption", "", "openImageOrNull", "Ljava/awt/image/BufferedImage;", "file", "tryParseColor", "Ljava/awt/Color;", "text", "selectColorFromColorPicker", "", "current", "onChoose", "Lkotlin/Function1;", "createTransferableFile", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/FileTransferable;", "filename", "toHumanizedFileSize", "Lcom/intellij/openapi/util/NlsSafe;", "fileSize", "", "getImageTooltipText", "imageInfo", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageInfo;", "errorMessage", "wrapToHtmlMultiline", "emptyImageInfo", "getImageInfo", "image", "intellij.rider"})
public final class PresenterUtilsKt {
    @Nullable
    public static final File selectWithFileDialogOrNull(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String caption) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)caption, (String)"caption");
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, true, true, false, false).withHideIgnored(false);
        fileChooserDescriptor.withTitle(caption);
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser(fileChooserDescriptor, project, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"createFileChooser(...)");
        FileChooserDialog fileChooserDialog2 = fileChooserDialog;
        Object[] objectArray = fileChooserDialog2.choose(project, new VirtualFile[0]);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"choose(...)");
        Object[] objectArray2 = objectArray;
        VirtualFile virtualFile = (VirtualFile)ArraysKt.firstOrNull((Object[])objectArray2);
        return virtualFile != null ? DocumentUtilKt.toIOFile((VirtualFile)virtualFile) : null;
    }

    @Nullable
    public static final BufferedImage openImageOrNull(@Nullable File file2) {
        BufferedImage bufferedImage;
        if (file2 == null) {
            return null;
        }
        if (!file2.exists()) {
            return null;
        }
        try {
            bufferedImage = ImageIO.read(file2);
        }
        catch (Exception exception) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    @Nullable
    public static final Color tryParseColor(@Nullable String text) {
        CharSequence charSequence = text;
        if (charSequence == null || charSequence.length() == 0 || text.charAt(0) != '#') {
            return null;
        }
        String string = text.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        charSequence = string;
        switch (((String)charSequence).length()) {
            case 6: {
                Integer n = StringsKt.toIntOrNull((String)charSequence, (int)16);
                if (n == null) {
                    return null;
                }
                int n2 = n;
                return new Color(n2);
            }
            case 8: {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.slice((String)charSequence, (IntRange)new IntRange(0, 1)), (int)16);
                if (n == null) {
                    return null;
                }
                int n3 = n;
                Integer n4 = StringsKt.toIntOrNull((String)StringsKt.slice((String)charSequence, (IntRange)new IntRange(2, 3)), (int)16);
                if (n4 == null) {
                    return null;
                }
                int n5 = n4;
                Integer n6 = StringsKt.toIntOrNull((String)StringsKt.slice((String)charSequence, (IntRange)new IntRange(4, 5)), (int)16);
                if (n6 == null) {
                    return null;
                }
                int n7 = n6;
                Integer n8 = StringsKt.toIntOrNull((String)StringsKt.slice((String)charSequence, (IntRange)new IntRange(6, 7)), (int)16);
                if (n8 == null) {
                    return null;
                }
                int n9 = n8;
                return new Color(n3, n5, n7, n9);
            }
        }
        return null;
    }

    public static final void selectColorFromColorPicker(@NotNull Project project, @NotNull Color current, @NotNull Function1<? super Color, Unit> onChoose) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        Intrinsics.checkNotNullParameter(onChoose, (String)"onChoose");
        ColorPicker.showColorPickerPopup((Project)project, (Color)current, (arg_0, arg_1) -> PresenterUtilsKt.G(onChoose, arg_0, arg_1), null, (boolean)true);
    }

    @NotNull
    public static final FileTransferable createTransferableFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return new FileTransferable(CollectionsKt.listOf((Object)new File(filename)));
    }

    @NotNull
    public static final String toHumanizedFileSize(long fileSize) {
        long l;
        String[] stringArray = new String[]{"KB", "MB", "GB"};
        String[] stringArray2 = stringArray;
        if (fileSize < 1024L) {
            return fileSize + " B";
        }
        long l2 = 1L;
        int n = -1;
        while ((l = l2 * (long)1024) <= fileSize) {
            l2 = l;
            ++n;
        }
        l = fileSize / l2;
        String string = stringArray2[n];
        long l3 = fileSize % l2 * (long)100 / l2;
        if (l3 == 0L) {
            return l + " " + string;
        }
        if (l3 % (long)10 == 0L) {
            l3 /= 10L;
        }
        return l + "." + l3 + " " + string;
    }

    @Nullable
    public static final String getImageTooltipText(@Nullable ImageInfo imageInfo, @Nullable File file2, @NlsContexts.DialogMessage @Nullable String errorMessage2) {
        if (file2 == null) {
            return errorMessage2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence = errorMessage2;
        if (!(charSequence == null || charSequence.length() == 0)) {
            stringBuilder.append(errorMessage2).append('\n');
        }
        stringBuilder.append(file2.getName()).append('\n');
        ImageInfo imageInfo2 = imageInfo;
        boolean bl = imageInfo2 != null ? !imageInfo2.isEmpty() : false;
        if (bl) {
            stringBuilder.append(imageInfo.getWidth() + " x " + imageInfo.getHeight() + "px.").append('\n');
        }
        stringBuilder.append(PresenterUtilsKt.toHumanizedFileSize(file2.length())).append('\n');
        return stringBuilder.toString();
    }

    public static /* synthetic */ String getImageTooltipText$default(ImageInfo imageInfo, File file2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return PresenterUtilsKt.getImageTooltipText(imageInfo, file2, string);
    }

    @NotNull
    public static final String wrapToHtmlMultiline(@NlsContexts.Label @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = new HtmlBuilder().append(text).wrapWith("html").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final ImageInfo emptyImageInfo() {
        return new ImageInfo(0, 0);
    }

    @NotNull
    public static final ImageInfo getImageInfo(@Nullable BufferedImage image) {
        return image == null ? PresenterUtilsKt.emptyImageInfo() : new ImageInfo(image.getWidth(), image.getHeight());
    }

    private static final void G(Function1 function1, Color color, Object object) {
        if (color != null) {
            function1.invoke((Object)color);
        }
    }
}

