/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.models;

import com.google.gson.GsonBuilder;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AppearanceType;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetAppearance;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetVariations;
import com.jetbrains.rider.multiPlatform.xcAssets.models.IconScale;
import com.jetbrains.rider.multiPlatform.xcAssets.models.Idiom;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcApperanceItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetImageItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetImageset;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemsGroupPresenter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"parseImageXcAssets", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageset;", "contents", "", "readImageXcAssets", "reader", "Ljava/io/Reader;", "saveImageset", "", "set", "path", "trySetToDeviceItem", "", "device", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemsGroupPresenter;", "image", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageItem;", "createImageModels", "", "assetChoices", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetVariations;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcImageUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/XcImageUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class XcImageUtilsKt {
    @NotNull
    public static final XcAssetImageset parseImageXcAssets(@NotNull String contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        return XcImageUtilsKt.readImageXcAssets(new StringReader(contents));
    }

    @NotNull
    public static final XcAssetImageset readImageXcAssets(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Object object = new GsonBuilder().setLenient().create().fromJson(reader, XcAssetImageset.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (XcAssetImageset)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveImageset(@NotNull XcAssetImageset set, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileWriter(path);
        Throwable throwable = null;
        try {
            FileWriter fileWriter = (FileWriter)closeable;
            boolean bl = false;
            ModelUtilsKt.serializeToJson(set, fileWriter);
            fileWriter = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean trySetToDeviceItem(@NotNull XcItemsGroupPresenter device, @NotNull XcAssetImageItem image) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (XcItemPresenterBase<?> xcItemPresenterBase : device.getItems()) {
            Object obj = xcItemPresenterBase.getModel();
            if (!(obj instanceof XcAssetImageItem) || !((XcAssetImageItem)obj).fits(image)) continue;
            ((XcAssetImageItem)obj).setFileName(image.getFileName());
            return true;
        }
        return false;
    }

    @NotNull
    public static final List<XcAssetImageItem> createImageModels(@NotNull AssetVariations assetChoices) {
        Intrinsics.checkNotNullParameter((Object)assetChoices, (String)"assetChoices");
        List list2 = new ArrayList();
        for (Idiom idiom : assetChoices.getIdioms()) {
            for (AssetAppearance assetAppearance : assetChoices.getAppearances()) {
                IconScale[] iconScaleArray = new IconScale[]{null, IconScale.X1, IconScale.X2, IconScale.X3};
                for (IconScale iconScale : iconScaleArray) {
                    Object object;
                    XcApperanceItem[] xcApperanceItemArray;
                    if (assetAppearance == AssetAppearance.Any) {
                        xcApperanceItemArray = null;
                    } else {
                        object = new XcApperanceItem[]{new XcApperanceItem(AppearanceType.LUMINOSITY, assetAppearance.getAppearanceValue())};
                        xcApperanceItemArray = object;
                    }
                    XcApperanceItem[] xcApperanceItemArray2 = xcApperanceItemArray;
                    object = new XcAssetImageItem(null, xcApperanceItemArray2, null, null, null, null, idiom, null, null, null, null, iconScale, null, null, null, null, null, 128957, null);
                    list2.add(object);
                }
            }
        }
        return list2;
    }
}

