/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.models;

import com.google.gson.GsonBuilder;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetEditorUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetAppearance;
import com.jetbrains.rider.multiPlatform.xcAssets.models.Idiom;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetColorset;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColor;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColorAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcColorItemPresenter;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemsGroupPresenter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0003\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u00a8\u0006\u0016"}, d2={"readColorXcAssetsFromString", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetColorset;", "text", "", "readColorXcAssets", "reader", "Ljava/io/Reader;", "saveColorset", "", "set", "path", "trySetToDeviceItem", "", "device", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemsGroupPresenter;", "image", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;", "createEmptyAssetColorItem", "idiom", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/Idiom;", "appearance", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetAppearance;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcColorUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class XcColorUtilsKt {
    @NotNull
    public static final XcAssetColorset readColorXcAssetsFromString(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return XcColorUtilsKt.readColorXcAssets(new StringReader(text));
    }

    @NotNull
    public static final XcAssetColorset readColorXcAssets(@NotNull Reader reader) {
        XcAssetColorset xcAssetColorset;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        XcAssetColorset xcAssetColorset2 = xcAssetColorset = (XcAssetColorset)new GsonBuilder().setLenient().create().fromJson(reader, XcAssetColorset.class);
        return (xcAssetColorset2 != null ? xcAssetColorset2.getColors() : null) == null ? new XcAssetColorset(CollectionsKt.emptyList(), xcAssetColorset.getInfo()) : xcAssetColorset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveColorset(@NotNull XcAssetColorset set, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileWriter(path);
        Throwable throwable = null;
        try {
            FileWriter fileWriter = (FileWriter)closeable;
            boolean bl = false;
            ModelUtilsKt.serializeToJson(set, fileWriter);
            fileWriter = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean trySetToDeviceItem(@NotNull XcItemsGroupPresenter device, @NotNull XcColorAssetItem image) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (XcItemPresenterBase<?> xcItemPresenterBase : device.getItems()) {
            Intrinsics.checkNotNull(xcItemPresenterBase, (String)"null cannot be cast to non-null type com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcColorItemPresenter");
            XcColorItemPresenter xcColorItemPresenter = (XcColorItemPresenter)xcItemPresenterBase;
            if (!((XcColorAssetItem)xcColorItemPresenter.getModel()).fits(image)) continue;
            ((XcColorAssetItem)xcColorItemPresenter.getModel()).setColor(image.getColor());
            return true;
        }
        return false;
    }

    @NotNull
    public static final XcColorAssetItem createEmptyAssetColorItem(@NotNull Idiom idiom, @NotNull AssetAppearance appearance) {
        Intrinsics.checkNotNullParameter((Object)((Object)idiom), (String)"idiom");
        Intrinsics.checkNotNullParameter((Object)((Object)appearance), (String)"appearance");
        return new XcColorAssetItem(idiom, new XcColor("srgb", null), XcAssetEditorUtilsKt.toAppearances(appearance));
    }
}

