/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.models;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AppearanceType;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AppearanceValue;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetAppearance;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetVariations;
import com.jetbrains.rider.multiPlatform.xcAssets.models.Idiom;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcApperanceItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItem;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a1\u0010\u0005\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\b\u00a2\u0006\u0002\u0010\n\u001a \u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\u0006*\u00020\u00032\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u000e\u001a\u0006\u0010\u000f\u001a\u00020\f\u001a#\u0010\u0010\u001a\u00020\f\"\b\b\u0000\u0010\u0006*\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\b\u00a2\u0006\u0002\u0010\u0011\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0003\u001a\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b\u00a8\u0006\u001e"}, d2={"idiomAndAppearancesFits", "", "thisItem", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetItem;", "otherItem", "nullableArraysAreEqual", "T", "items1", "", "items2", "([Ljava/lang/Object;[Ljava/lang/Object;)Z", "getActualAndDefaultAssetVariations", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetVariations;", "items", "", "createDefaultAssetVariations", "searchVariations", "([Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetItem;)Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetVariations;", "getLuminosity", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetAppearance;", "serializeToJson", "", "entity", "", "writer", "Ljava/io/Writer;", "serializeToTextJson", "", "getNextFileName", "nameWithoutExtenstion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nModelUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/ModelUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,104:1\n1310#2,2:105\n*S KotlinDebug\n*F\n+ 1 ModelUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/ModelUtilsKt\n*L\n70#1:105,2\n*E\n"})
public final class ModelUtilsKt {
    public static final boolean idiomAndAppearancesFits(@NotNull XcAssetItem thisItem, @NotNull XcAssetItem otherItem) {
        Intrinsics.checkNotNullParameter((Object)thisItem, (String)"thisItem");
        Intrinsics.checkNotNullParameter((Object)otherItem, (String)"otherItem");
        return thisItem.getIdiom() == otherItem.getIdiom() && ModelUtilsKt.nullableArraysAreEqual(thisItem.getAppearances(), otherItem.getAppearances());
    }

    public static final <T> boolean nullableArraysAreEqual(@Nullable T[] items1, @Nullable T[] items2) {
        boolean bl;
        boolean bl2;
        boolean bl3 = items1 == null || items1.length == 0 ? true : (bl2 = false);
        boolean bl4 = items2 == null || items2.length == 0 ? true : (bl = false);
        if (bl2 != bl) {
            return false;
        }
        return bl2 || Arrays.equals(items1, items2);
    }

    @NotNull
    public static final <T extends XcAssetItem> AssetVariations getActualAndDefaultAssetVariations(@Nullable List<? extends T> items) {
        Object object = new Idiom[]{Idiom.UNIVERSAL, Idiom.IPHONE, Idiom.IPAD, Idiom.WATCH, Idiom.MAC, Idiom.CAR};
        List list2 = CollectionsKt.listOf((Object[])object);
        Object object2 = new AssetAppearance[]{AssetAppearance.Any, AssetAppearance.Dark, AssetAppearance.Light};
        object = CollectionsKt.listOf((Object[])object2);
        List<T> list3 = items;
        boolean bl = list3 != null ? !list3.isEmpty() : false;
        if (bl) {
            object2 = new HashSet();
            for (Object object3 : items) {
                ((HashSet)object2).add(object3.getIdiom());
            }
            for (Object object3 : list2) {
                ((HashSet)object2).remove(object3);
            }
            if (CollectionsKt.any((Iterable)((Iterable)object2))) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(list2);
                arrayList.addAll((Collection)object2);
                return new AssetVariations(arrayList, (List<? extends AssetAppearance>)object);
            }
        }
        return new AssetVariations(list2, (List<? extends AssetAppearance>)object);
    }

    @NotNull
    public static final AssetVariations createDefaultAssetVariations() {
        Enum[] enumArray = new Idiom[]{Idiom.UNIVERSAL, Idiom.IPHONE, Idiom.IPAD, Idiom.WATCH, Idiom.MAC, Idiom.CAR};
        List list2 = CollectionsKt.listOf((Object[])enumArray);
        enumArray = new AssetAppearance[]{AssetAppearance.Any, AssetAppearance.Dark, AssetAppearance.Light};
        return new AssetVariations(list2, CollectionsKt.listOf((Object[])enumArray));
    }

    @NotNull
    public static final <T extends XcAssetItem> AssetVariations searchVariations(@NotNull T[] items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        HashSet<Idiom> hashSet = new HashSet<Idiom>();
        HashSet<AssetAppearance> hashSet2 = new HashSet<AssetAppearance>();
        for (T t : items) {
            hashSet.add(t.getIdiom());
            hashSet2.add(ModelUtilsKt.getLuminosity(t));
        }
        return new AssetVariations(CollectionsKt.toList((Iterable)hashSet), CollectionsKt.toList((Iterable)hashSet2));
    }

    @NotNull
    public static final AssetAppearance getLuminosity(@NotNull XcAssetItem $this$getLuminosity) {
        XcApperanceItem[] xcApperanceItemArray;
        block9: {
            block8: {
                XcApperanceItem[] xcApperanceItemArray2;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)$this$getLuminosity, (String)"<this>");
                    xcApperanceItemArray = $this$getLuminosity.getAppearances();
                    if (xcApperanceItemArray == null) break block8;
                    XcApperanceItem[] xcApperanceItemArray3 = xcApperanceItemArray;
                    boolean bl = false;
                    int n = xcApperanceItemArray3.length;
                    for (int j = 0; j < n; ++j) {
                        XcApperanceItem[] xcApperanceItemArray4;
                        XcApperanceItem[] xcApperanceItemArray5 = xcApperanceItemArray4 = xcApperanceItemArray3[j];
                        boolean bl2 = false;
                        if (!(xcApperanceItemArray5.getAppearance() == AppearanceType.LUMINOSITY)) continue;
                        xcApperanceItemArray2 = xcApperanceItemArray4;
                        break block7;
                    }
                    xcApperanceItemArray2 = xcApperanceItemArray = null;
                }
                if (xcApperanceItemArray2 != null) break block9;
            }
            return AssetAppearance.Any;
        }
        XcApperanceItem[] xcApperanceItemArray6 = xcApperanceItemArray;
        return switch (WhenMappings.$EnumSwitchMapping$0[xcApperanceItemArray6.getValue().ordinal()]) {
            case 1 -> AssetAppearance.Dark;
            case 2 -> AssetAppearance.Light;
            default -> AssetAppearance.Any;
        };
    }

    public static final void serializeToJson(@NotNull Object entity, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        gson.toJson(entity, (Appendable)writer);
        writer.flush();
    }

    @NotNull
    public static final String serializeToTextJson(@NotNull Object entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        StringWriter stringWriter = new StringWriter();
        ModelUtilsKt.serializeToJson(entity, stringWriter);
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getNextFileName(@NotNull String nameWithoutExtenstion) {
        Intrinsics.checkNotNullParameter((Object)nameWithoutExtenstion, (String)"nameWithoutExtenstion");
        String string = StringsKt.substringAfterLast$default((String)nameWithoutExtenstion, (char)'-', null, (int)2, null);
        if (((CharSequence)string).length() == 0 || string.length() + 1 >= nameWithoutExtenstion.length()) {
            return nameWithoutExtenstion + "-1";
        }
        Integer n = StringsKt.toIntOrNull((String)string);
        return n == null ? nameWithoutExtenstion + "-1" : StringsKt.substringBeforeLast$default((String)nameWithoutExtenstion, (char)'-', null, (int)2, null) + "-" + (n + 1);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AppearanceValue.values().length];
            try {
                nArray[AppearanceValue.DARK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AppearanceValue.LIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

