/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.DesignerEditorProviderBase;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetAppIconFileEditor;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetColorFileEditor;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetEditorBase;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetImageFileEditor;
import java.util.Locale;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/XcAssetItemFileEditorProvider;", "Lcom/jetbrains/rider/designers/DesignerEditorProviderBase;", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "Lcom/intellij/openapi/project/DumbAware;", "XcAssetItemFileEditorProvider", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDesignerNodeDescriptor", "descriptor", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "createDesignerEditor", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.rider"})
public final class XcAssetItemFileEditorProvider
extends DesignerEditorProviderBase<DesignerEditorBase>
implements DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (project.isDisposed()) {
            return false;
        }
        if (!file2.isDirectory()) {
            return false;
        }
        String string = file2.getParent().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith((String)string, (String)".xcassets", (boolean)true)) {
            return false;
        }
        String string2 = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = string3;
        Object[] objectArray = new String[]{"appiconset", "imageset", "colorset"};
        return ArraysKt.contains((Object[])objectArray, (Object)string4);
    }

    @Override
    public boolean isDesignerNodeDescriptor(@NotNull RdProjectFileDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return true;
    }

    @Override
    @NotNull
    public DesignerEditorBase createDesignerEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        XcAssetEditorBase xcAssetEditorBase;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SwingUtilities.invokeLater(() -> XcAssetItemFileEditorProvider.G(project, file2, this));
        long l = System.currentTimeMillis();
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith((String)string, (String)".appiconset", (boolean)true)) {
            xcAssetEditorBase = new XcAssetAppIconFileEditor(project, file2);
        } else {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (StringsKt.endsWith((String)string2, (String)".imageset", (boolean)true)) {
                xcAssetEditorBase = new XcAssetImageFileEditor(project, file2);
            } else {
                String string3 = file2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (StringsKt.endsWith((String)string3, (String)".colorset", (boolean)true)) {
                    xcAssetEditorBase = new XcAssetColorFileEditor(project, file2);
                } else {
                    throw new Exception("Editor for " + file2.getName() + " is not registered");
                }
            }
        }
        XcAssetEditorBase xcAssetEditorBase2 = xcAssetEditorBase;
        XcAssetsStatistic.editorOpened.log(((Object)((Object)xcAssetEditorBase2)).getClass(), (Object)(System.currentTimeMillis() - l));
        return xcAssetEditorBase2;
    }

    @NotNull
    public String getEditorTypeId() {
        return "xcsassets-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    private static final void G(Project project, VirtualFile virtualFile, XcAssetItemFileEditorProvider xcAssetItemFileEditorProvider) {
        FileEditorManager.getInstance((Project)project).setSelectedEditor(virtualFile, xcAssetItemFileEditorProvider.getEditorTypeId());
    }
}

