/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.rider.debugger.DebuggerHelperHost;
import com.jetbrains.rider.internal.CrossgenOptions;
import com.jetbrains.rider.internal.RunCrossgenActionKt;
import com.jetbrains.rider.internal.RunCrossgenTask;
import com.jetbrains.rider.model.InstructionSet;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/internal/RunCrossgenActionWithOptions;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "RunCrossgenActionWithOptions", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
public final class RunCrossgenActionWithOptions
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e2) {
        Project project;
        CrossgenDialog crossgenDialog;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Project project2 = e2.getProject();
        if (project2 == null) {
            Project project3 = ProjectManager.getInstance().getDefaultProject();
            project2 = project3;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
        }
        if (!(crossgenDialog = new CrossgenDialog(project = project2)).showAndGet()) {
            return;
        }
        CrossgenOptions crossgenOptions = crossgenDialog.getOptions();
        if (crossgenOptions.getUseComposite()) {
            ProgressManager.getInstance().run((Task)new RunCrossgenTask(project, crossgenOptions));
            return;
        }
        EnumSet<Object> enumSet = crossgenOptions.getInstructionSet();
        if (enumSet == null) {
            enumSet = EnumSet.of((Enum)InstructionSet.sse2);
        }
        EnumSet<InstructionSet> enumSet2 = enumSet;
        Intrinsics.checkNotNull(enumSet2);
        RunCrossgenActionKt.access$runCrossgenOnBackend(project, enumSet2, crossgenOptions.getAllowParallel(), crossgenOptions.getNiOnly());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Presentation presentation = e2.getPresentation();
        Project project = e2.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        presentation.setEnabled(DebuggerHelperHost.Companion.getInstance(project).isReady());
    }
}

