/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.inlineDoc.ideaInterop.lang.csharp;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.rider.editors.inlineDoc.InlineDocInfo;
import com.jetbrains.rider.editors.inlineDoc.RiderInlineDocListenerAggregatorKt;
import com.jetbrains.rider.inlineDoc.ideaInterop.RiderBackendLinkMatchersKt;
import com.jetbrains.rider.inlineDoc.ideaInterop.lang.csharp.CSharpInlineDocumentationKt;
import com.jetbrains.rider.inlineDoc.presentation.DocHtmlBuildersKt;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.CSharpDocComment;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J\u000f\u0010\u000b\u001a\t\u0018\u00010\f\u00a2\u0006\u0002\b\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/inlineDoc/ideaInterop/lang/csharp/CSharpInlineDocumentation;", "Lcom/intellij/platform/backend/documentation/InlineDocumentation;", "frontendPsiDocComment", "Lcom/jetbrains/rider/languages/fileTypes/csharp/psi/CSharpDocComment;", "CSharpInlineDocumentation", "(Lcom/jetbrains/rider/languages/fileTypes/csharp/psi/CSharpDocComment;)V", "getFrontendPsiDocComment", "()Lcom/jetbrains/rider/languages/fileTypes/csharp/psi/CSharpDocComment;", "getDocumentationRange", "Lcom/intellij/openapi/util/TextRange;", "getDocumentationOwnerRange", "renderText", "", "Lorg/jetbrains/annotations/Nls;", "getOwnerTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "intellij.rider"})
public final class CSharpInlineDocumentation
implements InlineDocumentation {
    @NotNull
    private final CSharpDocComment frontendPsiDocComment;

    public CSharpInlineDocumentation(@NotNull CSharpDocComment frontendPsiDocComment) {
        Intrinsics.checkNotNullParameter((Object)frontendPsiDocComment, (String)"frontendPsiDocComment");
        this.frontendPsiDocComment = frontendPsiDocComment;
    }

    @NotNull
    public final CSharpDocComment getFrontendPsiDocComment() {
        return this.frontendPsiDocComment;
    }

    @NotNull
    public TextRange getDocumentationRange() {
        TextRange textRange = this.frontendPsiDocComment.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @Nullable
    public TextRange getDocumentationOwnerRange() {
        PsiElement psiElement = this.frontendPsiDocComment.getOwner();
        return psiElement != null ? psiElement.getTextRange() : null;
    }

    @Nullable
    public String renderText() {
        Project project = this.frontendPsiDocComment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(this.frontendPsiDocComment.getContainingFile());
        if (document == null) {
            return null;
        }
        Document document2 = document;
        List list2 = RiderInlineDocListenerAggregatorKt.getInlineDocHighlighters((Document)document2);
        if (list2 != null) {
            for (Pair pair : list2) {
                TextRange textRange = (TextRange)pair.component1();
                InlineDocInfo inlineDocInfo = (InlineDocInfo)pair.component2();
                if (!textRange.contains(this.frontendPsiDocComment.getTextRange()) && !this.frontendPsiDocComment.getTextRange().contains(textRange)) continue;
                CSharpInlineDocumentationKt.setInlineDocBackendInfo(this.frontendPsiDocComment, inlineDocInfo);
                break;
            }
        }
        InlineDocInfo inlineDocInfo = CSharpInlineDocumentationKt.getInlineDocBackendInfo(this.frontendPsiDocComment);
        boolean bl = inlineDocInfo != null ? inlineDocInfo.isDirty() : false;
        if (bl) {
            CSharpInlineDocumentationKt.setInlineDocBackendInfo(this.frontendPsiDocComment, null);
        }
        String string = DocHtmlBuildersKt.parseXmlDocToHtml(this.frontendPsiDocComment.getMeaningfulText());
        Object object = CSharpInlineDocumentationKt.getInlineDocBackendInfo(this.frontendPsiDocComment);
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        return RiderBackendLinkMatchersKt.mixinBackendToIdea(string, (String)object);
    }

    @Nullable
    public DocumentationTarget getOwnerTarget() {
        return null;
    }
}

