/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.find.scopes;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.gotoType.GotoCustomizer;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "withExternalItems", "", "SolutionFilesChecker", "(Lcom/intellij/openapi/project/Project;Z)V", "installationPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Ljava/nio/file/Path;", "configPath", "ignoredPaths", "", "scratchesPath", "solutionDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "contains", "file", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderScopeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderScopeUtils.kt\ncom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1755#3,3:109\n1755#3,3:112\n*S KotlinDebug\n*F\n+ 1 RiderScopeUtils.kt\ncom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker\n*L\n84#1:109,3\n87#1:112,3\n*E\n"})
public final class SolutionFilesChecker {
    @NotNull
    private final Project project;
    private final boolean withExternalItems;
    private final Path installationPath;
    private final Path configPath;
    @NotNull
    private final List<Path> ignoredPaths;
    private final Path scratchesPath;
    @Nullable
    private final VirtualFile solutionDirectory;

    public SolutionFilesChecker(@NotNull Project project, boolean withExternalItems) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.withExternalItems = withExternalItems;
        this.installationPath = Paths.get(PathManager.getHomePath(), new String[0]);
        this.configPath = Paths.get(PathManager.getScratchPath(), new String[0]);
        SolutionFilesChecker solutionFilesChecker = this;
        if (PluginManagerCore.isRunningFromSources()) {
            Path path;
            Path path2 = Paths.get(PathManager.getCommunityHomePath(), new String[0]).getParent().normalize();
            String string = PathManager.getArchivedCompliedClassesLocation();
            if (string != null) {
                String string2 = string;
                SolutionFilesChecker solutionFilesChecker2 = solutionFilesChecker;
                boolean bl = false;
                path = Paths.get(string2, new String[0]).normalize();
                solutionFilesChecker = solutionFilesChecker2;
            } else {
                path = null;
            }
            Path path3 = path;
            Object[] objectArray = new Path[]{this.installationPath, this.configPath, path2, path3};
            list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            Object[] objectArray = new Path[]{this.installationPath, this.configPath};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        solutionFilesChecker.ignoredPaths = list2;
        this.scratchesPath = this.configPath.resolve("scratches");
        this.solutionDirectory = DocumentUtilKt.toVirtualFile((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.project), (boolean)true);
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        boolean bl;
        block13: {
            Iterable iterable;
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (file2 instanceof ProjectAwareVirtualFile) {
                return ((ProjectAwareVirtualFile)file2).isInProject(this.project);
            }
            VirtualFileSystem virtualFileSystem = file2.getFileSystem();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
            VirtualFileSystem virtualFileSystem2 = virtualFileSystem;
            VirtualFile virtualFile2 = virtualFile = virtualFileSystem2 instanceof ArchiveFileSystem ? ((ArchiveFileSystem)virtualFileSystem2).getLocalByEntry(file2) : file2;
            if (virtualFile != null && virtualFile.isInLocalFileSystem()) {
                boolean bl2;
                block12: {
                    Path path = virtualFile.toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    iterable = path;
                    if (iterable.startsWith(this.scratchesPath)) {
                        return this.withExternalItems;
                    }
                    Iterable iterable2 = this.ignoredPaths;
                    boolean bl3 = false;
                    if (iterable2 instanceof Collection && ((Collection)iterable2).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (GotoCustomizer gotoCustomizer : iterable2) {
                            Path path2 = (Path)((Object)gotoCustomizer);
                            boolean bl4 = false;
                            if (!iterable.startsWith(path2)) continue;
                            bl2 = true;
                            break block12;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    return false;
                }
            }
            iterable = GotoCustomizer.Companion.getEP().getExtensionList();
            boolean bl5 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object object : iterable) {
                    GotoCustomizer gotoCustomizer;
                    gotoCustomizer = (GotoCustomizer)object;
                    boolean bl6 = false;
                    if (!gotoCustomizer.isGotoTargetInProject(this.project, file2)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        if (this.solutionDirectory != null && this.withExternalItems && VfsUtil.isAncestor((VirtualFile)this.solutionDirectory, (VirtualFile)file2, (boolean)true)) {
            return true;
        }
        return WorkspaceModelExtensionsKt.shouldBeIndexedWithoutLibraries((Project)this.project, (VirtualFile)file2);
    }
}

