/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.find;

import com.intellij.find.FindModel;
import com.intellij.find.FindModelExtension;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderExternalScope;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/ideaInterop/find/RiderFindModelExtension;", "Lcom/intellij/find/FindModelExtension;", "RiderFindModelExtension", "()V", "iterateAdditionalFiles", "", "findModel", "Lcom/intellij/find/FindModel;", "project", "Lcom/intellij/openapi/project/Project;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider"})
public final class RiderFindModelExtension
implements FindModelExtension {
    public boolean iterateAdditionalFiles(@NotNull FindModel findModel, @NotNull Project project, @NotNull Processor<? super VirtualFile> consumer) {
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        SearchScope searchScope = findModel.getCustomScope();
        Condition condition = FindInProjectUtil.createFileMaskCondition((String)findModel.getFileFilter());
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"createFileMaskCondition(...)");
        Condition condition2 = condition;
        if (searchScope instanceof RiderExternalScope) {
            VirtualFile virtualFile = ((RiderExternalScope)searchScope).getRootDirectory();
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            VfsIterator vfsIterator = VfsIterator.Companion.create(project);
            if (vfsIterator != null) {
                vfsIterator.visitChildrenRecursively(virtualFile2, arg_0 -> RiderFindModelExtension.G(condition2, project, consumer, arg_0));
            }
            return true;
        }
        return false;
    }

    private static final boolean G(Condition condition, Project project, Processor processor2, VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"file");
        if (!condition.value((Object)virtualFile.getName())) {
            return true;
        }
        if (IndexableFilesIndex.getInstance((Project)project).shouldBeIndexed(virtualFile)) {
            return false;
        }
        return processor2.process((Object)virtualFile);
    }
}

