/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup.analyzers;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.SingleEnvironmentComponent;
import com.jetbrains.rider.environmentSetup.analyzers.XamarinSdkModel;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0004J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/XamarinEnvironmentComponentBase;", "Lcom/jetbrains/rider/environmentSetup/SingleEnvironmentComponent;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "name", "", "XamarinEnvironmentComponentBase", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;Ljava/lang/String;)V", "model", "Lcom/jetbrains/rider/environmentSetup/analyzers/XamarinSdkModel;", "supportedByOS", "", "isActionAvailable", "actionNotAvailableReason", "getActionNotAvailableReason", "()Ljava/lang/String;", "versionSuffix", "getVersionSuffix", "getLocalVersion", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "G", "", "Ljava/io/File;", "localMsBuildFolder", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXamarinEnvironmentComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XamarinEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/XamarinEnvironmentComponentBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,168:1\n669#2,11:169\n774#2:185\n865#2,2:186\n1#3:180\n11158#4:181\n11493#4,3:182\n*S KotlinDebug\n*F\n+ 1 XamarinEnvironmentComponent.kt\ncom/jetbrains/rider/environmentSetup/analyzers/XamarinEnvironmentComponentBase\n*L\n31#1:169,11\n103#1:185\n103#1:186,2\n102#1:181\n102#1:182,3\n*E\n"})
public abstract class XamarinEnvironmentComponentBase
extends SingleEnvironmentComponent {
    @Nullable
    private final XamarinSdkModel model;

    public XamarinEnvironmentComponentBase(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader, @NotNull String name) {
        Element element;
        List list2;
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(localReader, updatesReader);
        Element element2 = localReader.find("xamarinSdks");
        if (element2 != null && (list2 = element2.getChildren("xamarinSdk")) != null) {
            Object v0;
            block4: {
                Iterable iterable = list2;
                boolean bl = false;
                Object var9_8 = null;
                boolean bl2 = false;
                for (Object t : iterable) {
                    Element element3 = (Element)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)element3.getAttributeValue("name"), (Object)name)) continue;
                    if (bl2) {
                        v0 = null;
                        break block4;
                    }
                    var9_8 = t;
                    bl2 = true;
                }
                v0 = !bl2 ? null : var9_8;
            }
            element = v0;
        } else {
            element = null;
        }
        Element element4 = element;
        this.model = element4 != null ? new XamarinSdkModel(element4) : null;
    }

    @Override
    public final boolean supportedByOS() {
        return SystemInfo.isWindows || SystemInfo.isMac;
    }

    @Override
    protected final boolean isActionAvailable() {
        return this.model == null || Intrinsics.areEqual((Object)this.model.getType(), (Object)"JetBrains");
    }

    @Override
    @Nullable
    public String getActionNotAvailableReason() {
        XamarinSdkModel xamarinSdkModel = this.model;
        if (Intrinsics.areEqual((Object)(xamarinSdkModel != null ? xamarinSdkModel.getType() : null), (Object)"VisualStudio")) {
            return RiderEnvironmentSetupBundle.Companion.message("XamarinEnvironmentComponentBase.reason.can.not.update.visual.studio.xamarin.sdk", new Object[0]);
        }
        return super.getActionNotAvailableReason();
    }

    @Override
    @Nullable
    protected String getVersionSuffix() {
        String string;
        Object object = this.model;
        if (object != null && (object = ((XamarinSdkModel)object).getType()) != null) {
            Object object2 = object;
            boolean bl = false;
            string = "<font color=\"gray\">" + (String)object2 + "</font>";
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    protected final RiderNuGetOperation.Version getLocalVersion() {
        XamarinSdkModel xamarinSdkModel = this.model;
        return xamarinSdkModel != null ? xamarinSdkModel.getVersion() : null;
    }

    @Override
    public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        if (SystemInfo.isWindows) {
            EnvironmentSetupUtils.INSTANCE.downloadAndExtract(url2, pi, (Function1<? super File, Unit>)((Function1)arg_0 -> XamarinEnvironmentComponentBase.G(pi, this, arg_0)));
        }
        if (SystemInfo.isMac) {
            EnvironmentSetupUtils.INSTANCE.downloadAndInstallPkg(url2, pi);
        }
    }

    private final List<File> G(File file2) {
        File file3;
        File[] fileArray;
        if (!file2.exists() || !file2.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        File[] fileArray2 = file2.listFiles(XamarinEnvironmentComponentBase::G);
        if (fileArray2 == null) {
            return CollectionsKt.emptyList();
        }
        Object object = fileArray = fileArray2;
        boolean bl = false;
        File[] fileArray3 = object;
        Collection collection = new ArrayList(((File[])object).length);
        boolean bl2 = false;
        int n = fileArray3.length;
        for (int j = 0; j < n; ++j) {
            File file4 = file3 = fileArray3[j];
            Collection collection2 = collection;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)file4);
            collection2.add(FilesKt.resolve((File)FilesKt.resolve((File)file4, (String)"Bin"), (String)"MSBuild.exe"));
        }
        object = (List)collection;
        bl = false;
        fileArray3 = object;
        collection = new ArrayList();
        bl2 = false;
        for (Object t : fileArray3) {
            file3 = (File)t;
            boolean bl4 = false;
            if (!file3.exists()) continue;
            collection.add(t);
        }
        return (List)collection;
    }

    private static final Unit G(ProgressIndicator progressIndicator, XamarinEnvironmentComponentBase xamarinEnvironmentComponentBase, File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"folder");
        progressIndicator.setText2(RiderBundle.message("progress.details.installing", new Object[0]));
        progressIndicator.setIndeterminate(true);
        File file3 = FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getenv("LOCALAPPDATA")), (String)"JetBrains"), (String)"BuildTools");
        File file4 = FilesKt.resolve((File)file3, (String)"MSBuild");
        File file5 = new File(PathManager.getHomePath(), "tools");
        File file6 = FilesKt.resolve((File)file5, (String)"MSBuild");
        if (!file6.exists()) {
            throw new Exception((String)(PluginManagerCore.isRunningFromSources() ? "There is no bundled MSBuild in Rider running from sources, can not install Xamarin SDK" : "There is no MSBuild in Rider installation: '" + file6 + "'. Try to reinstall Rider from scratch."));
        }
        List<File> list2 = xamarinEnvironmentComponentBase.G(file4);
        if (list2.isEmpty()) {
            EnvironmentSetupUtils.moveDirectoryContentRecursive$default(EnvironmentSetupUtils.INSTANCE, file6, file4, EnvironmentSetupUtils.MoveStrategy.CopyOverwrite, null, 8, null);
            EnvironmentSetupUtils.moveDirectoryContentRecursive$default(EnvironmentSetupUtils.INSTANCE, FilesKt.resolve((File)file5, (String)"Common7"), FilesKt.resolve((File)file3, (String)"Common7"), EnvironmentSetupUtils.MoveStrategy.CopyOverwrite, null, 8, null);
        }
        progressIndicator.startNonCancelableSection();
        EnvironmentSetupUtils.moveDirectoryContentRecursive$default(EnvironmentSetupUtils.INSTANCE, file2, file3, EnvironmentSetupUtils.MoveStrategy.MoveOverwrite, null, 8, null);
        progressIndicator.finishNonCancelableSection();
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean G(File file2) {
        if (!file2.isDirectory()) return false;
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CharSequence charSequence = string;
        if (!new Regex("\\d+\\.\\d+").matches(charSequence)) return false;
        return true;
    }
}

