/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.EnvironmentComponent;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import com.jetbrains.rider.ui.RiderColorKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH$J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\rJ\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0004J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0011R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u000f8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/environmentSetup/SingleEnvironmentComponent;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "SingleEnvironmentComponent", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;)V", "getLocalReader", "()Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "getUpdatesReader", "()Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "getLocalVersion", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "packageName", "", "getPackageName", "()Ljava/lang/String;", "isActionAvailable", "", "version", "getVersion", "getRawVersion", "versionSuffix", "getVersionSuffix", "updatedVersion", "actionNotAvailableReason", "getActionNotAvailableReason", "getAction", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "url", "intellij.rider"})
public abstract class SingleEnvironmentComponent
extends EnvironmentComponent {
    @NotNull
    private final ComponentsLocalReader localReader;
    @NotNull
    private final ComponentsUpdatesReader updatesReader;
    @Nullable
    private final String packageName;
    @Nullable
    private final String versionSuffix;
    @Nullable
    private RiderNuGetOperation.Version updatedVersion;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    private final String actionNotAvailableReason;

    public SingleEnvironmentComponent(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader) {
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        this.localReader = localReader;
        this.updatesReader = updatesReader;
        this.actionNotAvailableReason = RiderBundle.message("there.are.no.updates.sentence", new Object[0]);
    }

    @NotNull
    public final ComponentsLocalReader getLocalReader() {
        return this.localReader;
    }

    @NotNull
    public final ComponentsUpdatesReader getUpdatesReader() {
        return this.updatesReader;
    }

    @Nullable
    protected abstract RiderNuGetOperation.Version getLocalVersion();

    @Nullable
    protected String getPackageName() {
        return this.packageName;
    }

    protected boolean isActionAvailable() {
        return true;
    }

    @Override
    @NotNull
    public final String getVersion() {
        RiderNuGetOperation.Version version = this.getRawVersion();
        Object object = version;
        if (object == null || (object = ((RiderNuGetOperation.Version)object).getOriginalString()) == null) {
            Color color = JBUI.CurrentTheme.Label.disabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"disabledForeground(...)");
            object = "<font color=\"" + RiderColorKt.toHtml((Color)color) + "\">Not installed</font>";
        }
        Object object2 = object;
        String string = this.getVersionSuffix();
        if (string == null) {
            return object2;
        }
        String string2 = string;
        return (String)object2 + " " + string2;
    }

    @Nullable
    public final RiderNuGetOperation.Version getRawVersion() {
        RiderNuGetOperation.Version version = this.updatedVersion;
        if (version == null) {
            version = this.getLocalVersion();
        }
        return version;
    }

    @Nullable
    protected String getVersionSuffix() {
        return this.versionSuffix;
    }

    @Override
    @Nullable
    public String getActionNotAvailableReason() {
        return this.actionNotAvailableReason;
    }

    @Override
    @Nullable
    public EnvironmentComponent.Action getAction() {
        if (!(this.localReader.isValid() && this.updatesReader.isValid() && this.isActionAvailable())) {
            return null;
        }
        ComponentsUpdatesReader.Info info = this.updatesReader.get(this.getId(), this.getPackageName());
        if (info == null) {
            return null;
        }
        ComponentsUpdatesReader.Info info2 = info;
        RiderNuGetOperation.Version version = this.getLocalVersion();
        if (version == null) {
            return new EnvironmentComponent.InstallAction(info2.getVersion().toString(), info2.getSize() + " Mb");
        }
        RiderNuGetOperation.Version version2 = version;
        if (version2.compareTo(info2.getVersion()) < 0) {
            return new EnvironmentComponent.UpdateAction(info2.getVersion().toString(), info2.getSize() + " Mb");
        }
        return null;
    }

    @Override
    protected final void doExecute(@NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        ComponentsUpdatesReader.Info info = this.updatesReader.get(this.getId(), this.getPackageName());
        if (info == null) {
            return;
        }
        ComponentsUpdatesReader.Info info2 = info;
        this.doExecute(pi, info2.getUrl());
        this.updatedVersion = info2.getVersion();
    }

    public abstract void doExecute(@NotNull ProgressIndicator var1, @NotNull String var2);
}

