/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.platform.util.ApplicationKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.EnvironmentAnalyzer;
import com.jetbrains.rider.environmentSetup.EnvironmentComponent;
import com.jetbrains.rider.environmentSetup.EnvironmentIndicatorBase;
import com.jetbrains.rider.environmentSetup.EnvironmentSetupPanelKt;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.wizard.RiderUnderWizardRunner;
import com.jetbrains.rider.wizard.core.stat.RiderWizardStat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0002'(B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001b\u001a\u00020\nH\u0002J&\u0010\u001c\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\n2\b\b\u0001\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020\u00132\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "project", "Lcom/intellij/openapi/project/Project;", "backgroundColor", "Ljava/awt/Color;", "loadingPanel", "Ljavax/swing/JComponent;", "onRestartRequested", "Lkotlin/Function0;", "", "EnvironmentSetupPanel", "(Lcom/intellij/openapi/project/Project;Ljava/awt/Color;Ljavax/swing/JComponent;Lkotlin/jvm/functions/Function0;)V", "isCalledOnInitialStep", "", "analyzer", "Lcom/jetbrains/rider/environmentSetup/EnvironmentAnalyzer;", "components", "", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "mainPanel", "infoPanel", "Ljavax/swing/JPanel;", "scrollPanel", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPanel", "()Lcom/intellij/ui/components/JBScrollPane;", "G", "G", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "G", "error", "", "G", "component", "onInstalled", "Companion", "MyIndicator", "intellij.rider"})
public final class EnvironmentSetupPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Color backgroundColor;
    @NotNull
    private final JComponent loadingPanel;
    @Nullable
    private final Function0<Unit> onRestartRequested;
    private final boolean isCalledOnInitialStep;
    @NotNull
    private final EnvironmentAnalyzer analyzer;
    @NotNull
    private List<? extends EnvironmentComponent> components;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    @NotNull
    private final JPanel infoPanel;
    @NotNull
    private final JBScrollPane scrollPanel;
    @Nls
    @NotNull
    private static final String defaultHeader = RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.setup.environment.configuration.on.the.machine", new Object[0]);

    public EnvironmentSetupPanel(@Nullable Project project, @Nullable Color backgroundColor, @NotNull JComponent loadingPanel, @Nullable Function0<Unit> onRestartRequested) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)loadingPanel, (String)"loadingPanel");
        this.backgroundColor = backgroundColor;
        this.loadingPanel = loadingPanel;
        this.onRestartRequested = onRestartRequested;
        this.isCalledOnInitialStep = this.onRestartRequested == null;
        this.analyzer = new EnvironmentAnalyzer(project, this.isCalledOnInitialStep);
        this.components = CollectionsKt.emptyList();
        BorderLayoutPanel borderLayoutPanel = object = new BorderLayoutPanel();
        EnvironmentSetupPanel environmentSetupPanel = this;
        boolean bl = false;
        borderLayoutPanel.setOpaque(true);
        borderLayoutPanel.setBackground(this.backgroundColor);
        environmentSetupPanel.mainPanel = object;
        this.infoPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)5)));
        borderLayoutPanel = object = new JBScrollPane((Component)this.mainPanel, 20, 31);
        environmentSetupPanel = this;
        bl = false;
        borderLayoutPanel.setOpaque(true);
        borderLayoutPanel.setBorder((Border)JBUI.Borders.empty());
        environmentSetupPanel.scrollPanel = object;
        this.addToCenter((Component)this.scrollPanel);
        borderLayoutPanel = object = this.infoPanel;
        environmentSetupPanel = this;
        bl = false;
        borderLayoutPanel.setBorder(JBUI.Borders.empty((int)15));
        environmentSetupPanel.addToBottom((Component)object);
        this.G();
    }

    @NotNull
    public final JBScrollPane getScrollPanel() {
        return this.scrollPanel;
    }

    private final void G() {
        this.mainPanel.removeAll();
        this.infoPanel.removeAll();
        this.mainPanel.addToCenter((Component)this.loadingPanel);
        this.invalidate();
        this.repaint();
        this.analyzer.analyze((Function3<? super List<? extends EnvironmentComponent>, ? super ComponentsLocalReader, ? super ComponentsUpdatesReader, Unit>)((Function3)(arg_0, arg_1, arg_2) -> EnvironmentSetupPanel.G(this, arg_0, arg_1, arg_2)), (Function1<? super String, Unit>)((Function1)arg_0 -> EnvironmentSetupPanel.G(this, arg_0)), (Function1<? super EnvironmentComponent, Boolean>)((Function1)EnvironmentSetupPanel::G));
    }

    private final void G(List<? extends EnvironmentComponent> list2, ComponentsLocalReader componentsLocalReader, ComponentsUpdatesReader componentsUpdatesReader) {
        LinkLabel linkLabel;
        Serializable serializable;
        Object object;
        this.components = list2;
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)new GridLayout(0, 2));
        for (EnvironmentComponent environmentComponent : list2) {
            HtmlChunk.Element element;
            JComponent jComponent;
            String string;
            Object object2;
            object = object2 = new OpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
            boolean bl = false;
            object.setBorder(JBUI.Borders.empty((int)15));
            opaquePanel.add((Component)object);
            serializable = object2;
            object = object2 = new JLabel(environmentComponent.getIcon());
            Throwable throwable = serializable;
            bl = false;
            object.setVerticalAlignment(1);
            throwable.add((Component)object2, "West");
            object2 = new OpaquePanel((LayoutManager)new VerticalLayout(JBUI.scale((int)5), JBUI.scale((int)181)));
            serializable.add((Component)object2);
            object = new LinkLabel("<html><b>" + environmentComponent.getName() + "</b></html>", null, (arg_0, arg_1) -> EnvironmentSetupPanel.G(environmentComponent, arg_0, arg_1));
            object2.add(RelativeFont.LARGE.install((Component)object));
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.html().addRaw(RiderBundle.message("label.version", new Object[0]) + " " + environmentComponent.getVersion()), (String)"addRaw(...)");
            Intrinsics.checkNotNullExpressionValue((Object)linkLabel.toString(), (String)"toString(...)");
            JLabel jLabel = new JLabel(string);
            object2.add((Component)jLabel);
            Intrinsics.checkNotNullExpressionValue((Object)HtmlChunk.text((String)environmentComponent.getDescription()).wrapWith(HtmlChunk.Element.html()), (String)"wrapWith(...)");
            JLabel jLabel2 = jComponent = new JLabel(element.toString());
            boolean bl2 = false;
            jLabel2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
            JLabel jLabel3 = jComponent;
            object2.add((Component)jLabel3);
            jComponent = this.G(environmentComponent, (Function0<Unit>)((Function0)() -> EnvironmentSetupPanel.G(jLabel, string, environmentComponent, this)));
            if (jComponent == null) continue;
            object2.add((Component)jComponent);
        }
        this.mainPanel.removeAll();
        this.mainPanel.addToTop((Component)opaquePanel);
        this.infoPanel.removeAll();
        Throwable throwable = componentsLocalReader.getError();
        if (throwable != null) {
            serializable = throwable;
            boolean bl = false;
            this.infoPanel.add(Companion.createLocalErrorLabel((Throwable)serializable));
        }
        Throwable throwable2 = componentsUpdatesReader.getError();
        if (throwable2 != null) {
            serializable = throwable2;
            boolean bl = false;
            this.infoPanel.add(Companion.createUpdatesErrorLabel((Throwable)serializable));
            this.infoPanel.add((Component)new LinkLabel(RiderBundle.message("link.label.refresh", new Object[0]), AllIcons.Actions.Refresh, (arg_0, arg_1) -> EnvironmentSetupPanel.G(this, arg_0, arg_1)));
        }
        Application application = ApplicationKt.getApplicationOrNull();
        boolean bl = application != null ? application.isInternal() : false;
        if (bl) {
            File file2 = componentsLocalReader.getFile();
            if (file2 != null) {
                serializable = file2;
                boolean bl3 = false;
                object = "View environment [internal]";
                linkLabel = new LinkLabel((String)object, AllIcons.FileTypes.Text, (arg_0, arg_1) -> EnvironmentSetupPanel.G((File)serializable, arg_0, arg_1));
                this.infoPanel.add((Component)linkLabel);
            }
            File file3 = componentsUpdatesReader.getFile();
            if (file3 != null) {
                serializable = file3;
                boolean bl4 = false;
                object = "View updates [internal]";
                linkLabel = new LinkLabel((String)object, AllIcons.FileTypes.Text, (arg_0, arg_1) -> EnvironmentSetupPanel.b((File)serializable, arg_0, arg_1));
                this.infoPanel.add((Component)linkLabel);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private final void G(@NlsContexts.Label String string) {
        this.mainPanel.removeAll();
        this.mainPanel.addToCenter((Component)new JLabel(string, 0));
        this.revalidate();
        this.repaint();
    }

    private final JPanel G(EnvironmentComponent environmentComponent, Function0<Unit> function0) {
        BorderLayoutPanel borderLayoutPanel;
        EnvironmentComponent.Action action2 = environmentComponent.getAction();
        if (action2 == null) {
            JLabel jLabel;
            String string = environmentComponent.getActionNotAvailableReason();
            if (string == null) {
                return null;
            }
            String string2 = string;
            JLabel jLabel2 = jLabel = new JLabel("<html><font color=\"gray\" size=\"-1\">" + string2 + "</font></html>");
            boolean bl = false;
            jLabel2.setBackground(this.backgroundColor);
            JLabel jLabel3 = jLabel;
            jLabel2 = jLabel = new BorderLayoutPanel();
            bl = false;
            jLabel2.addToCenter(jLabel3);
            jLabel2.setBackground(this.backgroundColor);
            return (JPanel)((Object)jLabel);
        }
        CardLayout cardLayout = new CardLayout();
        OpaquePanel opaquePanel = new OpaquePanel((LayoutManager)cardLayout);
        HtmlChunk.Element element = HtmlChunk.html().addRaw(RiderBundle.message("label.version", new Object[0]) + " " + action2.getVersion() + " [" + action2.getSize() + "]");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"addRaw(...)");
        HtmlChunk.Element element2 = element;
        String string = element2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string3 = string;
        Object object = new InstallButton(false);
        Object object2 = object;
        boolean bl = false;
        object2.setText(action2.getName());
        InstallButton installButton = object;
        Object object3 = object2 = new JLabel(string3, 0);
        boolean bl2 = false;
        ((JComponent)object3).setBackground(this.backgroundColor);
        object = object2;
        Object object4 = object3 = new LinkLabel("", AllIcons.Actions.Cancel);
        boolean bl3 = false;
        object4.setBackground(this.backgroundColor);
        object2 = object3;
        Object object5 = object4 = new JProgressBar(0, 100);
        boolean bl4 = false;
        ((JComponent)object5).setBackground(this.backgroundColor);
        object3 = object4;
        object4 = new MyIndicator((JProgressBar)object3, (JLabel)object, cardLayout, (JPanel)opaquePanel, (JButton)installButton, (LinkLabel<Object>)object2);
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl5 = false;
        borderLayoutPanel2.setBackground(this.backgroundColor);
        object5 = borderLayoutPanel;
        object5.addToCenter((Component)object3);
        object5.addToRight((Component)object2);
        opaquePanel.add((Component)installButton, (Object)"button");
        opaquePanel.add((Component)object5, (Object)"progress");
        cardLayout.show((Container)opaquePanel, "button");
        borderLayoutPanel = new OpaquePanel((LayoutManager)new VerticalFlowLayout(true, false));
        borderLayoutPanel.add((Component)opaquePanel);
        borderLayoutPanel.add((Component)object);
        installButton.addActionListener(arg_0 -> EnvironmentSetupPanel.G((MyIndicator)((Object)object4), environmentComponent, (JLabel)object, cardLayout, opaquePanel, function0, arg_0));
        object2.setListener((arg_0, arg_1) -> EnvironmentSetupPanel.G((MyIndicator)((Object)object4), (JLabel)object, string3, arg_0, arg_1), null);
        return (JPanel)borderLayoutPanel;
    }

    private static final Unit G(EnvironmentSetupPanel environmentSetupPanel, List list2, ComponentsLocalReader componentsLocalReader, ComponentsUpdatesReader componentsUpdatesReader) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"components");
        Intrinsics.checkNotNullParameter((Object)componentsLocalReader, (String)"localFile");
        Intrinsics.checkNotNullParameter((Object)componentsUpdatesReader, (String)"updatesFile");
        environmentSetupPanel.G(list2, componentsLocalReader, componentsUpdatesReader);
        return Unit.INSTANCE;
    }

    private static final Unit G(EnvironmentSetupPanel environmentSetupPanel, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        environmentSetupPanel.G(string);
        return Unit.INSTANCE;
    }

    private static final boolean G(EnvironmentComponent environmentComponent) {
        Intrinsics.checkNotNullParameter((Object)environmentComponent, (String)"it");
        return true;
    }

    private static final Unit G(EnvironmentComponent environmentComponent) {
        RiderWizardStat.INSTANCE.envStepOnLinkClick(environmentComponent);
        return Unit.INSTANCE;
    }

    private static final void G(EnvironmentComponent environmentComponent, LinkLabel linkLabel, Object object) {
        try {
            RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)() -> EnvironmentSetupPanel.G(environmentComponent)));
            BrowserUtil.browse((String)environmentComponent.getUrl());
        }
        catch (Throwable throwable) {
            EnvironmentSetupPanelKt.access$getLogger$p().warn(throwable);
            Object[] objectArray = new Object[]{environmentComponent.getUrl()};
            String string = RiderEnvironmentSetupBundle.Companion.message("dialog.message.failed.to.open.link", objectArray);
            objectArray = new String[]{CommonBundle.getOkButtonText()};
            MessageDialog messageDialog = new MessageDialog(string, ApplicationNamesInfo.getInstance().getFullProductName(), (String[])objectArray, 0, UIUtil.getErrorIcon());
        }
    }

    private static final Unit G(JLabel jLabel, String string, EnvironmentComponent environmentComponent, EnvironmentSetupPanel environmentSetupPanel) {
        block1: {
            jLabel.setText(string);
            if (!environmentComponent.getRestartRequested()) break block1;
            Function0<Unit> function0 = environmentSetupPanel.onRestartRequested;
            if (function0 != null) {
                function0.invoke();
            }
        }
        return Unit.INSTANCE;
    }

    private static final void G(EnvironmentSetupPanel environmentSetupPanel, LinkLabel linkLabel, Object object) {
        environmentSetupPanel.G();
    }

    private static final void G(File file2, LinkLabel linkLabel, Object object) {
        BrowserUtil.browse((File)file2);
    }

    private static final void b(File file2, LinkLabel linkLabel, Object object) {
        BrowserUtil.browse((File)file2);
    }

    private static final void G(JLabel jLabel, CardLayout cardLayout, OpaquePanel opaquePanel) {
        jLabel.setText(null);
        jLabel.setIcon(null);
        jLabel.setToolTipText("");
        cardLayout.show((Container)opaquePanel, "progress");
    }

    private static final void G(OpaquePanel opaquePanel, JLabel jLabel, Function0 function0) {
        opaquePanel.setVisible(false);
        jLabel.setText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.installation.finished", new Object[0]));
        jLabel.setIcon(AllIcons.General.InspectionsOK);
        jLabel.setToolTipText("");
        function0.invoke();
    }

    private static final Unit G(OpaquePanel opaquePanel, JLabel jLabel, Function0 function0) {
        SwingUtilities.invokeLater(() -> EnvironmentSetupPanel.G(opaquePanel, jLabel, function0));
        return Unit.INSTANCE;
    }

    private static final void G(CardLayout cardLayout, OpaquePanel opaquePanel, JLabel jLabel, String string) {
        cardLayout.show((Container)opaquePanel, "button");
        jLabel.setText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.installation.error", new Object[0]));
        jLabel.setIcon(AllIcons.General.Error);
        jLabel.setToolTipText(string);
    }

    private static final Unit G(CardLayout cardLayout, OpaquePanel opaquePanel, JLabel jLabel, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"error");
        SwingUtilities.invokeLater(() -> EnvironmentSetupPanel.G(cardLayout, opaquePanel, jLabel, string));
        return Unit.INSTANCE;
    }

    private static final void G(MyIndicator myIndicator, EnvironmentComponent environmentComponent, JLabel jLabel, CardLayout cardLayout, OpaquePanel opaquePanel, Function0 function0, ActionEvent actionEvent) {
        myIndicator.start();
        SwingUtilities.invokeLater(() -> EnvironmentSetupPanel.G(jLabel, cardLayout, opaquePanel));
        environmentComponent.execute((ProgressIndicator)myIndicator, (Function0<Unit>)((Function0)() -> EnvironmentSetupPanel.G(opaquePanel, jLabel, function0)), (Function1<? super String, Unit>)((Function1)arg_0 -> EnvironmentSetupPanel.G(cardLayout, opaquePanel, jLabel, arg_0)));
    }

    private static final void G(JLabel jLabel, String string) {
        jLabel.setText(string);
        jLabel.setToolTipText("");
    }

    private static final void G(MyIndicator myIndicator, JLabel jLabel, String string, LinkLabel linkLabel, Object object) {
        myIndicator.cancel();
        SwingUtilities.invokeLater(() -> EnvironmentSetupPanel.G(jLabel, string));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupPanel$Companion;", "", "EnvironmentSetupPanel$Companion", "()V", "defaultHeader", "", "getDefaultHeader", "()Ljava/lang/String;", "createLocalErrorLabel", "Ljavax/swing/JLabel;", "error", "", "createUpdatesErrorLabel", "G", "ex", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDefaultHeader() {
            return defaultHeader;
        }

        @NotNull
        public final JLabel createLocalErrorLabel(@NotNull Throwable error) {
            JLabel jLabel;
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            JLabel jLabel2 = jLabel = new JLabel(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.can.not.analyze.machine.environment", new Object[0]), AllIcons.General.Error, 0);
            boolean bl = false;
            jLabel2.setToolTipText(Companion.G(error));
            return jLabel;
        }

        @NotNull
        public final JLabel createUpdatesErrorLabel(@NotNull Throwable error) {
            JLabel jLabel;
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            JLabel jLabel2 = jLabel = new JLabel(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.can.not.download.updates.information", new Object[0]), AllIcons.General.Error, 0);
            boolean bl = false;
            Object[] objectArray = new Object[]{EnvironmentAnalyzer.Companion.getServerUrl(), Companion.G(error), EnvironmentAnalyzer.Companion.getServerUrlEnvVar()};
            jLabel2.setToolTipText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupPanel.updates.error.label", objectArray));
            return jLabel;
        }

        @NlsContexts.Tooltip
        private final String G(Throwable throwable) {
            String string = throwable.getMessage();
            if (string == null) {
                string = "";
            }
            String string2 = string;
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                return string2;
            }
            Throwable throwable3 = throwable2;
            return string2 + "\n" + this.G(throwable3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupPanel$MyIndicator;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentIndicatorBase;", "progressBar", "Ljavax/swing/JProgressBar;", "statusLabel", "Ljavax/swing/JLabel;", "wrapperLayout", "Ljava/awt/CardLayout;", "buttonWrapper", "Ljavax/swing/JPanel;", "installButton", "Ljavax/swing/JButton;", "cancelLink", "Lcom/intellij/ui/components/labels/LinkLabel;", "", "EnvironmentSetupPanel$MyIndicator", "(Ljavax/swing/JProgressBar;Ljavax/swing/JLabel;Ljava/awt/CardLayout;Ljavax/swing/JPanel;Ljavax/swing/JButton;Lcom/intellij/ui/components/labels/LinkLabel;)V", "myCanceled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "start", "", "processFinish", "cancel", "startNonCancelableSection", "finishNonCancelableSection", "intellij.rider"})
    private static final class MyIndicator
    extends EnvironmentIndicatorBase {
        @NotNull
        private final CardLayout wrapperLayout;
        @NotNull
        private final JPanel buttonWrapper;
        @NotNull
        private final JButton installButton;
        @NotNull
        private final LinkLabel<Object> cancelLink;
        @NotNull
        private final AtomicBoolean myCanceled;

        public MyIndicator(@NotNull JProgressBar progressBar, @NotNull JLabel statusLabel, @NotNull CardLayout wrapperLayout, @NotNull JPanel buttonWrapper, @NotNull JButton installButton, @NotNull LinkLabel<Object> cancelLink) {
            Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
            Intrinsics.checkNotNullParameter((Object)statusLabel, (String)"statusLabel");
            Intrinsics.checkNotNullParameter((Object)wrapperLayout, (String)"wrapperLayout");
            Intrinsics.checkNotNullParameter((Object)buttonWrapper, (String)"buttonWrapper");
            Intrinsics.checkNotNullParameter((Object)installButton, (String)"installButton");
            Intrinsics.checkNotNullParameter(cancelLink, (String)"cancelLink");
            super(progressBar, statusLabel);
            this.wrapperLayout = wrapperLayout;
            this.buttonWrapper = buttonWrapper;
            this.installButton = installButton;
            this.cancelLink = cancelLink;
            this.myCanceled = new AtomicBoolean(false);
        }

        public void start() {
            this.myCanceled.set(false);
            super.start();
            SwingUtilities.invokeLater(() -> MyIndicator.D(this));
        }

        public void processFinish() {
            super.processFinish();
            SwingUtilities.invokeLater(() -> MyIndicator.r(this));
        }

        @Override
        public void cancel() {
            this.myCanceled.set(true);
            super.cancel();
            SwingUtilities.invokeLater(() -> MyIndicator.a(this));
        }

        public void startNonCancelableSection() {
            super.startNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.G(this));
        }

        public void finishNonCancelableSection() {
            super.finishNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.b(this));
        }

        private static final void D(MyIndicator myIndicator) {
            myIndicator.wrapperLayout.show(myIndicator.buttonWrapper, "progress");
            myIndicator.cancelLink.setEnabled(true);
        }

        private static final void r(MyIndicator myIndicator) {
            myIndicator.wrapperLayout.show(myIndicator.buttonWrapper, "button");
            myIndicator.installButton.setEnabled(false);
            myIndicator.installButton.setText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupManager.label.installed", new Object[0]));
        }

        private static final void a(MyIndicator myIndicator) {
            myIndicator.wrapperLayout.show(myIndicator.buttonWrapper, "button");
        }

        private static final void G(MyIndicator myIndicator) {
            myIndicator.cancelLink.setEnabled(false);
        }

        private static final void b(MyIndicator myIndicator) {
            myIndicator.cancelLink.setEnabled(true);
        }
    }
}

