/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.resolveContextWidget;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.editors.resolveContextWidget.RiderResolveContextWidget;
import com.jetbrains.rider.editors.resolveContextWidget.RiderResolveContextWidgetManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editors/resolveContextWidget/WidgetAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "widgetId", "", "WidgetAction", "(Ljava/lang/String;)V", "FOREGROUND", "Lcom/intellij/openapi/editor/colors/ColorKey;", "Lorg/jetbrains/annotations/NotNull;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateInternal", "widget", "Lcom/jetbrains/rider/editors/resolveContextWidget/RiderResolveContextWidget;", "actionPerformed", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WidgetAction.kt\ncom/jetbrains/rider/editors/resolveContextWidget/WidgetAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public abstract class WidgetAction
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final String widgetId;
    @NotNull
    private final ColorKey FOREGROUND;

    public WidgetAction(@NotNull String widgetId) {
        Intrinsics.checkNotNullParameter((Object)widgetId, (String)"widgetId");
        this.widgetId = widgetId;
        ColorKey colorKey = ColorKey.createColorKey((String)"ActionButton.iconTextForeground", (Color)UIUtil.getContextHelpForeground());
        Intrinsics.checkNotNullExpressionValue((Object)colorKey, (String)"createColorKey(...)");
        this.FOREGROUND = colorKey;
        if (!SystemInfo.isWindows) {
            this.getTemplatePresentation().putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JBDimension jBDimension = JBUI.size((int)18);
        ActionButtonWithText actionButtonWithText = new ActionButtonWithText(this, presentation, place, jBDimension){

            protected int iconTextSpace() {
                return JBUI.scale((int)2);
            }

            public Insets getInsets() {
                JBInsets jBInsets = JBUI.insets((int)2);
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
                return (Insets)jBInsets;
            }
        };
        JBDimension jBDimension2 = jBDimension = JBColor.lazy(() -> WidgetAction.G(this));
        boolean bl = false;
        actionButtonWithText.setForeground((Color)jBDimension2);
        return (JComponent)actionButtonWithText;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e2) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        RiderResolveContextWidget riderResolveContextWidget = RiderResolveContextWidgetManager.INSTANCE.getWidget(editor2, this.widgetId);
        if (riderResolveContextWidget == null) {
            e2.getPresentation().setEnabledAndVisible(false);
            return;
        }
        this.updateInternal(e2, riderResolveContextWidget);
    }

    protected abstract void updateInternal(@NotNull AnActionEvent var1, @NotNull RiderResolveContextWidget var2);

    public void actionPerformed(@NotNull AnActionEvent e2) {
        block3: {
            RelativePoint relativePoint;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
            Editor editor2 = (Editor)e2.getData(CommonDataKeys.EDITOR);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            JComponent jComponent = (JComponent)e2.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
            if (jComponent != null) {
                relativePoint = new RelativePoint((Component)jComponent, new Point(0, jComponent.getHeight()));
            } else {
                InputEvent inputEvent = e2.getInputEvent();
                Point point = inputEvent instanceof MouseEvent ? ((MouseEvent)inputEvent).getPoint() : new Point(editor3.getComponent().getWidth(), 0);
                relativePoint = new RelativePoint((Component)editor3.getComponent(), point);
            }
            RelativePoint relativePoint2 = relativePoint;
            RiderResolveContextWidget riderResolveContextWidget = RiderResolveContextWidgetManager.INSTANCE.getWidget(editor3, this.widgetId);
            if (riderResolveContextWidget == null) break block3;
            riderResolveContextWidget.showPopup(relativePoint2);
        }
    }

    private static final Color G(WidgetAction widgetAction) {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(widgetAction.FOREGROUND);
        if (color == null && (color = widgetAction.FOREGROUND.getDefaultColor()) == null) {
            color = UIUtil.getInactiveTextColor();
        }
        return color;
    }
}

