/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.diagnostics;

import com.jetbrains.rider.diagnostics.StructuredGcCalls;
import com.jetbrains.rider.diagnostics.StructuredMessage;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a%\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\n\u00a2\u0006\u0002\u0010\u000e\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\b\u001a\u0018\u0010\u0018\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\bH\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\"\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"timePattern", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "Ljava/time/format/DateTimeFormatter;", "messagePattern", "Lkotlin/text/Regex;", "parseStructuredLog", "", "Lcom/jetbrains/rider/diagnostics/StructuredMessage;", "file", "Ljava/io/File;", "parseMultipleStructuredLogs", "files", "", "([Ljava/io/File;)Ljava/util/List;", "valueInMessagePatterns", "[Lkotlin/text/Regex;", "extractStructuredValue", "", "message", "gc0InMessagePattern", "gc1InMessagePattern", "gc2InMessagePattern", "gcLohInMessagePattern", "extractGcValue", "Lcom/jetbrains/rider/diagnostics/StructuredGcCalls;", "", "regex", "totalMemoryPattern", "extractTotalMemory", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nStructuredLogParsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructuredLogParsing.kt\ncom/jetbrains/rider/diagnostics/StructuredLogParsingKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n11158#2:155\n11493#2,3:156\n13497#2,3:160\n1#3:159\n*S KotlinDebug\n*F\n+ 1 StructuredLogParsing.kt\ncom/jetbrains/rider/diagnostics/StructuredLogParsingKt\n*L\n97#1:155\n97#1:156,3\n103#1:160,3\n*E\n"})
public final class StructuredLogParsingKt {
    private static final DateTimeFormatter timePattern = DateTimeFormatter.ofPattern("yyyy-M-d HH:mm:ss.SSS");
    @NotNull
    private static final Regex messagePattern = new Regex("^[\\s]*<([^>]+)> \"([^\"]+)\"(.*?)[\u200b\u200c\u200b]*$");
    @NotNull
    private static final Regex[] valueInMessagePatterns;
    @NotNull
    private static final Regex gc0InMessagePattern;
    @NotNull
    private static final Regex gc1InMessagePattern;
    @NotNull
    private static final Regex gc2InMessagePattern;
    @NotNull
    private static final Regex gcLohInMessagePattern;
    @NotNull
    private static final Regex totalMemoryPattern;

    @NotNull
    public static final List<StructuredMessage> parseStructuredLog(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ArrayList<StructuredMessage> arrayList = new ArrayList<StructuredMessage>();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
        List list2 = FilesKt.readLines((File)file2, (Charset)charset);
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = 0;
        while (n4 < list2.size()) {
            Object object;
            MatchResult matchResult;
            int n5;
            Object object2 = new char[]{'|'};
            List list3 = StringsKt.split$default((CharSequence)((CharSequence)list2.get(n4)), (char[])object2, (boolean)false, (int)0, (int)6, null);
            object2 = new ArrayList();
            while (n4 != CollectionsKt.getLastIndex((List)list2) && ((String)list2.get(n4 + 1)).charAt(0) == ' ') {
                object2.add(list2.get(n4 + 1));
                n5 = n4;
                n4 = n5 + 1;
            }
            int n6 = n5 = list3.size() == 4 ? 1 : 0;
            if (_Assertions.ENABLED && n5 == 0) {
                boolean bl = false;
                String string = "Log line " + n4 + " has odd fields in it (expected time,severity,category,message; got " + list3.size() + " fields";
                throw new AssertionError((Object)string);
            }
            String string = ((Object)StringsKt.trim((CharSequence)((String)list3.get(0)))).toString();
            String string2 = n + "-" + n2 + "-" + n3 + " " + string;
            LocalDateTime localDateTime = LocalDateTime.parse(string2, timePattern);
            String string3 = ((Object)StringsKt.trim((CharSequence)((String)list3.get(2)))).toString();
            String string4 = (String)list3.get(3);
            if (messagePattern.matchEntire((CharSequence)string4) == null) {
                throw new IllegalStateException(("Message doesn't match the structured regex (message: '" + string4 + "', messagePattern: '" + messagePattern + "')").toString());
            }
            String string5 = (String)matchResult.getGroupValues().get(1);
            String string6 = (String)matchResult.getGroupValues().get(2);
            String string7 = ((Object)StringsKt.trim((CharSequence)((String)matchResult.getGroupValues().get(3)))).toString();
            if (!((Collection)arrayList).isEmpty() && localDateTime.compareTo(((StructuredMessage)CollectionsKt.last((List)arrayList)).getEventTime()) < 0) {
                if (++n3 > calendar.getActualMaximum(5)) {
                    n3 = 1;
                    if (++n2 > 12) {
                        n2 = 1;
                        ++n;
                    }
                }
                object = n + "-" + n2 + "-" + n3 + " " + ((Object)StringsKt.trim((CharSequence)((String)list3.get(0)))).toString();
                localDateTime = LocalDateTime.parse((CharSequence)object, timePattern);
            }
            if (Intrinsics.areEqual((Object)string5, (Object)"Error") && object2.isEmpty()) {
                while (n4 != CollectionsKt.getLastIndex((List)list2)) {
                    object = new char[1];
                    object[0] = 124;
                    if (StringsKt.split$default((CharSequence)((CharSequence)list2.get(n4 + 1)), (char[])object, (boolean)false, (int)0, (int)6, null).size() >= 4) break;
                    object2.add(list2.get(n4 + 1));
                    int n7 = n4;
                    n4 = n7 + 1;
                }
            }
            object = localDateTime;
            Intrinsics.checkNotNull((Object)object);
            arrayList.add(new StructuredMessage((LocalDateTime)object, string3, string5, string6, string7, (List)object2));
            int n8 = n4;
            n4 = n8 + 1;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<StructuredMessage> parseMultipleStructuredLogs(File ... files) {
        void objectArray2;
        int n;
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Object[] objectArray = files;
        boolean bl = false;
        Object object = objectArray;
        Collection collection = new ArrayList(objectArray.length);
        boolean bl2 = false;
        int n2 = ((File[])object).length;
        for (n = 0; n < n2; ++n) {
            File file2;
            File file3 = file2 = object[n];
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(StructuredLogParsingKt.parseStructuredLog(file3));
        }
        List list2 = (List)collection;
        objectArray = new int[list2.size()];
        object = list2;
        boolean n4 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            List list3 = (List)t;
            void var15_29 = objectArray2;
            boolean bl4 = false;
            int n3 = list3.size();
            objectArray2 = var15_29 + n3;
        }
        void var17_31 = objectArray2;
        ArrayList arrayList = new ArrayList((int)var17_31);
        while (true) {
            int n8 = 0;
            n8 = -1;
            Object[] objectArray3 = objectArray;
            boolean bl5 = false;
            n = 0;
            for (File file4 : objectArray3) {
                int n5 = n++;
                File file5 = file4;
                int n6 = n5;
                boolean bl6 = false;
                if (file5 >= ((List)list2.get(n6)).size() || n8 != -1 && ((StructuredMessage)((List)list2.get(n8)).get((int)objectArray[n8])).getEventTime().compareTo(((StructuredMessage)((List)list2.get(n6)).get((int)file5)).getEventTime()) <= 0) continue;
                n8 = n6;
            }
            if (n8 == -1) break;
            arrayList.add(((List)list2.get(n8)).get((int)objectArray[n8]));
            int n7 = n8;
            File file6 = objectArray[n7];
            objectArray[n7] = file6 + true;
        }
        return arrayList;
    }

    public static final long extractStructuredValue(@NotNull StructuredMessage message2) {
        Long l;
        block2: {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            for (Regex regex : valueInMessagePatterns) {
                boolean bl = false;
                Object object = Regex.find$default((Regex)regex, (CharSequence)message2.getMessage(), (int)0, (int)2, null);
                if ((object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? Long.valueOf(Long.parseLong((String)object)) : (l = null)) == null) {
                    continue;
                }
                break block2;
            }
            l = null;
        }
        return l != null ? l : -1L;
    }

    @NotNull
    public static final StructuredGcCalls extractGcValue(@NotNull StructuredMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        int n = StructuredLogParsingKt.G(gc0InMessagePattern, message2);
        int n2 = StructuredLogParsingKt.G(gc1InMessagePattern, message2);
        int n3 = StructuredLogParsingKt.G(gc2InMessagePattern, message2);
        int n4 = StructuredLogParsingKt.G(gcLohInMessagePattern, message2);
        return new StructuredGcCalls(n, n2, n3, n4);
    }

    private static final int G(Regex regex, StructuredMessage structuredMessage) {
        for (String string : structuredMessage.getExtraLines()) {
            MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (int)0, (int)2, null);
            if (matchResult == null) continue;
            MatchResult matchResult2 = matchResult;
            Object object = matchResult2.getGroups().get(1);
            return object != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : -1;
        }
        return -1;
    }

    public static final long extractTotalMemory(@NotNull StructuredMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        for (String string : message2.getExtraLines()) {
            MatchResult matchResult = Regex.find$default((Regex)totalMemoryPattern, (CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (int)0, (int)2, null);
            if (matchResult == null) continue;
            MatchResult matchResult2 = matchResult;
            Object object = matchResult2.getGroups().get(1);
            return object != null && (object = object.getValue()) != null ? Long.parseLong((String)object) : -1L;
        }
        return -1L;
    }

    static {
        Regex[] regexArray = new Regex[]{new Regex("value=(\\d+)(\\w*)$"), new Regex("time=(\\d+)ms$")};
        valueInMessagePatterns = regexArray;
        gc0InMessagePattern = new Regex("GC\\(0\\) = (\\d+)");
        gc1InMessagePattern = new Regex("GC\\(1\\) = (\\d+)");
        gc2InMessagePattern = new Regex("GC\\(2\\) = (\\d+)");
        gcLohInMessagePattern = new Regex("GC\\(LOH\\) = (\\d+)");
        totalMemoryPattern = new Regex("TotalMemory = (\\d+)");
    }
}

