/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.winforms.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.winforms.DesignerEnvironmentProvider;
import com.jetbrains.rider.designers.winforms.editor.WinFormsDesignerComponent;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditorProvider;
import com.jetbrains.rider.model.DesignerDescriptor;
import com.jetbrains.rider.model.DesignerEditorState;
import com.jetbrains.rider.model.ExternalDesignerNotification;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.wormhole.awt.Wormhole;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.windows.WindowsPlatformProvider;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u000202J\u000f\u0010$\u001a\u0004\u0018\u00010#H\u0002\u00a2\u0006\u0002\u00103J\u0006\u00104\u001a\u00020\u001bJ\b\u00105\u001a\u00020\u001bH\u0002J\u0006\u00106\u001a\u00020\u001bJ\u0018\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020\u000fJ\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020;H\u0016J\b\u0010=\u001a\u00020\u000bH\u0016J\b\u0010>\u001a\u00020\u0005H\u0016J\b\u0010?\u001a\u00020\u000fH\u0016J\b\u0010@\u001a\u00020\u000fH\u0016J\b\u0010A\u001a\u00020\u001bH\u0016J\b\u0010B\u001a\u00020\u001bH\u0016J\n\u0010C\u001a\u0004\u0018\u00010DH\u0016J\u0006\u0010E\u001a\u00020\u001bJ\b\u0010F\u001a\u00020\u001bH\u0016J\u0006\u0010G\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010!R\u001c\u0010%\u001a\u0004\u0018\u00010&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditorProvider;", "WinFormsEditor", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditorProvider;)V", "fileId", "", "getFileId", "()Ljava/lang/String;", "value", "", "hasWindow", "getHasWindow", "()Z", "notification", "Lcom/jetbrains/rider/model/ExternalDesignerNotification;", "getNotification", "()Lcom/jetbrains/rider/model/ExternalDesignerNotification;", "setNotification", "(Lcom/jetbrains/rider/model/ExternalDesignerNotification;)V", "reload", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getReload", "()Lcom/jetbrains/rd/util/reactive/Signal;", "focused", "Lcom/jetbrains/rd/util/reactive/Property;", "getFocused", "()Lcom/jetbrains/rd/util/reactive/Property;", "rootWindowId", "", "getRootWindowId", "descriptor", "Lcom/jetbrains/rider/model/DesignerDescriptor;", "getDescriptor", "()Lcom/jetbrains/rider/model/DesignerDescriptor;", "setDescriptor", "(Lcom/jetbrains/rider/model/DesignerDescriptor;)V", "G", "wormhole", "Lcom/jetbrains/wormhole/awt/Wormhole;", "editorComponent", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsDesignerComponent;", "embedExternalWindow", "id", "Lcom/jetbrains/wormhole/interop/WindowId;", "()Ljava/lang/Long;", "releaseExternalWindow", "G", "save", "taskLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "forceSaving", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "getFile", "isModified", "isValid", "selectNotify", "deselectNotify", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "forceClose", "dispose", "showError", "intellij.rider"})
public final class WinFormsEditor
extends DesignerEditorBase {
    @NotNull
    private final VirtualFile targetFile;
    @NotNull
    private final WinFormsEditorProvider provider;
    @NotNull
    private final String fileId;
    private boolean hasWindow;
    @Nullable
    private ExternalDesignerNotification notification;
    @NotNull
    private final Signal<Unit> reload;
    @NotNull
    private final Property<Boolean> focused;
    @NotNull
    private final Property<Long> rootWindowId;
    @Nullable
    private DesignerDescriptor descriptor;
    @NotNull
    private final Wormhole wormhole;
    @NotNull
    private final WinFormsDesignerComponent editorComponent;

    public WinFormsEditor(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull WinFormsEditorProvider provider) {
        WinFormsDesignerComponent winFormsDesignerComponent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(project);
        this.targetFile = targetFile;
        this.provider = provider;
        String string = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((ProjectModelEntity)CollectionsKt.first((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)this.getFile(), (Project)project))).getDescriptor(), (String)"WINFORMS.ID");
        Intrinsics.checkNotNull((Object)string);
        this.fileId = string;
        this.reload = new Signal();
        this.focused = new Property((Object)false);
        this.rootWindowId = new Property((Object)0L);
        this.wormhole = new Wormhole(new WindowsPlatformProvider(DesignerEnvironmentProvider.INSTANCE, null, 2, null), null, 2, null);
        WinFormsDesignerComponent winFormsDesignerComponent2 = winFormsDesignerComponent = new WinFormsDesignerComponent(this, this.getLifetime(), this.wormhole);
        WinFormsEditor winFormsEditor = this;
        boolean bl = false;
        SourceExKt.flowInto((ISource)((ISource)winFormsDesignerComponent2.getFocused()), (Lifetime)this.getLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)this.focused));
        SourceExKt.flowInto((ISource)((ISource)this.focused), (Lifetime)this.getLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)winFormsDesignerComponent2.getFocused()));
        winFormsEditor.editorComponent = winFormsDesignerComponent;
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    public final boolean getHasWindow() {
        return this.hasWindow;
    }

    @Nullable
    public final ExternalDesignerNotification getNotification() {
        return this.notification;
    }

    public final void setNotification(@Nullable ExternalDesignerNotification externalDesignerNotification) {
        this.notification = externalDesignerNotification;
    }

    @NotNull
    public final Signal<Unit> getReload() {
        return this.reload;
    }

    @NotNull
    public final Property<Boolean> getFocused() {
        return this.focused;
    }

    @NotNull
    public final Property<Long> getRootWindowId() {
        return this.rootWindowId;
    }

    @Nullable
    public final DesignerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@Nullable DesignerDescriptor designerDescriptor) {
        this.descriptor = designerDescriptor;
    }

    private final boolean G() {
        DesignerDescriptor designerDescriptor = this.descriptor;
        return designerDescriptor != null && designerDescriptor.getWindowId().getValue() != null;
    }

    public final void embedExternalWindow(@NotNull WindowId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (this.hasWindow) {
            return;
        }
        this.G();
        this.hasWindow = true;
        this.wormhole.embed(id2);
        SwingUtilities.invokeLater(() -> WinFormsEditor.G(this));
    }

    private final Long G() {
        try {
            JFrame jFrame = WindowManager.getInstance().getFrame(this.getProject());
            Object t = AWTAccessor.getComponentAccessor().getPeer(jFrame);
            Method method = t.getClass().getMethod("getHWnd", new Class[0]);
            Object object = method.invoke(t, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            return (Long)object;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public final void releaseExternalWindow() {
        if (!this.hasWindow) {
            return;
        }
        if (!this.editorComponent.isLoading()) {
            this.editorComponent.startLoading();
        }
        this.wormhole.release();
        this.hasWindow = false;
    }

    private final void G() {
        if (this.editorComponent.isLoading()) {
            this.editorComponent.stopLoading();
        }
    }

    public final void save() {
        WinFormsEditor.save$default(this, this.getLifetimeDefinition().createNested(), false, 2, null);
    }

    public final void save(@NotNull LifetimeDefinition taskLifetimeDefinition, boolean forceSaving) {
        Intrinsics.checkNotNullParameter((Object)taskLifetimeDefinition, (String)"taskLifetimeDefinition");
        if (!this.G()) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)taskLifetimeDefinition, (boolean)false, (int)1, null);
            return;
        }
        DesignerDescriptor designerDescriptor = this.descriptor;
        if (designerDescriptor == null) {
            return;
        }
        DesignerDescriptor designerDescriptor2 = designerDescriptor;
        designerDescriptor2.getDesignerSaved().advise(taskLifetimeDefinition.getLifetime(), arg_0 -> WinFormsEditor.G(taskLifetimeDefinition, arg_0));
        designerDescriptor2.getSaveDesigner().fire((Object)forceSaving);
    }

    public static /* synthetic */ void save$default(WinFormsEditor winFormsEditor, LifetimeDefinition lifetimeDefinition, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        winFormsEditor.save(lifetimeDefinition, bl);
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this.editorComponent);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)((Object)this.editorComponent);
    }

    @NotNull
    public String getName() {
        return RiderDesignersBundle.Companion.message("SelectCustomAction.name.designer", new Object[0]);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.targetFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (!this.G()) return false;
        DesignerDescriptor designerDescriptor = this.descriptor;
        Intrinsics.checkNotNull((Object)designerDescriptor);
        if (designerDescriptor.getState().getValue() != DesignerEditorState.Modified) return false;
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public final void forceClose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
        Disposer.dispose((Disposable)((Disposable)this));
    }

    public void dispose() {
        if (!this.G()) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
            return;
        }
        this.save(this.getLifetimeDefinition(), true);
    }

    public final void showError() {
        this.editorComponent.markAsUnsupported();
    }

    private static final void G(WinFormsEditor winFormsEditor) {
        winFormsEditor.wormhole.revalidate();
        winFormsEditor.wormhole.repaint();
        Long l = winFormsEditor.G();
        if (l != null) {
            winFormsEditor.rootWindowId.set((Object)l);
        }
    }

    private static final Unit G(LifetimeDefinition lifetimeDefinition, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }
}

