/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.settingFiles;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.designers.DesignerEditorProviderBase;
import com.jetbrains.rider.designers.settingFiles.SettingsFileModel;
import com.jetbrains.rider.designers.settingFiles.SettingsTableFileEditor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditorProvider;", "Lcom/jetbrains/rider/designers/DesignerEditorProviderBase;", "Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditor;", "Lcom/intellij/openapi/project/DumbAware;", "SettingsTableFileEditorProvider", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDesignerNodeDescriptor", "descriptor", "Lcom/jetbrains/rider/model/RdProjectFileDescriptor;", "createDesignerEditor", "disposeEditor", "", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "Companion", "intellij.rider"})
public final class SettingsTableFileEditorProvider
extends DesignerEditorProviderBase<SettingsTableFileEditor>
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<SettingsFileModel> key = new Key("SettingsFileModel");

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (project.isDisposed()) {
            return false;
        }
        if (!StringsKt.equals((String)file2.getExtension(), (String)"settings", (boolean)true)) {
            return false;
        }
        if (!this.isDesignerNode(project, file2)) {
            return false;
        }
        SettingsFileModel settingsFileModel = new SettingsFileModel(project, file2);
        file2.putUserData(key, (Object)settingsFileModel);
        return true;
    }

    @Override
    public boolean isDesignerNodeDescriptor(@NotNull RdProjectFileDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)descriptor2), (String)"SETTINGS.DESIGNER") != null;
    }

    @Override
    @NotNull
    public SettingsTableFileEditor createDesignerEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        SwingUtilities.invokeLater(() -> SettingsTableFileEditorProvider.G(project, file2, this));
        Object object = file2.getUserData(key);
        Intrinsics.checkNotNull((Object)object);
        SettingsFileModel settingsFileModel = (SettingsFileModel)object;
        return new SettingsTableFileEditor(project, settingsFileModel);
    }

    @Override
    public void disposeEditor(@NotNull FileEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        VirtualFile virtualFile = editor2.getFile();
        if (virtualFile != null) {
            virtualFile.putUserData(key, null);
        }
        super.disposeEditor(editor2);
    }

    @NotNull
    public String getEditorTypeId() {
        return "setting-files-data-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }

    private static final void G(Project project, VirtualFile virtualFile, SettingsTableFileEditorProvider settingsTableFileEditorProvider) {
        FileEditorManager.getInstance((Project)project).setSelectedEditor(virtualFile, settingsTableFileEditorProvider.getEditorTypeId());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditorProvider$Companion;", "", "SettingsTableFileEditorProvider$Companion", "()V", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/designers/settingFiles/SettingsFileModel;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

