/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.settingFiles;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FailedEditorBuilder;
import com.intellij.openapi.fileEditor.impl.FailedEditorPaneKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.TableViewSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.DesignerUtils;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.settingFiles.SettingModel;
import com.jetbrains.rider.designers.settingFiles.SettingsFileModel;
import com.jetbrains.rider.designers.settingFiles.SettingsTableFileEditor;
import com.jetbrains.rider.designers.settingFiles.ui.NameColumn;
import com.jetbrains.rider.designers.settingFiles.ui.ScopeColumn;
import com.jetbrains.rider.designers.settingFiles.ui.TypeColumn;
import com.jetbrains.rider.designers.settingFiles.ui.ValueColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\b\u0010 \u001a\u00020\u0014H\u0016J\b\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditor;", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rider/designers/settingFiles/SettingsFileModel;", "SettingsTableFileEditor", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/designers/settingFiles/SettingsFileModel;)V", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "dataModel", "", "Lcom/jetbrains/rider/designers/settingFiles/SettingModel;", "toolbar", "Ljavax/swing/JPanel;", "table", "Lcom/intellij/ui/table/TableView;", "viewModel", "Lcom/intellij/util/ui/ListTableModel;", "refresh", "", "b", "getName", "", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isValid", "", "isModified", "dispose", "getComponent", "getPreferredFocusedComponent", "selectNotify", "r", "G", "Companion", "intellij.rider"})
public final class SettingsTableFileEditor
extends DesignerEditorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsFileModel model;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    @NotNull
    private final List<SettingModel> dataModel;
    @NotNull
    private final JPanel toolbar;
    @NotNull
    private final TableView<SettingModel> table;
    @NotNull
    private final ListTableModel<SettingModel> viewModel;
    @NotNull
    private static final Companion.stringComparator.1 stringComparator = new Comparator<String>(){

        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return StringsKt.compareTo((String)o1, (String)o2, (boolean)true);
        }
    };

    public SettingsTableFileEditor(@NotNull Project project, @NotNull SettingsFileModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project);
        this.model = model;
        this.mainPanel = new BorderLayoutPanel();
        this.dataModel = new ArrayList();
        Object object = new TableView<SettingModel>[]{NameColumn.INSTANCE, TypeColumn.INSTANCE, ScopeColumn.INSTANCE, ValueColumn.INSTANCE};
        this.viewModel = new ListTableModel((ColumnInfo[])object, this.dataModel);
        object = new TableView<SettingModel>(this.viewModel);
        TableView<SettingModel> tableView2 = object;
        SettingsTableFileEditor settingsTableFileEditor = this;
        boolean bl = false;
        tableView2.getColumnModel().getColumn(0).setPreferredWidth(550);
        tableView2.getColumnModel().getColumn(1).setPreferredWidth(350);
        tableView2.getColumnModel().getColumn(2).setPreferredWidth(350);
        tableView2.getColumnModel().getColumn(3).setPreferredWidth(2000);
        tableView2.setAutoResizeMode(2);
        tableView2.getTableHeader().setReorderingAllowed(false);
        settingsTableFileEditor.table = object;
        this.toolbar = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction(arg_0 -> SettingsTableFileEditor.b(this, arg_0)).setRemoveAction(arg_0 -> SettingsTableFileEditor.G(this, arg_0)).disableUpDownActions().createPanel();
        object = new TableRowSorter<TableModel>((TableModel)this.viewModel);
        ((DefaultRowSorter)object).setComparator(0, stringComparator);
        ((DefaultRowSorter)object).setSortable(1, false);
        ((DefaultRowSorter)object).setSortable(2, false);
        ((DefaultRowSorter)object).setSortable(3, false);
        this.table.setRowSorter((RowSorter)object);
        tableView2 = this.table;
        new TableViewSpeedSearch<SettingModel>(tableView2){

            protected String getItemText(SettingModel element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element.getName();
            }
        };
        this.b();
    }

    public final void refresh() {
        Document document = FileDocumentManager.getInstance().getCachedDocument(this.getFile());
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        if (this.model.reload()) {
            this.b();
        }
    }

    private final void b() {
        this.mainPanel.removeAll();
        String string = this.model.getError();
        if (string != null) {
            BorderLayoutPanel borderLayoutPanel = this.mainPanel.addToCenter((Component)FailedEditorPaneKt.failedEditorPane$default((String)string, (boolean)true, null, arg_0 -> SettingsTableFileEditor.G(this, arg_0), (int)4, null));
            Intrinsics.checkNotNull((Object)borderLayoutPanel);
        } else {
            this.mainPanel.addToCenter((Component)this.toolbar);
            this.dataModel.clear();
            this.dataModel.addAll((Collection<SettingModel>)this.model.createSettingModels());
            this.viewModel.fireTableDataChanged();
        }
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    @NotNull
    public String getName() {
        return RiderDesignersBundle.Companion.message("SettingsTableFileEditor.name.designer", new Object[0]);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.model.getFile();
    }

    public boolean isValid() {
        return this.model.getFile().isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
    }

    @NotNull
    public BorderLayoutPanel getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public TableView<SettingModel> getPreferredFocusedComponent() {
        return this.table;
    }

    public void selectNotify() {
        this.refresh();
    }

    private final void r() {
        SettingModel settingModel = this.model.add();
        this.viewModel.addRow((Object)settingModel);
        this.table.editCellAt(this.viewModel.getRowCount() - 1, 0);
    }

    private final void G() {
        String string;
        List list2 = this.table.getSelectedObjects();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSelectedObjects(...)");
        List list3 = list2;
        if (list3.isEmpty()) {
            return;
        }
        if (((Collection)list3).size() == 1) {
            var3_2 = (Object[])CollectionsKt.single((List)list3);
            if (StringsKt.isBlank((CharSequence)var3_2.getName())) {
                string = RiderDesignersBundle.Companion.message("SettingsTableFileEditor.dialog.message.are.you.sure.you.want.to.delete.unnamed", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{var3_2.getName()};
                string = RiderDesignersBundle.Companion.message("SettingsTableFileEditor.dialog.message.are.you.sure.you.want.to.delete.concrete.setting", objectArray);
            }
        } else {
            var3_2 = new Object[]{((Collection)list3).size()};
            string = RiderDesignersBundle.Companion.message("SettingsTableFileEditor.dialog.message.are.you.sure.you.want.to.delete.many.settings", var3_2);
        }
        String string2 = string;
        int n = Messages.showOkCancelDialog((Project)this.model.getProject(), (String)string2, (String)RiderDesignersBundle.Companion.message("SettingsTableFileEditor.dialog.title.deleting.setting", new Object[0]), (String)RiderBundle.message("button.delete", new Object[0]), (String)RiderBundle.message("button.cancel", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (n != 0) {
            return;
        }
        for (SettingModel settingModel : list3) {
            Intrinsics.checkNotNull((Object)settingModel);
            this.model.remove(settingModel);
            this.viewModel.removeRow(this.viewModel.indexOf((Object)settingModel));
        }
        this.table.stopEditing();
    }

    private static final void b(SettingsTableFileEditor settingsTableFileEditor, AnActionButton anActionButton) {
        settingsTableFileEditor.r();
    }

    private static final void G(SettingsTableFileEditor settingsTableFileEditor, AnActionButton anActionButton) {
        settingsTableFileEditor.G();
    }

    private static final Unit G(SettingsTableFileEditor settingsTableFileEditor) {
        DesignerUtils.INSTANCE.tryOpenTab(settingsTableFileEditor, "text-editor");
        return Unit.INSTANCE;
    }

    private static final Unit G(SettingsTableFileEditor settingsTableFileEditor, FailedEditorBuilder failedEditorBuilder) {
        Intrinsics.checkNotNullParameter((Object)failedEditorBuilder, (String)"$this$failedEditorPane");
        failedEditorBuilder.link(RiderBundle.message("link.label.switch.to.code.editor", new Object[0]), () -> SettingsTableFileEditor.G(settingsTableFileEditor));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\b\u0003*\u0001\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditor$Companion;", "", "SettingsTableFileEditor$Companion", "()V", "stringComparator", "com/jetbrains/rider/designers/settingFiles/SettingsTableFileEditor$Companion$stringComparator$1", "Lcom/jetbrains/rider/designers/settingFiles/SettingsTableFileEditor$Companion$stringComparator$1;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

