/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.settingFiles;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.settingFiles.SettingModel;
import com.jetbrains.rider.designers.settingFiles.SettingsFileModel;
import com.jetbrains.rider.designers.settingFiles.SettingsTableFileEditor;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010$\u001a\u00020%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020(J\u000e\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020(J\u0016\u0010.\u001a\u00020%2\u0006\u0010-\u001a\u00020(2\u0006\u0010/\u001a\u00020\u0019J\n\u00100\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u00101\u001a\u00020\u0013H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsFileModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "SettingsFileModel", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lorg/jdom/Document;", "getDocument", "()Lorg/jdom/Document;", "setDocument", "(Lorg/jdom/Document;)V", "root", "Lorg/jdom/Element;", "getRoot", "()Lorg/jdom/Element;", "setRoot", "(Lorg/jdom/Element;)V", "error", "", "getError", "()Ljava/lang/String;", "setError", "(Ljava/lang/String;)V", "namespace", "Lorg/jdom/Namespace;", "getNamespace", "()Lorg/jdom/Namespace;", "stamp", "", "reload", "", "createSettingModels", "", "Lcom/jetbrains/rider/designers/settingFiles/SettingModel;", "write", "", "add", "remove", "model", "isPossibleName", "name", "b", "G", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSettingsFileModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsFileModel.kt\ncom/jetbrains/rider/designers/settingFiles/SettingsFileModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1557#2:203\n1628#2,3:204\n1557#2:207\n1628#2,3:208\n774#2:211\n865#2,2:212\n1557#2:214\n1628#2,3:215\n*S KotlinDebug\n*F\n+ 1 SettingsFileModel.kt\ncom/jetbrains/rider/designers/settingFiles/SettingsFileModel\n*L\n63#1:203\n63#1:204,3\n98#1:207\n98#1:208,3\n125#1:211\n125#1:212,2\n125#1:214\n125#1:215,3\n*E\n"})
public final class SettingsFileModel {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private org.jdom.Document document;
    @Nullable
    private Element root;
    @Nullable
    private String error;
    private long stamp;

    public SettingsFileModel(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project;
        this.file = file2;
        this.stamp = -1L;
        this.reload();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final org.jdom.Document getDocument() {
        return this.document;
    }

    public final void setDocument(@Nullable org.jdom.Document document) {
        this.document = document;
    }

    @Nullable
    public final Element getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable Element element) {
        this.root = element;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final void setError(@Nullable String string) {
        this.error = string;
    }

    @Nullable
    public final Namespace getNamespace() {
        org.jdom.Document document = this.document;
        return document != null && (document = document.getRootElement()) != null ? document.getNamespace() : null;
    }

    public final boolean reload() {
        if (this.file.getModificationStamp() == this.stamp) {
            return false;
        }
        this.document = null;
        this.root = null;
        this.error = null;
        try {
            Element element;
            org.jdom.Document document = new SAXBuilder().build(DocumentUtilKt.toIOFile((VirtualFile)this.file));
            Intrinsics.checkNotNull((Object)document);
            org.jdom.Document document2 = this.document = document;
            Object object = element = document2 != null ? document2.getRootElement() : null;
            if (element == null) {
                this.error = "'SettingsFile' root element is missing";
            } else if (!StringsKt.equals((String)element.getName(), (String)"SettingsFile", (boolean)true)) {
                this.error = "Root element should be 'SettingsFile' instead of '" + element.getName() + "'";
            } else {
                this.root = element;
            }
        }
        catch (Throwable throwable) {
            this.error = "Invalid settings file: " + throwable.getMessage();
        }
        this.stamp = this.file.getModificationStamp();
        return true;
    }

    @NotNull
    public final List<SettingModel> createSettingModels() {
        Collection collection;
        Object object = this.b();
        if (object != null && (object = object.getChildren("Setting", this.getNamespace())) != null) {
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                Element element = (Element)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)element);
                collection2.add(new SettingModel(this, element));
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)collection;
    }

    public final void write() {
        org.jdom.Document document = this.document;
        if (document == null) {
            return;
        }
        org.jdom.Document document2 = document;
        ApplicationKt.getApplication().runWriteAction(() -> SettingsFileModel.G(this, document2));
    }

    @NotNull
    public final SettingModel add() {
        SettingModel settingModel;
        Object object3;
        Object object2 = this.createSettingModels();
        int n = 0;
        Iterable iterable = object2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        boolean bl = false;
        for (Object object3 : iterable) {
            settingModel = (SettingModel)object3;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(settingModel.getName());
        }
        HashSet hashSet = CollectionsKt.toHashSet((Iterable)((List)collection));
        object2 = null;
        object2 = "Setting";
        n = 1;
        while (hashSet.contains(object2)) {
            object2 = "Setting" + n;
            ++n;
        }
        Collection collection3 = collection = new Element("Setting", this.getNamespace());
        boolean bl3 = false;
        collection3.setAttribute("Name", (String)object2);
        collection3.setAttribute("Type", "System.String");
        collection3.setAttribute("Scope", "User");
        object3 = new Element("Value", collection3.getNamespace());
        settingModel = object3;
        Collection collection4 = collection3;
        boolean bl4 = false;
        settingModel.setAttribute("Profile", "(Default)");
        collection4.addContent((Element)object3);
        iterable = collection;
        this.G().addContent((Element)iterable);
        return new SettingModel(this, (Element)iterable);
    }

    public final void remove(@NotNull SettingModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.getElement().detach();
        this.write();
    }

    public final boolean isPossibleName(@NotNull SettingModel model, @NotNull String name) {
        boolean bl;
        SettingModel settingModel;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable iterable = this.createSettingModels();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            settingModel = (SettingModel)t;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)settingModel.getElement(), (Object)model.getElement()))) continue;
            collection.add(t);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            settingModel = (SettingModel)t;
            Collection collection2 = collection;
            bl = false;
            collection2.add(settingModel.getName());
        }
        return !((List)collection).contains(name);
    }

    private final Element b() {
        Element element;
        Element element2 = this.root;
        if (element2 != null) {
            Element element3 = this.root;
            element = element2.getChild("Settings", (Namespace)(element3 != null ? element3.getNamespace() : null));
        } else {
            element = null;
        }
        return element;
    }

    private final Element G() {
        Element element = this.b();
        if (element != null) {
            return element;
        }
        Element element2 = this.root;
        Intrinsics.checkNotNull((Object)element2);
        Element element3 = new Element("Settings", element2.getNamespace());
        Element element4 = this.root;
        Intrinsics.checkNotNull((Object)element4);
        element4.addContent(element3);
        return element3;
    }

    private static final void G(org.jdom.Document document, Document document2, FileDocumentManager fileDocumentManager, SettingsFileModel settingsFileModel) {
        String string = JDOMUtil.writeDocument((org.jdom.Document)document, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeDocument(...)");
        String string2 = string;
        document2.setText((CharSequence)string2);
        fileDocumentManager.saveDocument(document2);
        UndoManager undoManager = UndoManager.getInstance((Project)settingsFileModel.project);
        Document[] documentArray = new Document[]{document2};
        Document[] documentArray2 = documentArray;
        undoManager.undoableActionPerformed((UndoableAction)new GlobalUndoableAction(settingsFileModel, documentArray2){
            final /* synthetic */ SettingsFileModel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void redo() {
                this.G();
            }

            public void undo() {
                this.G();
            }

            private final void G() {
                ApplicationKt.getApplication().invokeLater(() -> write.1.1.1.G(this.this$0));
            }

            private static final void G(SettingsFileModel settingsFileModel) {
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)settingsFileModel.getProject()).getAllEditors(settingsFileModel.getFile());
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
                Object[] objectArray = fileEditorArray;
                boolean bl = false;
                Object[] objectArray2 = objectArray;
                Collection collection = new ArrayList<E>();
                boolean bl2 = false;
                for (Object object : objectArray2) {
                    if (!(object instanceof SettingsTableFileEditor)) continue;
                    collection.add(object);
                }
                SettingsTableFileEditor settingsTableFileEditor = (SettingsTableFileEditor)((Object)CollectionsKt.singleOrNull((List)((List)collection)));
                if (settingsTableFileEditor != null) {
                    settingsTableFileEditor.refresh();
                }
            }
        });
    }

    private static final void G(SettingsFileModel settingsFileModel, org.jdom.Document document) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document2 = fileDocumentManager2.getDocument(settingsFileModel.file);
        if (document2 == null) {
            return;
        }
        Document document3 = document2;
        Object[] objectArray = new Object[]{settingsFileModel.file.getName()};
        CommandProcessor.getInstance().executeCommand(settingsFileModel.project, () -> SettingsFileModel.G(document, document3, fileDocumentManager2, settingsFileModel), RiderDesignersBundle.Companion.message("SettingsFileModel.command.name.update", objectArray), null);
        settingsFileModel.stamp = settingsFileModel.file.getModificationStamp();
        objectArray = RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel((Solution)SolutionHostExtensionsKt.getSolution((Project)settingsFileModel.project));
        ISignal iSignal = objectArray.getAfterDocumentInEditorSaved();
        String string = settingsFileModel.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        iSignal.fire((Object)string);
    }
}

