/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.resx.grid.selection;

import com.intellij.ui.AncestorListenerAdapter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.designers.resx.grid.selection.SelectionController;
import com.jetbrains.rider.designers.resx.grid.selection.SelectionExpander;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.EqualAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.IgnoreAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.LeadByDiffAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.LeadByIndexAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.RangeAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.ScrollHorizontallyAction;
import com.jetbrains.rider.designers.resx.grid.selection.keyActions.ScrollVerticallyAction;
import com.jetbrains.rider.designers.resx.grid.table.CellIndexes;
import com.jetbrains.rider.designers.resx.grid.table.GeneralRange;
import com.jetbrains.rider.designers.resx.grid.table.Range;
import com.jetbrains.rider.designers.resx.grid.table.ResxCompositeTable;
import com.jetbrains.rider.designers.resx.grid.table.ResxTable;
import com.jetbrains.rider.model.BeDataGrid;
import com.jetbrains.rider.model.BeDataGridRowCellPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010&\u001a\u00020'H\u0002J\u0006\u0010(\u001a\u00020'J\b\u0010)\u001a\u00020'H\u0002J\u0006\u0010*\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/designers/resx/grid/selection/SelectionController;", "", "viewModel", "Lcom/jetbrains/rider/model/BeDataGrid;", "rowHeaderTable", "Lcom/jetbrains/rider/designers/resx/grid/table/ResxTable;", "table", "scroll", "Ljavax/swing/JScrollPane;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "SelectionController", "(Lcom/jetbrains/rider/model/BeDataGrid;Lcom/jetbrains/rider/designers/resx/grid/table/ResxTable;Lcom/jetbrains/rider/designers/resx/grid/table/ResxTable;Ljavax/swing/JScrollPane;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getViewModel", "()Lcom/jetbrains/rider/model/BeDataGrid;", "getRowHeaderTable", "()Lcom/jetbrains/rider/designers/resx/grid/table/ResxTable;", "getTable", "getScroll", "()Ljavax/swing/JScrollPane;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "bkSelectionStarted", "", "frSelectionStarted", "getFrSelectionStarted", "()Z", "setFrSelectionStarted", "(Z)V", "compositeTable", "Lcom/jetbrains/rider/designers/resx/grid/table/ResxCompositeTable;", "getCompositeTable", "()Lcom/jetbrains/rider/designers/resx/grid/table/ResxCompositeTable;", "tableExpander", "Lcom/jetbrains/rider/designers/resx/grid/selection/SelectionExpander;", "rowHeaderExpander", "ancestorLTD", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "G", "", "checkSelection", "b", "stopExpandingIfStarted", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSelectionController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionController.kt\ncom/jetbrains/rider/designers/resx/grid/selection/SelectionController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1557#2:229\n1628#2,3:230\n1557#2:233\n1628#2,3:234\n1557#2:237\n1628#2,3:238\n1557#2:241\n1628#2,3:242\n*S KotlinDebug\n*F\n+ 1 SelectionController.kt\ncom/jetbrains/rider/designers/resx/grid/selection/SelectionController\n*L\n164#1:229\n164#1:230,3\n165#1:233\n165#1:234,3\n167#1:237\n167#1:238,3\n168#1:241\n168#1:242,3\n*E\n"})
public final class SelectionController {
    @NotNull
    private final BeDataGrid viewModel;
    @NotNull
    private final ResxTable rowHeaderTable;
    @NotNull
    private final ResxTable table;
    @NotNull
    private final JScrollPane scroll;
    @NotNull
    private final Lifetime lifetime;
    private boolean bkSelectionStarted;
    private boolean frSelectionStarted;
    @NotNull
    private final ResxCompositeTable compositeTable;
    @NotNull
    private final SelectionExpander tableExpander;
    @NotNull
    private final SelectionExpander rowHeaderExpander;
    @Nullable
    private LifetimeDefinition ancestorLTD;

    public SelectionController(@NotNull BeDataGrid viewModel, @NotNull ResxTable rowHeaderTable, @NotNull ResxTable table2, @NotNull JScrollPane scroll2, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)((Object)rowHeaderTable), (String)"rowHeaderTable");
        Intrinsics.checkNotNullParameter((Object)((Object)table2), (String)"table");
        Intrinsics.checkNotNullParameter((Object)scroll2, (String)"scroll");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.viewModel = viewModel;
        this.rowHeaderTable = rowHeaderTable;
        this.table = table2;
        this.scroll = scroll2;
        this.lifetime = lifetime;
        this.compositeTable = new ResxCompositeTable(this.rowHeaderTable, this.table);
        this.tableExpander = new SelectionExpander(this.table, this.rowHeaderTable, this.compositeTable);
        this.rowHeaderExpander = new SelectionExpander(this.rowHeaderTable, this.table, this.compositeTable);
        this.table.setName("main");
        this.rowHeaderTable.setName("rowHeaderTable");
        this.table.setSelectionMode(1);
        this.table.setCellSelectionEnabled(true);
        this.rowHeaderTable.setSelectionMode(1);
        this.rowHeaderTable.setCellSelectionEnabled(true);
        new EqualAction(this.compositeTable, "clearSelection");
        new LeadByDiffAction(this.compositeTable, "selectPreviousColumn", 0, -1, false);
        new LeadByDiffAction(this.compositeTable, "selectNextColumn", 0, 1, false);
        new LeadByDiffAction(this.compositeTable, "selectPreviousRow", -1, 0, false);
        new LeadByDiffAction(this.compositeTable, "selectNextRow", 1, 0, false);
        new LeadByDiffAction(this.compositeTable, "selectPreviousColumnExtendSelection", 0, -1, true);
        new LeadByDiffAction(this.compositeTable, "selectNextColumnExtendSelection", 0, 1, true);
        new LeadByDiffAction(this.compositeTable, "selectPreviousRowExtendSelection", -1, 0, true);
        new LeadByDiffAction(this.compositeTable, "selectNextRowExtendSelection", 1, 0, true);
        new LeadByIndexAction(this.compositeTable, "selectLastColumn", null, this.compositeTable.getColumnCount(), false);
        new LeadByIndexAction(this.compositeTable, "selectFirstColumn", null, 0, false);
        new LeadByIndexAction(this.compositeTable, "selectLastColumnExtendSelection", null, this.compositeTable.getColumnCount(), true);
        new LeadByIndexAction(this.compositeTable, "selectFirstColumnExtendSelection", null, 0, true);
        new ScrollVerticallyAction(this.compositeTable, "scrollUpChangeSelection", false, false);
        new ScrollVerticallyAction(this.compositeTable, "scrollUpExtendSelection", false, true);
        new ScrollVerticallyAction(this.compositeTable, "scrollDownChangeSelection", true, false);
        new ScrollVerticallyAction(this.compositeTable, "scrollDownExtendSelection", true, true);
        new ScrollHorizontallyAction(this.compositeTable, "scrollLeftChangeSelection", false, false);
        new ScrollHorizontallyAction(this.compositeTable, "scrollLeftExtendSelection", false, true);
        new ScrollHorizontallyAction(this.compositeTable, "scrollRightChangeSelection", true, false);
        new ScrollHorizontallyAction(this.compositeTable, "scrollRightExtendSelection", true, true);
        new IgnoreAction(this.compositeTable, "selectPreviousColumnCell");
        new IgnoreAction(this.compositeTable, "selectNextColumnCell");
        new IgnoreAction(this.compositeTable, "selectNextRowCell");
        new IgnoreAction(this.compositeTable, "selectPreviousRowCell");
        new IgnoreAction(this.compositeTable, "addToSelection");
        new IgnoreAction(this.compositeTable, "toggleAndAnchor");
        new IgnoreAction(this.compositeTable, "extendTo");
        new IgnoreAction(this.compositeTable, "moveSelectionTo");
        new IgnoreAction(this.compositeTable, "focusHeader");
        new RangeAction(this.compositeTable, "selectAll", 0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE, false);
        AncestorListenerAdapter ancestorListenerAdapter = new AncestorListenerAdapter(this){
            final /* synthetic */ SelectionController this$0;
            {
                this.this$0 = $receiver;
            }

            public void ancestorAdded(AncestorEvent event) {
                super.ancestorAdded(event);
                SelectionController.access$addListeners(this.this$0);
            }

            public void ancestorRemoved(AncestorEvent event) {
                SelectionController.access$removeListeners(this.this$0);
                super.ancestorRemoved(event);
            }
        };
        this.lifetime.bracket(() -> SelectionController.b(this, ancestorListenerAdapter), () -> SelectionController.G(this, ancestorListenerAdapter));
    }

    @NotNull
    public final BeDataGrid getViewModel() {
        return this.viewModel;
    }

    @NotNull
    public final ResxTable getRowHeaderTable() {
        return this.rowHeaderTable;
    }

    @NotNull
    public final ResxTable getTable() {
        return this.table;
    }

    @NotNull
    public final JScrollPane getScroll() {
        return this.scroll;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final boolean getFrSelectionStarted() {
        return this.frSelectionStarted;
    }

    public final void setFrSelectionStarted(boolean bl) {
        this.frSelectionStarted = bl;
    }

    @NotNull
    public final ResxCompositeTable getCompositeTable() {
        return this.compositeTable;
    }

    private final void G() {
        this.b();
        LifetimeDefinition lifetimeDefinition = this.lifetime.createNested();
        this.tableExpander.start((Lifetime)lifetimeDefinition);
        this.rowHeaderExpander.start((Lifetime)lifetimeDefinition);
        ListSelectionListener listSelectionListener = arg_0 -> SelectionController.G(this, arg_0);
        lifetimeDefinition.bracket(() -> SelectionController.b(this, listSelectionListener), () -> SelectionController.G(this, listSelectionListener));
        this.ancestorLTD = lifetimeDefinition;
    }

    public final void checkSelection() {
        if (this.frSelectionStarted) {
            return;
        }
        List list2 = (List)this.viewModel.getSelectedCells().getValueOrNull();
        if (list2 != null) {
            List list3 = list2;
            boolean bl = false;
            if (this.compositeTable.getColumnCount() > 0) {
                boolean bl2;
                Collection collection;
                Object object = list3;
                boolean bl3 = false;
                Iterable iterable = object;
                Iterable iterable2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
                boolean bl4 = false;
                for (Object object2 : iterable) {
                    Object object3 = (BeDataGridRowCellPointer)object2;
                    collection = iterable2;
                    boolean bl5 = false;
                    collection.add(object3.getRowIndex());
                }
                Integer n = (Integer)CollectionsKt.minOrNull((Iterable)((List)iterable2));
                Object object4 = list3;
                boolean bl6 = false;
                iterable2 = object4;
                Iterable iterable3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object4, (int)10));
                boolean bl7 = false;
                for (Object object3 : iterable2) {
                    Object object5 = object3;
                    collection = iterable3;
                    boolean bl8 = false;
                    collection.add(object5.getRowIndex());
                }
                object = (Integer)CollectionsKt.maxOrNull((Iterable)((List)iterable3));
                Object object6 = list3;
                boolean bl9 = false;
                iterable3 = object6;
                Iterable iterable4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object6, (int)10));
                boolean bl10 = false;
                for (Object e2 : iterable3) {
                    BeDataGridRowCellPointer beDataGridRowCellPointer = (BeDataGridRowCellPointer)e2;
                    collection = iterable4;
                    boolean bl11 = false;
                    collection.add(beDataGridRowCellPointer.getColumnIndex());
                }
                object4 = (Integer)CollectionsKt.minOrNull((Iterable)((List)iterable4));
                Iterable iterable5 = list3;
                boolean bl12 = false;
                iterable4 = iterable5;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable5, (int)10));
                boolean bl13 = false;
                for (Object e3 : iterable4) {
                    BeDataGridRowCellPointer beDataGridRowCellPointer = (BeDataGridRowCellPointer)e3;
                    collection = collection2;
                    bl2 = false;
                    collection.add(beDataGridRowCellPointer.getColumnIndex());
                }
                object6 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)collection2));
                if (n != null && object != null && object6 != null && object4 != null) {
                    Range range;
                    Range range2;
                    BeDataGridRowCellPointer beDataGridRowCellPointer = (BeDataGridRowCellPointer)InterfacesKt.valueOrDefault((IOptProperty)this.viewModel.getCurrentCell(), (Object)new BeDataGridRowCellPointer(-1, -1));
                    boolean bl14 = false;
                    int n2 = beDataGridRowCellPointer.getRowIndex();
                    if (n == n2) {
                        n2 = beDataGridRowCellPointer.getColumnIndex();
                        if ((Integer)object4 == n2) {
                            range2 = new Range(new CellIndexes((Integer)object, (Integer)object6), new CellIndexes(n, (Integer)object4));
                        } else {
                            n2 = beDataGridRowCellPointer.getColumnIndex();
                            range2 = (Integer)object6 == n2 ? new Range(new CellIndexes((Integer)object, (Integer)object4), new CellIndexes(n, (Integer)object6)) : null;
                        }
                    } else {
                        n2 = beDataGridRowCellPointer.getRowIndex();
                        if ((Integer)object == n2) {
                            n2 = beDataGridRowCellPointer.getColumnIndex();
                            if ((Integer)object4 == n2) {
                                range2 = new Range(new CellIndexes(n, (Integer)object6), new CellIndexes((Integer)object, (Integer)object4));
                            } else {
                                n2 = beDataGridRowCellPointer.getColumnIndex();
                                range2 = (Integer)object6 == n2 ? new Range(new CellIndexes(n, (Integer)object4), new CellIndexes((Integer)object, (Integer)object6)) : null;
                            }
                        } else {
                            range2 = new Range(new CellIndexes(n, (Integer)object6), new CellIndexes((Integer)object, (Integer)object4));
                        }
                    }
                    Range range3 = range = range2;
                    if (range3 != null) {
                        Range range4 = range3;
                        boolean bl15 = false;
                        GeneralRange generalRange = this.compositeTable.createGeneralRange(range4);
                        if (generalRange != null) {
                            GeneralRange generalRange2 = generalRange;
                            bl2 = false;
                            this.bkSelectionStarted = true;
                            ResxCompositeTable.setSelection$default(this.compositeTable, generalRange2, false, 2, null);
                            this.bkSelectionStarted = false;
                            return;
                        }
                    }
                }
            }
        }
        this.compositeTable.clearSelection();
    }

    private final void b() {
        block1: {
            LifetimeDefinition lifetimeDefinition = this.ancestorLTD;
            if (lifetimeDefinition == null) break block1;
            LifetimeDefinition lifetimeDefinition2 = lifetimeDefinition;
            boolean bl = false;
            if (RLifetimeKt.isAlive((Lifetime)((Lifetime)lifetimeDefinition2))) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition2, (boolean)false, (int)1, null);
            }
        }
    }

    public final void stopExpandingIfStarted() {
        this.rowHeaderExpander.stopExpanding();
        this.tableExpander.stopExpanding();
    }

    private static final Unit b(SelectionController selectionController, ancestorListener.1 var1_1) {
        selectionController.scroll.addAncestorListener((AncestorListener)((Object)var1_1));
        return Unit.INSTANCE;
    }

    private static final Unit G(SelectionController selectionController, ancestorListener.1 var1_1) {
        selectionController.scroll.removeAncestorListener((AncestorListener)((Object)var1_1));
        return Unit.INSTANCE;
    }

    private static final void G(SelectionController selectionController, ListSelectionEvent listSelectionEvent) {
        if (selectionController.bkSelectionStarted) {
            return;
        }
        ArrayList<BeDataGridRowCellPointer> arrayList = new ArrayList<BeDataGridRowCellPointer>();
        for (int n : selectionController.table.getSelectedRows()) {
            for (int n2 : selectionController.table.getSelectedColumns()) {
                arrayList.add(new BeDataGridRowCellPointer(n, n2 + 1));
            }
        }
        for (int n : selectionController.rowHeaderTable.getSelectedRows()) {
            for (int n2 : selectionController.rowHeaderTable.getSelectedColumns()) {
                arrayList.add(new BeDataGridRowCellPointer(n, n2));
            }
        }
        selectionController.frSelectionStarted = true;
        selectionController.viewModel.getSelectedCells().set(arrayList);
        if (CollectionsKt.any((Iterable)arrayList)) {
            selectionController.viewModel.getCurrentCell().set(CollectionsKt.first((List)arrayList));
        }
        selectionController.frSelectionStarted = false;
    }

    private static final Unit b(SelectionController selectionController, ListSelectionListener listSelectionListener) {
        selectionController.table.getSelectionModel().addListSelectionListener(listSelectionListener);
        selectionController.rowHeaderTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        return Unit.INSTANCE;
    }

    private static final Unit G(SelectionController selectionController, ListSelectionListener listSelectionListener) {
        selectionController.table.getSelectionModel().removeListSelectionListener(listSelectionListener);
        selectionController.rowHeaderTable.getSelectionModel().removeListSelectionListener(listSelectionListener);
        selectionController.ancestorLTD = null;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$addListeners(SelectionController $this) {
        $this.G();
    }

    public static final /* synthetic */ void access$removeListeners(SelectionController $this) {
        $this.b();
    }
}

