/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.resx.grid.renderers;

import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.ProtocolUIKt;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.resx.grid.renderers.DefaultCellRendererRenderBorder;
import com.jetbrains.rider.designers.resx.grid.table.CustomTableColumn;
import com.jetbrains.rider.designers.resx.grid.table.GeneralRange;
import com.jetbrains.rider.designers.resx.grid.table.ResxCompositeTable;
import com.jetbrains.rider.designers.resx.grid.table.ResxTable;
import com.jetbrains.rider.model.BeDataGridCell;
import com.jetbrains.rider.ui.components.ComponentFactories;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B6\u0012\u001f\u0010\u0002\u001a\u001b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ:\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R*\u0010\u0002\u001a\u001b\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u000b\u0012\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/designers/resx/grid/renderers/ResxRenderer;", "Ljavax/swing/table/TableCellRenderer;", "editingCells", "Lkotlin/Function2;", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "onDoubleClick", "Lkotlin/Function0;", "", "ResxRenderer", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "getEditingCells", "()Lkotlin/jvm/functions/Function2;", "getOnDoubleClick", "()Lkotlin/jvm/functions/Function0;", "coloredComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "label", "Ljavax/swing/JLabel;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "column", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nResxRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResxRenderer.kt\ncom/jetbrains/rider/designers/resx/grid/renderers/ResxRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1863#2,2:138\n*S KotlinDebug\n*F\n+ 1 ResxRenderer.kt\ncom/jetbrains/rider/designers/resx/grid/renderers/ResxRenderer\n*L\n118#1:138,2\n*E\n"})
public final class ResxRenderer
implements TableCellRenderer {
    @NotNull
    private final Function2<Integer, Integer, String> editingCells;
    @NotNull
    private final Function0<Unit> onDoubleClick;
    @NotNull
    private final SimpleColoredComponent coloredComponent;
    @NotNull
    private final JLabel label;

    public ResxRenderer(@NotNull Function2<? super Integer, ? super Integer, String> editingCells, @NotNull Function0<Unit> onDoubleClick) {
        Intrinsics.checkNotNullParameter(editingCells, (String)"editingCells");
        Intrinsics.checkNotNullParameter(onDoubleClick, (String)"onDoubleClick");
        this.editingCells = editingCells;
        this.onDoubleClick = onDoubleClick;
        this.coloredComponent = new SimpleColoredComponent();
        this.label = new JLabel();
    }

    @NotNull
    public final Function2<Integer, Integer, String> getEditingCells() {
        return this.editingCells;
    }

    @NotNull
    public final Function0<Unit> getOnDoubleClick() {
        return this.onDoubleClick;
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean bl;
        int n;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        if (value2 == null || !(value2 instanceof BeDataGridCell) || !(table2 instanceof ResxTable)) {
            Color color = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            this.label.setText(RiderBundle.message("label.loading.lowercase", new Object[0]));
            this.label.setForeground(UIUtil.getLabelDisabledForeground());
            this.label.setBackground(color);
            return this.label;
        }
        ResxCompositeTable resxCompositeTable = ((ResxTable)((Object)table2)).getResxController().getComponent().getSelectionController().getCompositeTable();
        GeneralRange generalRange = resxCompositeTable.getSelection();
        if (generalRange != null) {
            object2 = generalRange;
            boolean bl2 = false;
            object = resxCompositeTable.getTable(((GeneralRange)object2).getLead().getGeneral());
            int n2 = table2.getSelectionModel().getLeadSelectionIndex();
            n = table2.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            bl = Intrinsics.areEqual((Object)table2, (Object)object) && row == n2 && column == n;
        } else {
            bl = false;
        }
        boolean bl3 = bl;
        Color color = JBUI.CurrentTheme.Validator.warningBackgroundColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"warningBackgroundColor(...)");
        Color color2 = color;
        Color color3 = isSelected && !bl3 ? ((ResxTable)((Object)table2)).getSelectionBackground() : (((BeDataGridCell)value2).getHighlight() ? color2 : ((ResxTable)((Object)table2)).getBackground());
        Color color4 = ((ResxTable)((Object)table2)).getForeground();
        object2 = (String)this.editingCells.invoke((Object)row, (Object)column);
        this.coloredComponent.clear();
        this.coloredComponent.setIpad((Insets)JBInsets.create((int)0, (int)-1));
        TableColumn tableColumn = ((ResxTable)((Object)table2)).getColumnModel().getColumn(column);
        Intrinsics.checkNotNull((Object)tableColumn, (String)"null cannot be cast to non-null type com.jetbrains.rider.designers.resx.grid.table.CustomTableColumn");
        CustomTableColumn customTableColumn = (CustomTableColumn)tableColumn;
        if (hasFocus) {
            if (((BeDataGridCell)value2).getHighlight()) {
                Color color5 = JBUI.CurrentTheme.Focus.warningColor((boolean)hasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"warningColor(...)");
                Intrinsics.checkNotNull((Object)color3);
                v5 = new DefaultCellRendererRenderBorder(color5, color3);
            } else {
                v5 = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
        } else {
            DefaultCellRendererRenderBorder defaultCellRendererRenderBorder;
            if (((BeDataGridCell)value2).getHighlight() && bl3) {
                Color color6 = JBUI.CurrentTheme.Focus.warningColor((boolean)hasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"warningColor(...)");
                Intrinsics.checkNotNull((Object)color3);
                defaultCellRendererRenderBorder = new DefaultCellRendererRenderBorder(color6, color3);
            } else {
                Intrinsics.checkNotNull((Object)color3);
                defaultCellRendererRenderBorder = new DefaultCellRendererRenderBorder(color3, color3);
            }
            v5 = object = (Border)defaultCellRendererRenderBorder;
        }
        if (((Boolean)((ResxTable)((Object)table2)).isRowEditing().invoke((Object)row)).booleanValue()) {
            JTextPane jTextPane = ComponentFactories.Companion.htmlMultiLineLabelPane$default((ComponentFactories.Companion)ComponentFactories.Companion, null, (int)1, null);
            StringBuilder stringBuilder = new StringBuilder();
            RichTextModel richTextModel = ((BeDataGridCell)value2).getDisplayValue();
            Intrinsics.checkNotNull((Object)color3);
            ProtocolUIKt.toHtml((RichTextModel)richTextModel, (StringBuilder)stringBuilder, (Color)color3);
            jTextPane.setText(stringBuilder.toString());
            int n3 = customTableColumn.getPreferredWidth();
            jTextPane.setBorder((Border)object);
            jTextPane.setBackground(color3);
            jTextPane.setForeground(color4);
            jTextPane.setSize((Dimension)new JBDimension(n3, 10));
            jTextPane.setSize(n3, jTextPane.getPreferredSize().height);
            int n4 = jTextPane.getPreferredSize().height;
            if (n4 > table2.getRowHeight(row)) {
                ((ResxTable)((Object)table2)).setRowHeight(row, n4);
            }
            if (customTableColumn.getRtl()) {
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setAlignment(simpleAttributeSet, 2);
                jTextPane.setParagraphAttributes(simpleAttributeSet, true);
            }
            return jTextPane;
        }
        if (table2.getRowHeight(row) != ((ResxTable)((Object)table2)).getRowHeight()) {
            ((ResxTable)((Object)table2)).setRowHeight(row, ((ResxTable)((Object)table2)).getRowHeight());
        }
        if (object2 == null) {
            RichTextModel richTextModel = ((BeDataGridCell)value2).getDisplayValue();
            Intrinsics.checkNotNull((Object)color3);
            Iterable iterable = ModelRichTextExKt.toRichText((RichTextModel)richTextModel, (Color)color3).getParts();
            n = 0;
            for (Object t : iterable) {
                RichString richString = (RichString)t;
                boolean bl4 = false;
                this.coloredComponent.append(richString.getText(), richString.getAttributes());
            }
        } else {
            SimpleColoredComponent simpleColoredComponent = this.coloredComponent.append((String)object2);
            Intrinsics.checkNotNull((Object)simpleColoredComponent);
        }
        this.coloredComponent.setTextAlign(customTableColumn.getRtl() ? 4 : 2);
        this.coloredComponent.setBorder((Border)object);
        this.coloredComponent.setBackground(color3);
        this.coloredComponent.setForeground(color4);
        return (Component)this.coloredComponent;
    }
}

