/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.resx.grid.renderers;

import com.intellij.ui.BrowserHyperlinkListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class CustomTextPane
extends JTextPane {
    private boolean lineWrap;

    public CustomTextPane(boolean lineWrap) {
        this.lineWrap = lineWrap;
        if (lineWrap) {
            this.setEditorKit(new WrapEditorKit());
        }
        this.addHyperlinkListener((HyperlinkListener)BrowserHyperlinkListener.INSTANCE);
        this.putClientProperty("JEditorPane.honorDisplayProperties", true);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.lineWrap) {
            return super.getScrollableTracksViewportWidth();
        }
        return this.getParent() == null || this.getUI().getPreferredSize((JComponent)this).width <= this.getParent().getSize().width;
    }

    private static class WrapEditorKit
    extends StyledEditorKit {
        private final ViewFactory defaultFactory = new WrapColumnFactory();

        private WrapEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private static class WrapLabelView
    extends LabelView {
        private WrapLabelView(Element element) {
            super(element);
        }

        @Override
        public float getMinimumSpan(int axis) {
            return switch (axis) {
                case 0 -> 0.0f;
                case 1 -> super.getMinimumSpan(axis);
                default -> throw new IllegalArgumentException("Invalid axis: " + axis);
            };
        }
    }

    private static class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                switch (string) {
                    case "content": {
                        return new WrapLabelView(element);
                    }
                    case "paragraph": {
                        return new ParagraphView(element);
                    }
                    case "section": {
                        return new BoxView(element, 1);
                    }
                    case "component": {
                        return new ComponentView(element);
                    }
                    case "icon": {
                        return new IconView(element);
                    }
                }
            }
            return new LabelView(element);
        }
    }
}

