/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.deploy;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.DeployMessageKind;
import com.jetbrains.rider.model.OutputMessage;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/deploy/DeployResultPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "DeployResultPanel", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "layout", "Ljava/awt/CardLayout;", "container", "Ljavax/swing/JPanel;", "writeMessage", "", "message", "Lcom/jetbrains/rider/model/OutputMessage;", "clear", "intellij.rider"})
public final class DeployResultPanel
extends SimpleToolWindowPanel {
    @NotNull
    private final ConsoleViewImpl console;
    @NotNull
    private final CardLayout layout;
    @NotNull
    private final JPanel container;

    public DeployResultPanel(@NotNull Project project, @NotNull Lifetime lifetime) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super(false);
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        this.console = (ConsoleViewImpl)consoleView;
        this.layout = new CardLayout();
        Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)this.console));
        this.setProvideQuickActions(true);
        JPanel jPanel2 = jPanel = new JPanel(this.layout);
        DeployResultPanel deployResultPanel = this;
        boolean bl = false;
        jPanel2.add((Component)this.console.getComponent(), "console");
        deployResultPanel.container = jPanel;
        this.setContent(this.container);
        lifetime.onTermination(() -> DeployResultPanel.G(this));
    }

    public final void writeMessage(@NotNull OutputMessage message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        String string = message2.getMessage() + "\n";
        ConsoleViewContentType consoleViewContentType = switch (WhenMappings.$EnumSwitchMapping$0[message2.getKind().ordinal()]) {
            case 1 -> ConsoleViewContentType.ERROR_OUTPUT;
            case 2 -> ConsoleViewContentType.LOG_WARNING_OUTPUT;
            case 3 -> ConsoleViewContentType.NORMAL_OUTPUT;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)consoleViewContentType);
        this.console.print(string, consoleViewContentType);
    }

    public final void clear() {
        this.console.clear();
    }

    private static final Unit G(DeployResultPanel deployResultPanel) {
        deployResultPanel.console.dispose();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeployMessageKind.values().length];
            try {
                nArray[DeployMessageKind.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployMessageKind.Warning.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeployMessageKind.Info.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

