/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.wasm.browser;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.debugger.wasm.browser.ChromiumDebuggableBrowser;
import com.jetbrains.rider.debugger.wasm.splash.SplashScreenPageManager;
import com.jetbrains.rider.shared.RiderSharedBundle;
import com.jetbrains.rider.shared.debugger.wasm.ProcessHandlerExtensionsKt;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLine;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import com.jetbrains.rider.shared.utils.registryUtils.impl.RegistryRoot;
import com.sun.jna.platform.win32.WinReg;
import java.io.Closeable;
import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser;", "", "webBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "evaluatedUserDataFolder", "Ljava/io/File;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "ChromiumDebuggableBrowser", "(Lcom/intellij/ide/browsers/WebBrowser;Ljava/io/File;Lcom/intellij/execution/process/ProcessHandler;)V", "getWebBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "getEvaluatedUserDataFolder", "()Ljava/io/File;", "getHandler", "()Lcom/intellij/execution/process/ProcessHandler;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nChromiumDebuggableBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumDebuggableBrowser.kt\ncom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,202:1\n15#2:203\n*S KotlinDebug\n*F\n+ 1 ChromiumDebuggableBrowser.kt\ncom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser\n*L\n39#1:203\n*E\n"})
public final class ChromiumDebuggableBrowser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WebBrowser webBrowser;
    @NotNull
    private final File evaluatedUserDataFolder;
    @NotNull
    private final ProcessHandler handler;
    @NotNull
    private static final Lazy<Logger> logger$delegate = LazyKt.lazy(ChromiumDebuggableBrowser::G);

    private ChromiumDebuggableBrowser(WebBrowser webBrowser, File evaluatedUserDataFolder, ProcessHandler handler2) {
        this.webBrowser = webBrowser;
        this.evaluatedUserDataFolder = evaluatedUserDataFolder;
        this.handler = handler2;
    }

    @NotNull
    public final WebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    @NotNull
    public final File getEvaluatedUserDataFolder() {
        return this.evaluatedUserDataFolder;
    }

    @NotNull
    public final ProcessHandler getHandler() {
        return this.handler;
    }

    private static final Logger G() {
        boolean bl = false;
        Logger logger2 = Logger.getInstance(ChromiumDebuggableBrowser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    public /* synthetic */ ChromiumDebuggableBrowser(WebBrowser webBrowser, File evaluatedUserDataFolder, ProcessHandler handler2, DefaultConstructorMarker $constructor_marker) {
        this(webBrowser, evaluatedUserDataFolder, handler2);
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010\u0015J0\u0010\n\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 2\u0006\u0010\f\u001a\u00020\rH\u0002J1\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u0001H\"0$H\u0002\u00a2\u0006\u0002\u0010&R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser$Companion;", "", "ChromiumDebuggableBrowser$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "G", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "launch", "Lcom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser;", "webBrowser", "Lcom/intellij/ide/browsers/WebBrowser;", "url", "Ljava/net/URI;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/ide/browsers/WebBrowser;Ljava/net/URI;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "Ljava/io/File;", "(Lcom/intellij/ide/browsers/WebBrowser;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/intellij/execution/process/ProcessHandler;", "appUrl", "evaluatedUserDataFolder", "customParameters", "", "G", "", "G", "", "G", "", "G", "T", "block", "Lkotlin/Function1;", "Lcom/intellij/ide/browsers/chrome/ChromeSettings;", "(Lcom/intellij/ide/browsers/WebBrowser;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nChromiumDebuggableBrowser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromiumDebuggableBrowser.kt\ncom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser$Companion\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n52#2:203\n1#3:204\n*S KotlinDebug\n*F\n+ 1 ChromiumDebuggableBrowser.kt\ncom/jetbrains/rider/debugger/wasm/browser/ChromiumDebuggableBrowser$Companion\n*L\n131#1:203\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger G() {
            Lazy lazy = logger$delegate;
            return (Logger)lazy.getValue();
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Nullable
        public final Object launch(@NotNull WebBrowser var1_1, @NotNull URI var2_2, @NotNull Project var3_3, @NotNull Continuation<? super ChromiumDebuggableBrowser> $completion) {
            if (!($completion instanceof launch.1)) ** GOTO lbl-1000
            var9_5 = $completion;
            if ((var9_5.label & -2147483648) != 0) {
                var9_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                var9_5 = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.launch(null, null, null, (Continuation<? super ChromiumDebuggableBrowser>)((Continuation)this));
                    }
                };
            }
            var8_6 = var9_5.result;
            var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch (var9_5.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)var8_6);
                    if (webBrowser.getFamily() != BrowserFamily.CHROME) {
                        throw new CantRunException("Chromium debugging supports only " + BrowserFamily.CHROME + " family");
                    }
                    var6_8 /* !! */  = webBrowser.getSpecificSettings();
                    var5_9 = var6_8 /* !! */  instanceof ChromeSettings != false ? (ChromeSettings)var6_8 /* !! */  : null;
                    var9_5.L$0 = this;
                    var9_5.L$1 = webBrowser;
                    var9_5.L$2 = url;
                    var9_5.L$3 = project;
                    var9_5.L$4 = var5_9;
                    var9_5.label = 1;
                    v0 = this.G(webBrowser, (Continuation<? super File>)var9_5);
                    if (v0 == var10_7) {
                        return var10_7;
                    }
                    ** GOTO lbl34
                }
                case 1: {
                    var5_9 = (ChromeSettings)var9_5.L$4;
                    project = (Project)var9_5.L$3;
                    url = (URI)var9_5.L$2;
                    webBrowser = (WebBrowser)var9_5.L$1;
                    this = (Companion)var9_5.L$0;
                    ResultKt.throwOnFailure((Object)var8_6);
                    v0 = var8_6;
lbl34:
                    // 2 sources

                    var6_8 /* !! */  = (File)v0;
                    v1 /* !! */  = var5_9;
                    if (v1 /* !! */  == null || (v1 /* !! */  = v1 /* !! */ .getCommandLineOptions()) == null) {
                        v1 /* !! */  = "";
                    }
                    var7_10 = this.G(url, (File)var6_8 /* !! */ , (String)v1 /* !! */ , webBrowser, project);
                    return new ChromiumDebuggableBrowser(webBrowser, (File)var6_8 /* !! */ , var7_10, null);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object G(WebBrowser var1_1, Continuation<? super File> var2_2) {
            block7: {
                if (!(var2_2 instanceof obtainUserDataDir.1)) ** GOTO lbl-1000
                var6_3 = var2_2;
                if ((var6_3.label & -2147483648) != 0) {
                    var6_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    var6_3 = new ContinuationImpl(this, var2_2){
                        /* synthetic */ Object result;
                        final /* synthetic */ Companion this$0;
                        int label;
                        {
                            this.this$0 = this$0;
                            super($completion);
                        }

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return com.jetbrains.rider.debugger.wasm.browser.ChromiumDebuggableBrowser$Companion.access$obtainUserDataDir(this.this$0, null, (Continuation)this);
                        }
                    };
                }
                var5_4 = var6_3.result;
                var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (var6_3.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var5_4);
                        var3_6 = DotNetDebuggerSettings.Companion.getInstance().getEnableDefaultCliOptions();
                        if (!var3_6) break;
                        var6_3.label = 1;
                        v0 = RdCoroutinesUtilKt.withIOBackgroundContext$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super File>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return FileUtil.createTempDirectory((String)"blazor_debug_user_data", null, (boolean)true);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super File> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)var6_3, (int)1, null);
                        if (v0 == var7_5) {
                            return var7_5;
                        }
                        ** GOTO lbl23
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)var5_4);
                        v0 = var5_4;
lbl23:
                        // 2 sources

                        var4_7 = v0;
                        Intrinsics.checkNotNull((Object)var4_7);
                        v1 = (File)var4_7;
                        break block7;
                    }
                }
                v1 = (Boolean)this.G(var1_1, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, G(com.intellij.ide.browsers.chrome.ChromeSettings ), (Lcom/intellij/ide/browsers/chrome/ChromeSettings;)Ljava/lang/Boolean;)()) != false ? new File(ChromeSettingsConfigurable.getDefaultUserDataPath()) : (File)this.G(var1_1, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, G(com.intellij.ide.browsers.chrome.ChromeSettings ), (Lcom/intellij/ide/browsers/chrome/ChromeSettings;)Ljava/io/File;)());
            }
            return v1;
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private final ProcessHandler G(URI uRI, File file2, String string, WebBrowser webBrowser, Project project) {
            GeneralCommandLine generalCommandLine;
            this.G().info("Evaluated browser info:");
            this.G().info("\tName: " + webBrowser.getName());
            this.G().info("\tFamily: " + webBrowser.getFamily().getName());
            this.G().info("\tPath: " + webBrowser.getPath());
            this.G().info("\tUser data folder: " + file2);
            this.G().info("Starting browser...");
            this.G(file2);
            String string2 = SplashScreenPageManager.Companion.getInstance(project).createSplashScreenUrl(uRI);
            this.G().warn("Generated page placeholder for '" + uRI + "': '" + string2 + "'");
            List<String> list2 = this.G(webBrowser);
            Object object = new String[]{string2};
            GeneralCommandLine generalCommandLine2 = new FormatPreservingCommandLine().withExePath((String)CollectionsKt.first(list2)).withParameters(CollectionsKt.drop((Iterable)list2, (int)1)).withParameters((String[])object);
            object = new String[]{"--args"};
            GeneralCommandLine generalCommandLine3 = generalCommandLine2.withParameters((String[])object);
            object = new String[]{"--remote-debugging-port=0"};
            GeneralCommandLine generalCommandLine4 = generalCommandLine3.withParameters((String[])object);
            object = new String[]{"--user-data-dir=" + file2.getAbsolutePath()};
            GeneralCommandLine generalCommandLine5 = generalCommandLine4.withParameters((String[])object);
            object = new String[]{"--no-first-run"};
            GeneralCommandLine generalCommandLine6 = generalCommandLine5.withParameters((String[])object);
            object = new String[]{"--disable-fre"};
            GeneralCommandLine generalCommandLine7 = generalCommandLine6.withParameters((String[])object);
            object = new String[]{"--no-default-browser-check"};
            GeneralCommandLine generalCommandLine8 = generalCommandLine7.withParameters((String[])object);
            object = new String[]{"--disable-background-networking"};
            GeneralCommandLine generalCommandLine9 = generalCommandLine8.withParameters((String[])object);
            object = new String[]{"--disable-background-timer-throttling"};
            GeneralCommandLine generalCommandLine10 = generalCommandLine9.withParameters((String[])object);
            object = new String[]{"--disable-backgrounding-occluded-windows"};
            GeneralCommandLine generalCommandLine11 = generalCommandLine10.withParameters((String[])object);
            object = new String[]{"--disable-breakpad"};
            GeneralCommandLine generalCommandLine12 = generalCommandLine11.withParameters((String[])object);
            object = new String[]{"--disable-client-side-phishing-detection"};
            GeneralCommandLine generalCommandLine13 = generalCommandLine12.withParameters((String[])object);
            object = new String[]{"--disable-default-apps"};
            GeneralCommandLine generalCommandLine14 = generalCommandLine13.withParameters((String[])object);
            object = new String[]{"--disable-dev-shm-usage"};
            GeneralCommandLine generalCommandLine15 = generalCommandLine14.withParameters((String[])object);
            object = new String[]{"--disable-renderer-backgrounding"};
            GeneralCommandLine generalCommandLine16 = generalCommandLine15.withParameters((String[])object);
            object = new String[]{"--disable-sync"};
            GeneralCommandLine generalCommandLine17 = generalCommandLine16.withParameters((String[])object);
            object = new String[]{"--metrics-recording-only"};
            object = generalCommandLine17.withParameters((String[])object);
            boolean bl = !StringsKt.isBlank((CharSequence)string);
            boolean bl2 = false;
            if (bl) {
                GeneralCommandLine generalCommandLine18 = object;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)generalCommandLine18);
                generalCommandLine = FormatPreservingCommandLineKt.withRawParameters((GeneralCommandLine)generalCommandLine18, (String)((Object)StringsKt.trim((CharSequence)string)).toString());
            } else {
                generalCommandLine = object;
            }
            Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"applyIf(...)");
            GeneralCommandLine generalCommandLine19 = generalCommandLine;
            this.G().info("Executing launch browser command: " + generalCommandLine19.getCommandLineString());
            KillableProcessHandler killableProcessHandler = new KillableProcessHandler(generalCommandLine19){

                protected BaseOutputReader.Options readerOptions() {
                    return BaseOutputReader.Options.forMostlySilentProcess();
                }
            };
            object = killableProcessHandler;
            bl = false;
            ProcessHandlerExtensionsKt.withOutputMonitoring((OSProcessHandler)((OSProcessHandler)object), (String)"Chromium Browser");
            object.startNotify();
            return (ProcessHandler)killableProcessHandler;
        }

        private final void G(File file2) {
            if (!this.G(file2)) {
                File file3 = FilesKt.resolve((File)file2, (String)"DevToolsActivePort");
                this.G().info("No lock file at user data folder, deleting port file located at '" + file3 + "'");
                file3.delete();
            }
        }

        private final boolean G(File file2) {
            boolean bl;
            if (SystemInfo.isWindows) {
                bl = FilesKt.resolve((File)file2, (String)"lockfile").exists();
            } else if (SystemInfo.isUnix) {
                Object[] objectArray = file2.list(Companion::G);
                bl = objectArray != null ? ArraysKt.any((Object[])objectArray) : false;
            } else {
                this.G().warn("trying to check chrome lockfile on unsupported platform: " + SystemInfo.OS_NAME + ", " + SystemInfo.OS_VERSION + ", " + SystemInfo.OS_ARCH);
                return false;
            }
            return bl;
        }

        private final List<String> G(WebBrowser webBrowser) {
            String string = webBrowser.getPath();
            List list2 = BrowserUtil.getOpenBrowserCommand((String)PathUtil.toSystemDependentName((String)string), null, (List)CollectionsKt.emptyList(), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOpenBrowserCommand(...)");
            List list3 = CollectionsKt.toMutableList((Collection)list2);
            if (Intrinsics.areEqual((Object)CollectionsKt.first((List)list3), (Object)CommandLineUtil.getWinShellName())) {
                try {
                    WinReg.HKEY hKEY = WinReg.HKEY_LOCAL_MACHINE;
                    Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"HKEY_LOCAL_MACHINE");
                    String string2 = new RegistryRoot(hKEY, Lifetime.Companion.getEternal()).fromKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + string + ".exe").getStringValue("Path");
                    Intrinsics.checkNotNull((Object)string2);
                    String string3 = string2;
                    File file2 = new File(string3);
                    File file3 = new File(file2, string + ".exe");
                    list3 = CollectionsKt.toMutableList((Collection)CollectionsKt.listOf((Object)file3.getAbsolutePath()));
                }
                catch (Exception exception) {
                    this.G().info("Cannot find registry key", (Throwable)exception);
                }
            }
            return list3;
        }

        private final <T> T G(WebBrowser webBrowser, Function1<? super ChromeSettings, ? extends T> function1) {
            Object object;
            block3: {
                block2: {
                    ChromeSettingsConfigurable chromeSettingsConfigurable;
                    object = webBrowser.getSpecificSettings();
                    if (object == null) break block2;
                    BrowserSpecificSettings browserSpecificSettings = object;
                    boolean bl = false;
                    BrowserSpecificSettings browserSpecificSettings2 = browserSpecificSettings = (ChromeSettings)browserSpecificSettings;
                    boolean bl2 = false;
                    ChromeSettingsConfigurable chromeSettingsConfigurable2 = chromeSettingsConfigurable = browserSpecificSettings2.createConfigurable();
                    boolean bl3 = false;
                    chromeSettingsConfigurable2.reset();
                    chromeSettingsConfigurable2.apply();
                    browserSpecificSettings2 = browserSpecificSettings;
                    object = function1.invoke((Object)browserSpecificSettings2);
                    if (object != null) break block3;
                }
                throw new CantRunException(RiderSharedBundle.Companion.message("dialog.message.no.chrome.settings", new Object[0]));
            }
            return (T)object;
        }

        private static final Boolean G(ChromeSettings chromeSettings) {
            Intrinsics.checkNotNullParameter((Object)chromeSettings, (String)"it");
            return !chromeSettings.isUseCustomProfile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final File G(ChromeSettings chromeSettings) {
            File file2;
            Intrinsics.checkNotNullParameter((Object)chromeSettings, (String)"settings");
            String string = chromeSettings.getUserDataDirectoryPath();
            if (string != null) {
                File file3;
                String string2 = string;
                boolean bl = false;
                File file4 = file3 = new File(string2);
                boolean bl2 = false;
                boolean bl3 = file4.exists();
                Path path = file4.getCanonicalFile().toPath();
                if (bl3) {
                    Closeable closeable = Files.newDirectoryStream(path);
                    Throwable throwable = null;
                    try {
                        DirectoryStream directoryStream = (DirectoryStream)closeable;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)directoryStream);
                        if (CollectionsKt.any((Iterable)directoryStream)) {
                            Companion.G().warn(RiderSharedBundle.Companion.message("blazor.wasm.debug.notification.userdatadir.not.empty", new Object[0]));
                        }
                        directoryStream = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                } else if (!file4.mkdirs()) {
                    Object[] objectArray = new Object[]{path.toAbsolutePath()};
                    String string3 = RiderSharedBundle.Companion.message("blazor.wasm.debug.exception.create.userdatadir", objectArray);
                    throw new CantRunException(string3);
                }
                file2 = file3;
            } else {
                file2 = null;
            }
            return file2;
        }

        private static final boolean G(File file2, String string) {
            String string2 = string;
            return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"SingletonLock", (boolean)false, (int)2, null) : false;
        }

        public static final /* synthetic */ Object access$obtainUserDataDir(Companion $this, WebBrowser webBrowser, Continuation $completion) {
            return $this.G(webBrowser, (Continuation<? super File>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

