/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.threading.coroutines.ISourceCoroutineUtilKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.DebuggerHelperHost;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import com.jetbrains.rider.debugger.util.CopyFileEntry;
import com.jetbrains.rider.debugger.util.JITDebuggerUpdates;
import com.jetbrains.rider.debugger.util.JITDebuggerUtils;
import com.jetbrains.rider.debugger.util.JITDebuggerUtilsKt;
import com.jetbrains.rider.debugger.util.RegistryWriteEntry;
import com.jetbrains.rider.model.debuggerHelper.DebuggerHelperHostModel;
import com.jetbrains.rider.model.debuggerHelper.GetFileVersionInfoResult;
import com.jetbrains.rider.run.configurations.exe.ExeConfiguration;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationParameters;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002JL\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0005H\u0082@\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010'J\u0006\u0010(\u001a\u00020\u0016J\u0015\u0010.\u001a\u00020/*\u0002002\u0006\u00101\u001a\u000200H\u0082\u0002J\f\u00102\u001a\u00020\u0005*\u000200H\u0002J\f\u00103\u001a\u00020\u0014*\u000200H\u0002J\u0016\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u000206H\u0086@\u00a2\u0006\u0002\u00107J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u00107J\u001e\u00109\u001a\u00020\u00192\u0006\u00105\u001a\u0002062\u0006\u0010:\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\u00020\u00192\u0006\u00105\u001a\u0002062\u0006\u0010:\u001a\u00020\u0016J\u0016\u0010=\u001a\u00020\u00162\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010)\u001a\u0004\u0018\u00010\u001c8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+\u00a8\u0006?"}, d2={"Lcom/jetbrains/rider/debugger/util/JITDebuggerUtils;", "", "JITDebuggerUtils", "()V", "PATH_32", "", "PATH_64", "JIT_DEBUGGER_EXECUTABLE_NAME", "JIT_DEBUGGER_EXECUTABLE_NAME_64", "JIT_DEBUGGER_EXECUTABLE_NAME_32", "JIT_DEBUGGER_NOTIFICATION_GROUP_KEY", "DEFAULT_VS_JIT_DEBUGGER_PATH", "G", "key", "value", "readCurrent32JITDebugger", "readCurrent64JITDebugger", "readFallback32JITDebugger", "readFallback64JITDebugger", "G", "Lcom/jetbrains/rider/debugger/modulesView/AssemblyVersion;", "G", "", "debuggerCmd", "G", "", "filesToCopy", "", "Ljava/io/File;", "new32Cmd", "new64Cmd", "old32Cmd", "old64Cmd", "jitDirectory", "version", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "restoreJITDebuggers", "fallbackDebugger32", "fallbackDebugger64", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isRiderJITDebuggerSet", "jitDebuggerFolder", "getJitDebuggerFolder", "()Ljava/io/File;", "jitDebuggerFolder$delegate", "Lkotlin/Lazy;", "G", "", "Lcom/jetbrains/rider/model/debuggerHelper/GetFileVersionInfoResult;", "other", "G", "G", "isJitDebuggerOutdated", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "G", "updateJITDebuggerAssemblies", "installNew", "(Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launchJitDebuggerAssembliesCopy", "hasTargetRunConfiguration", "targetPath", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nJITDebuggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JITDebuggerUtils.kt\ncom/jetbrains/rider/debugger/util/JITDebuggerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,355:1\n1557#2:356\n1628#2,3:357\n1611#2,9:360\n1863#2:369\n1864#2:371\n1620#2:372\n230#2,2:373\n1755#2,3:375\n1#3:370\n1#3:378\n*S KotlinDebug\n*F\n+ 1 JITDebuggerUtils.kt\ncom/jetbrains/rider/debugger/util/JITDebuggerUtils\n*L\n125#1:356\n125#1:357,3\n275#1:360,9\n275#1:369\n275#1:371\n275#1:372\n307#1:373,2\n350#1:375,3\n275#1:370\n*E\n"})
public final class JITDebuggerUtils {
    @NotNull
    public static final JITDebuggerUtils INSTANCE = new JITDebuggerUtils();
    @NotNull
    private static final String PATH_32 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\Windows NT\\CurrentVersion\\AeDebug";
    @NotNull
    private static final String PATH_64 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\AeDebug";
    @NotNull
    public static final String JIT_DEBUGGER_EXECUTABLE_NAME = "RiderJITDebuggerLauncher";
    @NotNull
    public static final String JIT_DEBUGGER_EXECUTABLE_NAME_64 = "RiderJITDebuggerLauncher64.exe";
    @NotNull
    public static final String JIT_DEBUGGER_EXECUTABLE_NAME_32 = "RiderJITDebuggerLauncher32.exe";
    @NotNull
    public static final String JIT_DEBUGGER_NOTIFICATION_GROUP_KEY = "JITDebuggerUpdaterHost";
    @NotNull
    private static final String DEFAULT_VS_JIT_DEBUGGER_PATH = "\"C:\\WINDOWS\\system32\\vsjitdebugger.exe\" -p %ld -e %ld";
    @NotNull
    private static final Lazy jitDebuggerFolder$delegate = LazyKt.lazy(JITDebuggerUtils::G);

    private JITDebuggerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String G(String string, String string2) {
        Process process2;
        String string3 = "reg query \"" + string + "\" /v " + string2;
        BufferedReader bufferedReader = null;
        Process process3 = null;
        String string4 = null;
        try {
            process3 = Runtime.getRuntime().exec(string3);
            bufferedReader = new BufferedReader(new InputStreamReader(process3.getInputStream()));
            string4 = TextStreamsKt.readText((Reader)bufferedReader);
            bufferedReader.close();
            process2 = process3;
        }
        catch (IOException iOException) {
            String string5 = null;
            return string5;
        }
        finally {
            BufferedReader bufferedReader2 = bufferedReader;
            if (bufferedReader2 != null) {
                bufferedReader2.close();
            }
            Process process4 = process3;
            if (process4 != null) {
                process4.waitFor(1L, TimeUnit.SECONDS);
            }
        }
        if (process2 != null) {
            process2.waitFor(1L, TimeUnit.SECONDS);
        }
        if (string4 != null) {
            String string6;
            Object object = new String[]{"\r\n"};
            List list2 = StringsKt.split$default((CharSequence)string4, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (list2.size() < 3) {
                return null;
            }
            object = (String)list2.get(2);
            int n = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (String)"REG_SZ    ", (int)0, (boolean)false, (int)6, null);
            int n2 = StringsKt.indexOf$default((CharSequence)((CharSequence)object), (String)"REG_SZ\t", (int)0, (boolean)false, (int)6, null);
            if (n == -1 && n2 == -1) {
                return null;
            }
            if (n != -1 && (n < n2 || n2 == -1)) {
                String string7 = ((String)object).substring(n + 10);
                string6 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
            } else {
                String string8 = ((String)object).substring(n2 + 7);
                string6 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
            }
            return string6;
        }
        return null;
    }

    @Nullable
    public final String readCurrent32JITDebugger() {
        return this.G(PATH_32, "Debugger");
    }

    @Nullable
    public final String readCurrent64JITDebugger() {
        return this.G(PATH_64, "Debugger");
    }

    @Nullable
    public final String readFallback32JITDebugger() {
        String string = this.G(PATH_32, "FallbackDebugger");
        if (this.G(string)) {
            JITDebuggerUtilsKt.access$getLogger$p().warn("Fallback 32 JIT Debugger is corrupted: " + string + ", using default VS debugger: \"C:\\WINDOWS\\system32\\vsjitdebugger.exe\" -p %ld -e %ld");
            return DEFAULT_VS_JIT_DEBUGGER_PATH;
        }
        return string;
    }

    @Nullable
    public final String readFallback64JITDebugger() {
        String string = this.G(PATH_64, "FallbackDebugger");
        if (this.G(string)) {
            JITDebuggerUtilsKt.access$getLogger$p().warn("Fallback 64 JIT Debugger is corrupted: " + string + ", using default VS debugger: \"C:\\WINDOWS\\system32\\vsjitdebugger.exe\" -p %ld -e %ld");
            return DEFAULT_VS_JIT_DEBUGGER_PATH;
        }
        return string;
    }

    private final AssemblyVersion G() {
        String string = this.G(PATH_64, "Version");
        if (string == null) {
            return null;
        }
        String string2 = string;
        return AssemblyVersion.Companion.parse(string2);
    }

    private final boolean G(String string) {
        String string2 = string;
        return string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)JIT_DEBUGGER_EXECUTABLE_NAME, (boolean)false, (int)2, null) : false;
    }

    private final Object G(List<? extends File> list2, String string, String string2, String string3, String string4, File file2, String string5, Continuation<? super Unit> continuation) {
        Object[] objectArray = (Object[])list2;
        JITDebuggerUpdates jITDebuggerUpdates = JITDebuggerUpdates.INSTANCE;
        boolean bl = false;
        Object[] objectArray2 = objectArray;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)objectArray, (int)10));
        boolean bl2 = false;
        for (Object t : objectArray2) {
            File file3 = (File)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(new CopyFileEntry(file3, new File(file2, file3.getName())));
        }
        objectArray = new RegistryWriteEntry[]{new RegistryWriteEntry(PATH_32, "Debugger", string), new RegistryWriteEntry(PATH_64, "Debugger", string2), new RegistryWriteEntry(PATH_32, "FallbackDebugger", string3), new RegistryWriteEntry(PATH_64, "FallbackDebugger", string4), new RegistryWriteEntry(PATH_64, "Version", string5)};
        Object object = jITDebuggerUpdates.prepareAndExecuteScript$intellij_rider((List)collection, CollectionsKt.listOf((Object[])objectArray), CollectionsKt.listOf((Object)file2), continuation);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object restoreJITDebuggers(@NotNull String fallbackDebugger32, @NotNull String fallbackDebugger64, @NotNull Continuation<? super Unit> $completion) {
        Object[] objectArray = new RegistryWriteEntry[]{new RegistryWriteEntry(PATH_32, "Debugger", fallbackDebugger32), new RegistryWriteEntry(PATH_64, "Debugger", fallbackDebugger64), new RegistryWriteEntry(PATH_64, "Version", ""), new RegistryWriteEntry(PATH_32, "FallbackDebugger", ""), new RegistryWriteEntry(PATH_64, "FallbackDebugger", "")};
        Object object = JITDebuggerUpdates.INSTANCE.prepareAndExecuteScript$intellij_rider(CollectionsKt.emptyList(), CollectionsKt.listOf((Object[])objectArray), CollectionsKt.emptyList(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isRiderJITDebuggerSet() {
        String string;
        String string2;
        String string3 = this.readCurrent32JITDebugger();
        if (string3 == null) {
            string3 = string2 = "";
        }
        if ((string = this.readCurrent64JITDebugger()) == null) {
            string = "";
        }
        String string4 = string;
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)JIT_DEBUGGER_EXECUTABLE_NAME, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)string4, (CharSequence)JIT_DEBUGGER_EXECUTABLE_NAME, (boolean)false, (int)2, null);
    }

    @Nullable
    public final File getJitDebuggerFolder() {
        Lazy lazy = jitDebuggerFolder$delegate;
        return (File)lazy.getValue();
    }

    private final int G(GetFileVersionInfoResult getFileVersionInfoResult, GetFileVersionInfoResult getFileVersionInfoResult2) {
        Intrinsics.checkNotNullParameter((Object)getFileVersionInfoResult, (String)"<this>");
        if (getFileVersionInfoResult.getProductMajor() != getFileVersionInfoResult2.getProductMajor()) {
            return Intrinsics.compare((int)getFileVersionInfoResult.getProductMajor(), (int)getFileVersionInfoResult2.getProductMajor());
        }
        if (getFileVersionInfoResult.getProductMinor() != getFileVersionInfoResult2.getProductMinor()) {
            return Intrinsics.compare((int)getFileVersionInfoResult.getProductMinor(), (int)getFileVersionInfoResult2.getProductMinor());
        }
        if (getFileVersionInfoResult.getProductBuild() != getFileVersionInfoResult2.getProductBuild()) {
            return Intrinsics.compare((int)getFileVersionInfoResult.getProductBuild(), (int)getFileVersionInfoResult2.getProductBuild());
        }
        return Intrinsics.compare((int)getFileVersionInfoResult.getProductPrivate(), (int)getFileVersionInfoResult2.getProductPrivate());
    }

    private final String G(GetFileVersionInfoResult getFileVersionInfoResult) {
        return getFileVersionInfoResult.getProductMajor() + "." + getFileVersionInfoResult.getProductMinor() + "." + getFileVersionInfoResult.getProductBuild() + "." + getFileVersionInfoResult.getProductPrivate();
    }

    private final AssemblyVersion G(GetFileVersionInfoResult getFileVersionInfoResult) {
        return new AssemblyVersion(getFileVersionInfoResult.getProductMajor(), getFileVersionInfoResult.getProductMinor(), getFileVersionInfoResult.getProductBuild(), getFileVersionInfoResult.getProductPrivate());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object isJitDebuggerOutdated(@NotNull Project var1_1, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isJitDebuggerOutdated.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var12_3 = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ JITDebuggerUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.isJitDebuggerOutdated(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        var11_4 = var12_3.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var12_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var11_4);
                var3_6 = "RiderJITDebuggerLauncher64.exe";
                var4_7 = this.getJitDebuggerFolder();
                if (var4_7 == null) {
                    JITDebuggerUtilsKt.access$getLogger$p().warn("Jit debugger folder is null");
                    return Boxing.boxBoolean((boolean)false);
                }
                if (!var4_7.exists()) {
                    JITDebuggerUtilsKt.access$getLogger$p().warn("Jit debugger folder is null");
                    return Boxing.boxBoolean((boolean)true);
                }
                var5_8 = this.G();
                if (var5_8 == null) {
                    JITDebuggerUtilsKt.access$getLogger$p().warn("JIT Debugger version in registry is missing");
                    return Boxing.boxBoolean((boolean)true);
                }
                try {
                    var7_9 /* !! */  = RiderEnvironment.getBundledFile$default((RiderEnvironment)RiderEnvironment.INSTANCE, (String)var3_6, (boolean)false, null, (boolean)false, (int)14, null);
                }
                catch (IOException var8_10) {
                    JITDebuggerUtilsKt.access$getLogger$p().warn("JIT Debugger was not found in output bin dir", (Throwable)var8_10);
                    return Boxing.boxBoolean((boolean)false);
                }
                var6_12 = var7_9 /* !! */ ;
                var7_9 /* !! */  = DebuggerHelperHost.Companion.getInstance((Project)project).getModel();
                var8_11 = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project));
                var12_3.L$0 = this;
                var12_3.L$1 = var5_8;
                var12_3.L$2 = var6_12;
                var12_3.L$3 = var7_9 /* !! */ ;
                var12_3.L$4 = var8_11;
                var12_3.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Boolean>, Object>(var7_9 /* !! */ , null){
                    int label;
                    final /* synthetic */ DebuggerHelperHostModel $debuggerHelperHostModel;
                    {
                        this.$debuggerHelperHostModel = $debuggerHelperHostModel;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = ISourceCoroutineUtilKt.nextTrueValue((ISource)((ISource)this.$debuggerHelperHostModel.isReady()), (Continuation)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)var12_3);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl52
            }
            case 1: {
                var8_11 = (Lifetime)var12_3.L$4;
                var7_9 /* !! */  = (DebuggerHelperHostModel)var12_3.L$3;
                var6_12 = (File)var12_3.L$2;
                var5_8 = (AssemblyVersion)var12_3.L$1;
                this = (JITDebuggerUtils)var12_3.L$0;
                ResultKt.throwOnFailure((Object)var11_4);
                v0 = var11_4;
lbl52:
                // 2 sources

                v1 = (IRdCall)var7_9 /* !! */ .getGetFileVersionInfo();
                var10_13 = var6_12.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)var10_13, (String)"getAbsolutePath(...)");
                var12_3.L$0 = this;
                var12_3.L$1 = var5_8;
                var12_3.L$2 = null;
                var12_3.L$3 = null;
                var12_3.L$4 = null;
                var12_3.label = 2;
                v2 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)v1, (Lifetime)var8_11, (Object)var10_13, null, (Continuation)var12_3, (int)4, null);
                if (v2 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl70
            }
            case 2: {
                var5_8 = (AssemblyVersion)var12_3.L$1;
                this = (JITDebuggerUtils)var12_3.L$0;
                ResultKt.throwOnFailure((Object)var11_4);
                v2 = var11_4;
lbl70:
                // 2 sources

                var9_14 = (GetFileVersionInfoResult)v2;
                JITDebuggerUtilsKt.access$getLogger$p().info("Local file version: " + this.G(var9_14));
                JITDebuggerUtilsKt.access$getLogger$p().info("System file version: " + var5_8);
                return Boxing.boxBoolean((boolean)(var5_8.compareTo(this.G(var9_14)) < 0));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object G(Project var1_1, Continuation<? super List<? extends File>> var2_2) {
        if (!(var2_2 instanceof prepareJitDebuggerAssemblies.1)) ** GOTO lbl-1000
        var21_3 = var2_2;
        if ((var21_3.label & -2147483648) != 0) {
            var21_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var21_3 = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ JITDebuggerUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JITDebuggerUtils.access$prepareJitDebuggerAssemblies(this.this$0, null, (Continuation)this);
                }
            };
        }
        var20_4 = var21_3.result;
        var22_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var21_3.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var20_4);
                var21_3.label = 1;
                v0 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)DebuggerHelperHost.Companion.getInstance(var1_1).getModel().getGetJITDebuggerAssemblies()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)var1_1)), (Object)Unit.INSTANCE, null, (Continuation)var21_3, (int)4, null);
                if (v0 == var22_5) {
                    return var22_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)var20_4);
                v0 = var20_4;
lbl20:
                // 2 sources

                var3_6 = CollectionsKt.toMutableList((Collection)((Collection)v0));
                var3_6.add("RiderJITDebuggerLauncher32.exe");
                var3_6.add("RiderJITDebuggerLauncher64.exe");
                var4_7 = var3_6;
                var5_8 = false;
                var6_9 = var4_7;
                var7_10 = new ArrayList<E>();
                var8_11 = false;
                var9_12 = var6_9;
                var10_13 = false;
                var11_14 = var9_12.iterator();
                while (var11_14.hasNext()) {
                    var13_16 = var12_15 = var11_14.next();
                    var14_17 = false;
                    var15_18 = (String)var13_16;
                    var16_19 = false;
                    JITDebuggerUtilsKt.access$getLogger$p().info("Preparing file " + var15_18 + " for JIT Debugger...");
                    v1 = RiderEnvironment.getBundledFileOrNull$default((RiderEnvironment)RiderEnvironment.INSTANCE, (String)var15_18, (boolean)false, null, (int)6, null);
                    if (v1 == null && (v1 = RiderEnvironment.getBundledFileOrNull$default((RiderEnvironment)RiderEnvironment.INSTANCE, (String)(var15_18 + ".dll"), (boolean)false, null, (int)6, null)) == null) {
                        v1 = RiderEnvironment.getBundledFileOrNull$default((RiderEnvironment)RiderEnvironment.INSTANCE, (String)(var15_18 + ".exe"), (boolean)false, null, (int)6, null);
                    }
                    if ((var17_20 = v1) == null) {
                        JITDebuggerUtilsKt.access$getLogger$p().warn("Unable to find file " + var15_18);
                        v2 = null;
                    } else {
                        v2 = var17_20;
                    }
                    if (v2 == null) continue;
                    var18_21 = v2;
                    var19_22 = false;
                    var7_10.add(var18_21);
                }
                return (List)var7_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object updateJITDebuggerAssemblies(@NotNull Project var1_1, boolean var2_2, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateJITDebuggerAssemblies.1)) ** GOTO lbl-1000
        var17_4 = $completion;
        if ((var17_4.label & -2147483648) != 0) {
            var17_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            var17_4 = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ JITDebuggerUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateJITDebuggerAssemblies(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        var16_5 = var17_4.result;
        var18_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch (var17_4.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)var16_5);
                var4_7 = this.getJitDebuggerFolder();
                if (var4_7 != null) break;
                var17_4.L$0 = project;
                var17_4.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Notification>, Object>(null){
                    int label;

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return NotificationGroupManager.getInstance().getNotificationGroup("JITDebuggerUpdaterHost").createNotification("", RiderDebuggerBundle.Companion.message("DotNetDebuggerGeneralConfigurableUi.label.jit.debugger.cant.get.localappdata.folder.path", new Object[0]), NotificationType.INFORMATION);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Notification> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)var17_4);
                if (v0 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl24
            }
            case 1: {
                project = (Project)var17_4.L$0;
                ResultKt.throwOnFailure((Object)var16_5);
                v0 = var16_5;
lbl24:
                // 2 sources

                ((Notification)v0).notify(project);
                return Unit.INSTANCE;
            }
        }
        var5_8 = FilesKt.resolve((File)var4_7, (String)"RiderJITDebuggerLauncher32.exe");
        var6_9 = FilesKt.resolve((File)var4_7, (String)"RiderJITDebuggerLauncher64.exe");
        var17_4.L$0 = this;
        var17_4.L$1 = project;
        var17_4.L$2 = var4_7;
        var17_4.L$3 = var5_8;
        var17_4.L$4 = var6_9;
        var17_4.Z$0 = installNew;
        var17_4.label = 2;
        v1 = this.G(project, (Continuation<? super List<? extends File>>)var17_4);
        if (v1 == var18_6) {
            return var18_6;
        }
        ** GOTO lbl48
        {
            case 2: {
                installNew = var17_4.Z$0;
                var6_9 = (File)var17_4.L$4;
                var5_8 = (File)var17_4.L$3;
                var4_7 = (File)var17_4.L$2;
                project = (Project)var17_4.L$1;
                this = (JITDebuggerUtils)var17_4.L$0;
                ResultKt.throwOnFailure((Object)var16_5);
                v1 = var16_5;
lbl48:
                // 2 sources

                var7_10 = (List)v1;
                var9_11 = var7_10;
                var10_12 = false;
                var11_14 = var9_11.iterator();
                while (var11_14.hasNext()) {
                    var12_15 /* !! */  = var11_14.next();
                    var13_16 = (File)var12_15 /* !! */ ;
                    var14_17 = false;
                    if (!Intrinsics.areEqual((Object)var13_16.getName(), (Object)"RiderJITDebuggerLauncher64.exe")) continue;
                    ** GOTO lbl59
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl59:
                // 1 sources

                var8_18 = (File)var12_15 /* !! */ ;
                var15_19 = this;
                v2 = (IRdCall)DebuggerHelperHost.Companion.getInstance(project).getModel().getGetFileVersionInfo();
                v3 = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project));
                var10_13 = var8_18.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)var10_13, (String)"getAbsolutePath(...)");
                var17_4.L$0 = this;
                var17_4.L$1 = var4_7;
                var17_4.L$2 = var5_8;
                var17_4.L$3 = var6_9;
                var17_4.L$4 = var7_10;
                var17_4.L$5 = var15_19;
                var17_4.Z$0 = installNew;
                var17_4.label = 3;
                v4 = IRdCall.DefaultImpls.startSuspending$default((IRdCall)v2, (Lifetime)v3, (Object)var10_13, null, (Continuation)var17_4, (int)4, null);
                if (v4 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl87
            }
            case 3: {
                installNew = var17_4.Z$0;
                var15_19 = (JITDebuggerUtils)var17_4.L$5;
                var7_10 = (List)var17_4.L$4;
                var6_9 = (File)var17_4.L$3;
                var5_8 = (File)var17_4.L$2;
                var4_7 = (File)var17_4.L$1;
                this = (JITDebuggerUtils)var17_4.L$0;
                ResultKt.throwOnFailure((Object)var16_5);
                v4 = var16_5;
lbl87:
                // 2 sources

                var9_11 = var15_19.G((GetFileVersionInfoResult)v4);
                var10_13 = "\"" + var5_8 + "\" -p %ld -e %ld -s %p";
                var11_14 = "\"" + var6_9 + "\" -p %ld -e %ld -s %p";
                var13_16 = null;
                if (installNew) {
                    v5 /* !! */  = this.readCurrent32JITDebugger();
                    if (v5 /* !! */  == null) {
                        v5 /* !! */  = var12_15 /* !! */  = "";
                    }
                    if ((v6 = this.readCurrent64JITDebugger()) == null) {
                        v6 = "";
                    }
                    var13_16 = v6;
                } else {
                    v7 /* !! */  = this.readFallback32JITDebugger();
                    if (v7 /* !! */  == null) {
                        v7 /* !! */  = var12_15 /* !! */  = "";
                    }
                    if ((v8 = this.readFallback64JITDebugger()) == null) {
                        v8 = "";
                    }
                    var13_16 = v8;
                }
                var17_4.L$0 = null;
                var17_4.L$1 = null;
                var17_4.L$2 = null;
                var17_4.L$3 = null;
                var17_4.L$4 = null;
                var17_4.L$5 = null;
                var17_4.label = 4;
                v9 = this.G(var7_10, (String)var10_13, (String)var11_14, (String)var12_15 /* !! */ , (String)var13_16, var4_7, (String)var9_11, (Continuation<? super Unit>)var17_4);
                if (v9 == var18_6) {
                    return var18_6;
                }
                ** GOTO lbl120
            }
            case 4: {
                ResultKt.throwOnFailure((Object)var16_5);
                v9 = var16_5;
lbl120:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void launchJitDebuggerAssembliesCopy(@NotNull Project project, boolean installNew) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LifetimeCoroutineUtilKt.launch$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)), (CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, installNew, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $installNew;
            {
                this.$project = $project;
                this.$installNew = $installNew;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = JITDebuggerUtils.INSTANCE.updateJITDebuggerAssemblies(this.$project, this.$installNew, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Notification>, Object>(null){
                            int label;

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        return NotificationGroupManager.getInstance().getNotificationGroup("JITDebuggerUpdaterHost").createNotification("", RiderDebuggerBundle.Companion.message("JITDebuggerUpdater.notification.content.successfully.updated", new Object[0]), NotificationType.INFORMATION);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Notification> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        ((Notification)v1).notify(this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final boolean hasTargetRunConfiguration(@NotNull Project project, @NotNull String targetPath) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Iterable iterable = RunManager.Companion.getInstance(project).getConfigurationsList((ConfigurationType)new ExeConfigurationType());
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    boolean bl3;
                    RunConfiguration runConfiguration = (RunConfiguration)t;
                    boolean bl4 = false;
                    Object object = runConfiguration instanceof ExeConfiguration ? (ExeConfiguration)runConfiguration : null;
                    if (object == null || (object = ((ExeConfiguration)object).getParameters()) == null || (object = ((ExeConfigurationParameters)((Object)object)).getExePath()) == null) {
                        bl3 = false;
                    } else {
                        Object object2 = object;
                        bl3 = FileUtil.filesEqual((File)new File((String)object2), (File)new File(targetPath));
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final <T> T G(Function0<? extends T> function0) {
        Object object;
        try {
            object = function0.invoke();
        }
        catch (SecurityException securityException) {
            object = null;
        }
        return (T)object;
    }

    private static final String G() {
        return System.getenv("ProgramFiles");
    }

    private static final File G() {
        String string = (String)JITDebuggerUtils.G(JITDebuggerUtils::G);
        if (string == null) {
            return null;
        }
        String string2 = string;
        boolean bl = false;
        File file2 = new File(string2);
        return FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)file2, (String)"JetBrains"), (String)"Rider"), (String)"JITDebugger");
    }

    public static final /* synthetic */ Object access$updateJITDebuggers(JITDebuggerUtils $this, List filesToCopy, String new32Cmd, String new64Cmd, String old32Cmd, String old64Cmd, File jitDirectory, String version, Continuation $completion) {
        return $this.G(filesToCopy, new32Cmd, new64Cmd, old32Cmd, old64Cmd, jitDirectory, version, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$prepareJitDebuggerAssemblies(JITDebuggerUtils $this, Project project, Continuation $completion) {
        return $this.G(project, (Continuation<? super List<? extends File>>)$completion);
    }
}

