/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.rider.debugger.breakpoint.DotNetBreakpointProperties;
import com.jetbrains.rider.debugger.util.RdCallResultHolder;
import com.jetbrains.rider.model.debuggerWorker.BreakpointHitCountModeModel;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import com.jetbrains.rider.model.debuggerWorker.StackFrameOriginModel;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b*\u0006\u0012\u0002\b\u00030\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\f\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a$\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00160\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000e\u001aF\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001d\"\n\b\u0001\u0010\u001c*\u0004\u0018\u00010\u001d*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001f0\u001e2\u0006\u0010\u0010\u001a\u00020\u0011\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0003\u00a8\u0006 "}, d2={"isExternalCode", "", "Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "(Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;)Z", "isDecompiledCode", "isUserCode", "isNonUserCode", "toHitCountModeModel", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointHitCountModeModel;", "Lcom/jetbrains/rider/debugger/breakpoint/DotNetBreakpointProperties;", "toModel", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "Lcom/intellij/xdebugger/XSourcePosition;", "checkFileMatchesDebugInfo", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "path", "", "fillPromise", "", "T", "Lcom/jetbrains/rd/framework/RdTaskResult;", "asyncPromise", "getCachedCall", "Lcom/jetbrains/rider/debugger/util/RdCallResultHolder;", "TReq", "TRes", "", "Lkotlin/reflect/KProperty;", "Lcom/jetbrains/rd/framework/IRdCall;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDebuggerWorkerModelUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerWorkerModelUtil.kt\ncom/jetbrains/rider/debugger/util/DebuggerWorkerModelUtilKt\n+ 2 RdBindableBase.kt\ncom/jetbrains/rd/framework/base/RdBindableBase\n+ 3 TaskInterfaces.kt\ncom/jetbrains/rd/framework/RdTaskResult\n*L\n1#1,105:1\n118#2:106\n63#3,4:107\n*S KotlinDebug\n*F\n+ 1 DebuggerWorkerModelUtil.kt\ncom/jetbrains/rider/debugger/util/DebuggerWorkerModelUtilKt\n*L\n75#1:106\n57#1:107,4\n*E\n"})
public final class DebuggerWorkerModelUtilKt {
    public static final boolean isExternalCode(@NotNull StackFrameProxy $this$isExternalCode) {
        Intrinsics.checkNotNullParameter((Object)$this$isExternalCode, (String)"<this>");
        return $this$isExternalCode.getFrameOrigin() == StackFrameOriginModel.External;
    }

    public static final boolean isDecompiledCode(@NotNull StackFrameProxy $this$isDecompiledCode) {
        Intrinsics.checkNotNullParameter((Object)$this$isDecompiledCode, (String)"<this>");
        return $this$isDecompiledCode.getFrameOrigin() == StackFrameOriginModel.Decompiled;
    }

    public static final boolean isUserCode(@NotNull StackFrameProxy $this$isUserCode) {
        Intrinsics.checkNotNullParameter((Object)$this$isUserCode, (String)"<this>");
        return $this$isUserCode.getFrameOrigin() == StackFrameOriginModel.UserCode;
    }

    public static final boolean isNonUserCode(@NotNull StackFrameProxy $this$isNonUserCode) {
        Intrinsics.checkNotNullParameter((Object)$this$isNonUserCode, (String)"<this>");
        return !DebuggerWorkerModelUtilKt.isUserCode($this$isNonUserCode);
    }

    @NotNull
    public static final BreakpointHitCountModeModel toHitCountModeModel(@NotNull DotNetBreakpointProperties<?> $this$toHitCountModeModel) {
        Intrinsics.checkNotNullParameter($this$toHitCountModeModel, (String)"<this>");
        if (!$this$toHitCountModeModel.getHitCountFilterEnabled()) {
            return BreakpointHitCountModeModel.None;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toHitCountModeModel.getHitCountMode().ordinal()]) {
            case 1 -> BreakpointHitCountModeModel.LessThan;
            case 2 -> BreakpointHitCountModeModel.LessThanOrEqualTo;
            case 3 -> BreakpointHitCountModeModel.EqualTo;
            case 4 -> BreakpointHitCountModeModel.GreaterThan;
            case 5 -> BreakpointHitCountModeModel.GreaterThanOrEqualTo;
            case 6 -> BreakpointHitCountModeModel.MultipleOf;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final SourcePositionProxy toModel(@NotNull XSourcePosition $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        Document document = FileDocumentManager.getInstance().getDocument($this$toModel.getFile());
        if (document == null) {
            int n = $this$toModel.getLine();
            String string = $this$toModel.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return new SourcePositionProxy(0, n, 0, "", string, $this$toModel.getLine(), 0);
        }
        Document document2 = document;
        int n = Math.max($this$toModel.getOffset() - document2.getLineStartOffset($this$toModel.getLine()), 0);
        int n2 = $this$toModel.getLine();
        String string = $this$toModel.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new SourcePositionProxy(n, n2, n, "", string, $this$toModel.getLine(), 0);
    }

    @NotNull
    public static final AsyncPromise<Boolean> checkFileMatchesDebugInfo(@NotNull ExecutionContextProxy $this$checkFileMatchesDebugInfo, @NotNull Lifetime lifetime, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$checkFileMatchesDebugInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        AsyncPromise asyncPromise = new AsyncPromise();
        ClientId clientId = ClientId.Companion.getCurrentOrNull();
        DebuggerWorkerModelUtilKt.getCachedCall((KProperty)new PropertyReference0Impl($this$checkFileMatchesDebugInfo){

            public Object get() {
                return ((ExecutionContextProxy)this.receiver).isDebugInfoMatchesSources();
            }
        }, lifetime).call(path, arg_0 -> DebuggerWorkerModelUtilKt.G(clientId, asyncPromise, arg_0));
        return asyncPromise;
    }

    public static final <T> void fillPromise(@NotNull RdTaskResult<? extends T> $this$fillPromise, @NotNull AsyncPromise<T> asyncPromise) {
        Intrinsics.checkNotNullParameter($this$fillPromise, (String)"<this>");
        Intrinsics.checkNotNullParameter(asyncPromise, (String)"asyncPromise");
        RdTaskResult<? extends T> rdTaskResult = $this$fillPromise;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            asyncPromise.setResult(((RdTaskResult.Success)$this$fillPromise).getValue());
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            asyncPromise.setError((Throwable)new CancellationException());
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            asyncPromise.setError(((RdTaskResult.Fault)$this$fillPromise).getError().getReasonMessage());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public static final <TReq, TRes> RdCallResultHolder<TReq, TRes> getCachedCall(@NotNull KProperty<? extends IRdCall<? super TReq, ? extends TRes>> $this$getCachedCall, @NotNull Lifetime lifetime) {
        RdBindableBase rdBindableBase;
        Intrinsics.checkNotNullParameter($this$getCachedCall, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        PropertyReference propertyReference = $this$getCachedCall instanceof PropertyReference ? (PropertyReference)$this$getCachedCall : null;
        Object object = propertyReference != null ? propertyReference.getBoundReceiver() : null;
        RdBindableBase rdBindableBase2 = object instanceof RdBindableBase ? (RdBindableBase)object : null;
        if (rdBindableBase2 == null) {
            throw new IllegalArgumentException("Given property " + $this$getCachedCall + " must be a reference with RdBindableBase receiver");
        }
        RdBindableBase rdBindableBase3 = rdBindableBase = rdBindableBase2;
        object = Reflection.getOrCreateKotlinClass(RdCallResultHolder.class).getSimpleName() + "#" + ((PropertyReference)$this$getCachedCall).getName();
        Function0 function0 = () -> DebuggerWorkerModelUtilKt.G($this$getCachedCall, lifetime, rdBindableBase);
        boolean bl = false;
        return (RdCallResultHolder)rdBindableBase3.getOrCreateExtension((String)object, Reflection.getOrCreateKotlinClass(RdCallResultHolder.class), function0);
    }

    private static final Unit G(RdTaskResult rdTaskResult, AsyncPromise asyncPromise) {
        RdTaskResult rdTaskResult2;
        RdTaskResult rdTaskResult3 = rdTaskResult;
        boolean bl = false;
        RdTaskResult rdTaskResult4 = rdTaskResult3;
        if (rdTaskResult4 instanceof RdTaskResult.Success) {
            Boolean bl2 = (Boolean)((RdTaskResult.Success)rdTaskResult3).getValue();
            boolean bl3 = false;
            Boolean bl4 = bl2;
            Boolean bl5 = bl4 != null ? bl4 : true;
            rdTaskResult2 = (RdTaskResult)new RdTaskResult.Success((Object)bl5);
        } else if (rdTaskResult4 instanceof RdTaskResult.Cancelled) {
            rdTaskResult2 = (RdTaskResult)new RdTaskResult.Cancelled();
        } else if (rdTaskResult4 instanceof RdTaskResult.Fault) {
            rdTaskResult2 = (RdTaskResult)new RdTaskResult.Fault((Throwable)((RdTaskResult.Fault)rdTaskResult3).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DebuggerWorkerModelUtilKt.fillPromise(rdTaskResult2, asyncPromise);
        return Unit.INSTANCE;
    }

    private static final Unit G(ClientId clientId, AsyncPromise asyncPromise, RdTaskResult rdTaskResult) {
        Intrinsics.checkNotNullParameter((Object)rdTaskResult, (String)"res");
        ClientId.Companion.withClientId(clientId, () -> DebuggerWorkerModelUtilKt.G(rdTaskResult, asyncPromise));
        return Unit.INSTANCE;
    }

    private static final RdCallResultHolder G(KProperty kProperty, Lifetime lifetime, RdBindableBase rdBindableBase) {
        return new RdCallResultHolder((IRdCall)kProperty.getGetter().call(new Object[0]), lifetime, InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)rdBindableBase)));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BreakpointHitCountMode.values().length];
            try {
                nArray[BreakpointHitCountMode.LessThan.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointHitCountMode.LessThanOrEqualTo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointHitCountMode.EqualTo.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointHitCountMode.GreaterThan.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointHitCountMode.GreaterThanOrEqualTo.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BreakpointHitCountMode.MultipleOf.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

