/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetExecutionStack;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.util.DotNetDebugProcessUtilKt;
import com.jetbrains.rider.model.DebugPausedContextInfoProxy;
import com.jetbrains.rider.model.MethodRangeProxy;
import com.jetbrains.rider.model.SourcePosition;
import com.jetbrains.rider.model.debuggerWorker.TextRangeProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a'\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"createDebugPausedContextInfo", "Lcom/jetbrains/rider/model/DebugPausedContextInfoProxy;", "dotNetDebugProcess", "Lcom/jetbrains/rider/debugger/DotNetDebugProcess;", "G", "Lcom/jetbrains/rider/model/MethodRangeProxy;", "Lcom/jetbrains/rider/model/debuggerWorker/TextRangeProxy;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "G", "", "line", "column", "document", "Lcom/intellij/openapi/editor/Document;", "(IILcom/intellij/openapi/editor/Document;)Ljava/lang/Integer;", "intellij.rider"})
public final class ContextActionsUtilKt {
    @Nullable
    public static final DebugPausedContextInfoProxy createDebugPausedContextInfo(@NotNull DotNetDebugProcess dotNetDebugProcess) {
        MethodRangeProxy methodRangeProxy;
        DotNetExecutionStack dotNetExecutionStack;
        SourcePosition sourcePosition;
        XSourcePosition xSourcePosition;
        Intrinsics.checkNotNullParameter((Object)((Object)dotNetDebugProcess), (String)"dotNetDebugProcess");
        XDebugSession xDebugSession = dotNetDebugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession xDebugSession2 = xDebugSession;
        if (DotnetDebuggerExtKt.getDotnetSuspendContext(xDebugSession2) == null) {
            return null;
        }
        boolean bl = DotNetDebugProcessUtilKt.canFetchHeapValues(dotNetDebugProcess);
        boolean bl2 = DotNetDebugProcessUtilKt.canSetNextStatement(dotNetDebugProcess);
        XDebugSessionImpl xDebugSessionImpl = xDebugSession2 instanceof XDebugSessionImpl ? (XDebugSessionImpl)xDebugSession2 : null;
        Object object = xDebugSessionImpl != null ? xDebugSessionImpl.getCurrentExecutionStack() : null;
        XExecutionStack xExecutionStack = object;
        XSourcePosition xSourcePosition2 = xExecutionStack != null && (xExecutionStack = xExecutionStack.getTopFrame()) != null ? xExecutionStack.getSourcePosition() : (xSourcePosition = null);
        if (xSourcePosition != null) {
            String string = xSourcePosition.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            v5 = new SourcePosition(string, xSourcePosition.getOffset());
        } else {
            v5 = sourcePosition = null;
        }
        if ((dotNetExecutionStack = object instanceof DotNetExecutionStack ? (DotNetExecutionStack)((Object)object) : null) != null && (dotNetExecutionStack = dotNetExecutionStack.getTopFrameMethodRange()) != null) {
            XSourcePosition xSourcePosition3 = xSourcePosition;
            methodRangeProxy = ContextActionsUtilKt.G((TextRangeProxy)dotNetExecutionStack, (VirtualFile)(xSourcePosition3 != null ? xSourcePosition3.getFile() : null));
        } else {
            methodRangeProxy = null;
        }
        return new DebugPausedContextInfoProxy(bl, bl2, sourcePosition, methodRangeProxy);
    }

    private static final MethodRangeProxy G(TextRangeProxy textRangeProxy, VirtualFile virtualFile) {
        if (textRangeProxy == null) {
            return null;
        }
        if (virtualFile == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Integer n = ContextActionsUtilKt.G(textRangeProxy.getStartLine(), textRangeProxy.getStartColumn(), document2);
        if (n == null) {
            return null;
        }
        int n2 = n;
        Integer n3 = ContextActionsUtilKt.G(textRangeProxy.getEndLine(), textRangeProxy.getEndColumn(), document2);
        int n4 = n3 != null ? n3 : n2;
        return new MethodRangeProxy(n2, n4);
    }

    private static final Integer G(int n, int n2, Document document) {
        if (n - 1 >= document.getLineCount()) {
            return null;
        }
        int n3 = document.getLineStartOffset(n - 1) + n2 - 1;
        if (n3 > document.getTextLength()) {
            n3 = document.getTextLength() - 1;
        }
        return n3;
    }
}

