/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.tasksView.shared.graph;

import com.jetbrains.rider.debugger.DotNetStackFrame;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.compact.CompactedNode;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.compact.GraphCompact;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.merge.GraphMerger;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.ParallelTasksGraph;
import com.jetbrains.rider.debugger.tasksView.shared.graph.frames.plain.TasksGraphBuilder;
import com.jetbrains.rider.model.debuggerWorker.RdTasksViewNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TasksInfo;", "", "graph", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/ParallelTasksGraph;", "TasksInfo", "(Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/ParallelTasksGraph;)V", "getGraph", "()Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/plain/ParallelTasksGraph;", "compactedFramesGraph", "", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/frames/compact/CompactedNode;", "getCompactedFramesGraph", "()Ljava/util/Set;", "compactedFramesGraph$delegate", "Lkotlin/Lazy;", "isEmpty", "", "Companion", "intellij.rider"})
public final class TasksInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParallelTasksGraph graph;
    @NotNull
    private final Lazy compactedFramesGraph$delegate;

    public TasksInfo(@NotNull ParallelTasksGraph graph) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.graph = graph;
        this.compactedFramesGraph$delegate = LazyKt.lazy(() -> TasksInfo.G(this));
    }

    @NotNull
    public final ParallelTasksGraph getGraph() {
        return this.graph;
    }

    @NotNull
    public final Set<CompactedNode> getCompactedFramesGraph() {
        Lazy lazy = this.compactedFramesGraph$delegate;
        return (Set)lazy.getValue();
    }

    public final boolean isEmpty() {
        return this.graph.getNodes().isEmpty();
    }

    private static final Set G(TasksInfo tasksInfo) {
        return GraphCompact.Companion.compact(GraphMerger.Companion.merge(tasksInfo.graph.extractFrames()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TasksInfo$Companion;", "", "TasksInfo$Companion", "()V", "create", "Lcom/jetbrains/rider/debugger/tasksView/shared/graph/TasksInfo;", "rdNodes", "", "Lcom/jetbrains/rider/model/debuggerWorker/RdTasksViewNode;", "frontendIdToFrameMap", "", "", "Lcom/jetbrains/rider/debugger/DotNetStackFrame;", "createEmpty", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TasksInfo create(@NotNull List<? extends RdTasksViewNode> rdNodes, @NotNull Map<Integer, DotNetStackFrame> frontendIdToFrameMap) {
            Intrinsics.checkNotNullParameter(rdNodes, (String)"rdNodes");
            Intrinsics.checkNotNullParameter(frontendIdToFrameMap, (String)"frontendIdToFrameMap");
            ParallelTasksGraph parallelTasksGraph = TasksGraphBuilder.INSTANCE.build(rdNodes, frontendIdToFrameMap);
            return new TasksInfo(parallelTasksGraph);
        }

        @NotNull
        public final TasksInfo createEmpty() {
            return new TasksInfo(ParallelTasksGraph.Companion.empty());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

