/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.targets;

import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.PathInfo;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.targets.BundledAssemblyLauncherKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/debugger/targets/BundledAssemblyLauncher;", "", "assemblyName", "", "suffix32bit", "BundledAssemblyLauncher", "(Ljava/lang/String;Ljava/lang/String;)V", "getAssemblyName", "()Ljava/lang/String;", "getLauncher", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "binDirectory", "Lcom/jetbrains/rider/PathInfo;", "cpuKind", "Lcom/jetbrains/rider/CPUKind;", "intellij.rider"})
public final class BundledAssemblyLauncher {
    @NotNull
    private final String assemblyName;
    @NotNull
    private final String suffix32bit;

    public BundledAssemblyLauncher(@NotNull String assemblyName, @NotNull String suffix32bit) {
        Intrinsics.checkNotNullParameter((Object)assemblyName, (String)"assemblyName");
        Intrinsics.checkNotNullParameter((Object)suffix32bit, (String)"suffix32bit");
        this.assemblyName = assemblyName;
        this.suffix32bit = suffix32bit;
    }

    public /* synthetic */ BundledAssemblyLauncher(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "32";
        }
        this(string, string2);
    }

    @NotNull
    public final String getAssemblyName() {
        return this.assemblyName;
    }

    @NotNull
    public final BundledAssemblyLauncherInfo getLauncher(@NotNull PathInfo binDirectory) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        return switch (WhenMappings.$EnumSwitchMapping$0[binDirectory.getCpuKind().ordinal()]) {
            case 1 -> new BundledAssemblyLauncherInfo(this.assemblyName + this.suffix32bit + ".exe", BundledAssemblyLauncherKt.access$getDefaultCustomInfo(binDirectory, false, true));
            case 2, 3 -> new BundledAssemblyLauncherInfo(binDirectory.getCpuKind().getDirectoryName() + binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator + this.assemblyName + ".exe", BundledAssemblyLauncherKt.access$getDefaultCustomInfo(binDirectory, true, true));
            case 4, 5, 6, 7 -> new BundledAssemblyLauncherInfo(binDirectory.getCpuKind().getDirectoryName() + binDirectory.getCpuKind().getOsKind().getPlatform().fileSeparator + this.assemblyName, BundledAssemblyLauncherKt.access$getDefaultCustomInfo(binDirectory, true, true));
            case 8, 9, 10, 11, 12 -> new BundledAssemblyLauncherInfo(this.assemblyName + ".exe", BundledAssemblyLauncherKt.access$getDefaultCustomInfo(binDirectory, true, false));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ BundledAssemblyLauncherInfo getLauncher$default(BundledAssemblyLauncher bundledAssemblyLauncher, PathInfo pathInfo, int n, Object object) {
        if ((n & 1) != 0) {
            String string = RiderEnvironment.INSTANCE.getBundledBinDir().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            pathInfo = new PathInfo(string, CPUKind.Companion.getRIDER_CPU_KIND());
        }
        return bundledAssemblyLauncher.getLauncher(pathInfo);
    }

    @NotNull
    public final BundledAssemblyLauncherInfo getLauncher(@NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)cpuKind, (String)"cpuKind");
        String string = RiderEnvironment.INSTANCE.getBundledBinDir().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return this.getLauncher(new PathInfo(string, cpuKind));
    }

    @NotNull
    public final BundledAssemblyLauncherInfo getLauncher(@NotNull PathInfo binDirectory, @NotNull CPUKind cpuKind) {
        Intrinsics.checkNotNullParameter((Object)binDirectory, (String)"binDirectory");
        Intrinsics.checkNotNullParameter((Object)cpuKind, (String)"cpuKind");
        return this.getLauncher(new PathInfo(binDirectory.getPath(), cpuKind));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CPUKind.values().length];
            try {
                nArray[CPUKind.Win32.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Win64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.WinArm64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux64.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOs64.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.MacOsArm.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.Linux32.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxArm32.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm32.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMuslArm64.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CPUKind.LinuxMusl64.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

