/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.debugger.editAndContinue.HotReloadApplyResultKind;
import com.jetbrains.rider.debugger.statistics.HotReloadPopupAction;
import com.jetbrains.rider.debugger.statistics.HotReloadResultKind;
import com.jetbrains.rider.debugger.statistics.HotReloadUsageKind;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/debugger/statistics/RiderHotReloadStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "RiderHotReloadStatisticsCollector", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "GROUP", "RESULT_KIND", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/jetbrains/rider/debugger/statistics/HotReloadResultKind;", "USAGE_KIND", "Lcom/jetbrains/rider/debugger/statistics/HotReloadUsageKind;", "POPUP_ACTION", "Lcom/jetbrains/rider/debugger/statistics/HotReloadPopupAction;", "APPLY_CHANGES_ATTEMPT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "HOT_RELOAD_POPUP_IS_SHOWN", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "HOT_RELOAD_POPUP_ACTION_IS_ACTIVATED", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "applyChangesAttempt", "", "resultKind", "Lcom/jetbrains/rider/debugger/editAndContinue/HotReloadApplyResultKind;", "usageKind", "project", "Lcom/intellij/openapi/project/Project;", "popupIsShown", "popupActionIsActivated", "action", "intellij.rider"})
public final class RiderHotReloadStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RiderHotReloadStatisticsCollector INSTANCE = new RiderHotReloadStatisticsCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rider.hotreload", 2, null, 4, null);
    @NotNull
    private static final EnumEventField<HotReloadResultKind> RESULT_KIND = EventFields.Enum$default((String)"result_kind", HotReloadResultKind.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<HotReloadUsageKind> USAGE_KIND = EventFields.Enum$default((String)"usage_type", HotReloadUsageKind.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<HotReloadPopupAction> POPUP_ACTION = EventFields.Enum$default((String)"action", HotReloadPopupAction.class, null, (int)4, null);
    @NotNull
    private static final EventId2<HotReloadResultKind, HotReloadUsageKind> APPLY_CHANGES_ATTEMPT = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"apply.changes.attempted", (EventField)((EventField)RESULT_KIND), (EventField)((EventField)USAGE_KIND), null, (int)8, null);
    @NotNull
    private static final EventId HOT_RELOAD_POPUP_IS_SHOWN = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"popup.is.shown", null, (int)2, null);
    @NotNull
    private static final EventId1<HotReloadPopupAction> HOT_RELOAD_POPUP_ACTION_IS_ACTIVATED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"popup.action.is.activated", (EventField)((EventField)POPUP_ACTION), null, (int)4, null);

    private RiderHotReloadStatisticsCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void applyChangesAttempt(@NotNull HotReloadApplyResultKind resultKind, @NotNull HotReloadUsageKind usageKind, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)resultKind), (String)"resultKind");
        Intrinsics.checkNotNullParameter((Object)((Object)usageKind), (String)"usageKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        APPLY_CHANGES_ATTEMPT.log(project, (Object)RiderDebuggerStatisticsUtilKt.toStatisticsKind(resultKind), (Object)usageKind);
    }

    public final void popupIsShown(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HOT_RELOAD_POPUP_IS_SHOWN.log(project);
    }

    public final void popupActionIsActivated(@NotNull HotReloadPopupAction action2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        HOT_RELOAD_POPUP_ACTION_IS_ACTIVATED.log(project, (Object)action2);
    }
}

