/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.statistics;

import com.intellij.execution.configurations.RunProfileState;
import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.DotNetDebugProcess;
import com.jetbrains.rider.debugger.DotNetDebugSessionInfo;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.statistics.DFAState;
import com.jetbrains.rider.debugger.statistics.OSType;
import com.jetbrains.rider.debugger.statistics.RiderDebuggerStatisticsUtilKt;
import com.jetbrains.rider.debugger.statistics.RuntimeType;
import com.jetbrains.rider.debugger.statistics.StatisticsEvaluationResultKind;
import com.jetbrains.rider.debugger.statistics.SteppingType;
import com.jetbrains.rider.debugger.statistics.VisualizerContentType;
import com.jetbrains.rider.model.debuggerWorker.ValueResultKind;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0011J&\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\nJ\u0016\u0010'\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u0014J\u0016\u0010(\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010)\u001a\u00020\u0018J\u001e\u0010*\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u001a\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020!2\n\u00101\u001a\u0006\u0012\u0002\b\u000302J\u001e\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\b2\u0006\u0010&\u001a\u00020\nJ\b\u00106\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "RiderDebuggerStatisticsCollector", "()V", "RUN_PROFILE_STATE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "DFA_STATE_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/jetbrains/rider/debugger/statistics/DFAState;", "RUNTIME_FIELD", "Lcom/jetbrains/rider/debugger/statistics/RuntimeType;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP$intellij_rider", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "VIEW_LINK_HIT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "Lcom/jetbrains/rider/debugger/statistics/VisualizerContentType;", "STEPPING_COMPLETED", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "Lcom/jetbrains/rider/debugger/statistics/SteppingType;", "SMART_STEPPING_INFO_COLLECTED", "DFA_SWITCHED_WITHIN_SESSION", "", "EVALUATED", "Lcom/jetbrains/rider/debugger/statistics/StatisticsEvaluationResultKind;", "Lcom/jetbrains/rider/debugger/statistics/OSType;", "STARTUP_ACTIVITY", "Lcom/intellij/internal/statistic/IdeActivityDefinition;", "logViewLinkHit", "", "project", "Lcom/intellij/openapi/project/Project;", "contentType", "onSteppingCompleted", "durationMillis", "steppingType", "runtime", "onSmartStepIntoCollected", "dfaSwitchedWithinSession", "enabled", "logEvaluated", "session", "Lcom/intellij/xdebugger/XDebugSession;", "kind", "Lcom/jetbrains/rider/model/debuggerWorker/ValueResultKind;", "initializeDebuggerStartupActivity", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "runProfileStateClass", "Ljava/lang/Class;", "finishStartupActivity", "startupActivity", "dfaState", "getGroup", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerStatisticsCollector.kt\ncom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n13#2:121\n15#3:122\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerStatisticsCollector.kt\ncom/jetbrains/rider/debugger/statistics/RiderDebuggerStatisticsCollector\n*L\n103#1:121\n103#1:122\n*E\n"})
public final class RiderDebuggerStatisticsCollector
extends CounterUsagesCollector {
    @NotNull
    public static final RiderDebuggerStatisticsCollector INSTANCE = new RiderDebuggerStatisticsCollector();
    @NotNull
    private static final ClassEventField RUN_PROFILE_STATE_FIELD = EventFields.Class((String)"RunProfileState");
    @NotNull
    private static final EnumEventField<DFAState> DFA_STATE_FIELD = EventFields.Enum$default((String)"dfaState", DFAState.class, null, (int)4, null);
    @NotNull
    private static final EnumEventField<RuntimeType> RUNTIME_FIELD = EventFields.Enum$default((String)"runtime", RuntimeType.class, null, (int)4, null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rider.debug", 7, null, 4, null);
    @NotNull
    private static final EventId1<VisualizerContentType> VIEW_LINK_HIT = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"view.link.hit", (EventField)((EventField)EventFields.Enum$default((String)"contentType", VisualizerContentType.class, null, (int)4, null)), null, (int)4, null);
    @NotNull
    private static final EventId3<Long, SteppingType, RuntimeType> STEPPING_COMPLETED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"stepping.completed", (EventField)((EventField)EventFields.DurationMs), (EventField)((EventField)EventFields.Enum$default((String)"type", SteppingType.class, null, (int)4, null)), (EventField)((EventField)RUNTIME_FIELD), null, (int)16, null);
    @NotNull
    private static final EventId1<Long> SMART_STEPPING_INFO_COLLECTED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"smart.stepping.info.collected", (EventField)((EventField)EventFields.DurationMs), null, (int)4, null);
    @NotNull
    private static final EventId1<Boolean> DFA_SWITCHED_WITHIN_SESSION = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"dfa.switched.within.session", (EventField)((EventField)EventFields.Enabled), null, (int)4, null);
    @NotNull
    private static final EventId3<StatisticsEvaluationResultKind, RuntimeType, OSType> EVALUATED = EventLogGroup.registerEvent$default((EventLogGroup)GROUP, (String)"evaluated", (EventField)((EventField)EventFields.Enum$default((String)"status", StatisticsEvaluationResultKind.class, null, (int)4, null)), (EventField)((EventField)RUNTIME_FIELD), (EventField)((EventField)EventFields.Enum$default((String)"OS", OSType.class, null, (int)4, null)), null, (int)16, null);
    @NotNull
    private static final IdeActivityDefinition STARTUP_ACTIVITY;

    private RiderDebuggerStatisticsCollector() {
    }

    @NotNull
    public final EventLogGroup getGROUP$intellij_rider() {
        return GROUP;
    }

    public final void logViewLinkHit(@NotNull Project project, @NotNull VisualizerContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)contentType), (String)"contentType");
        VIEW_LINK_HIT.log(project, (Object)contentType);
    }

    public final void onSteppingCompleted(@NotNull Project project, long durationMillis, @NotNull SteppingType steppingType, @NotNull RuntimeType runtime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)steppingType), (String)"steppingType");
        Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
        STEPPING_COMPLETED.log(project, (Object)durationMillis, (Object)steppingType, (Object)runtime);
    }

    public final void onSmartStepIntoCollected(@NotNull Project project, long durationMillis) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SMART_STEPPING_INFO_COLLECTED.log(project, (Object)durationMillis);
    }

    public final void dfaSwitchedWithinSession(@NotNull Project project, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DFA_SWITCHED_WITHIN_SESSION.log(project, (Object)enabled);
    }

    public final void logEvaluated(@NotNull Project project, @NotNull XDebugSession session, @NotNull ValueResultKind kind) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        DotNetDebugProcess dotNetDebugProcess = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(session);
        SourceExKt.adviseNotNullOnce((ISource)((ISource)dotNetDebugProcess.getSessionInfo()), (Lifetime)dotNetDebugProcess.getSessionLifetime(), arg_0 -> RiderDebuggerStatisticsCollector.G(project, kind, arg_0));
    }

    @NotNull
    public final StructuredIdeActivity initializeDebuggerStartupActivity(@NotNull Project project, @NotNull Class<?> runProfileStateClass) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(runProfileStateClass, (String)"runProfileStateClass");
        return STARTUP_ACTIVITY.started(project, () -> RiderDebuggerStatisticsCollector.G(runProfileStateClass));
    }

    public final void finishStartupActivity(@NotNull StructuredIdeActivity startupActivity, @NotNull DFAState dfaState, @NotNull RuntimeType runtime) {
        Intrinsics.checkNotNullParameter((Object)startupActivity, (String)"startupActivity");
        Intrinsics.checkNotNullParameter((Object)((Object)dfaState), (String)"dfaState");
        Intrinsics.checkNotNullParameter((Object)((Object)runtime), (String)"runtime");
        startupActivity.finished(() -> RiderDebuggerStatisticsCollector.G(dfaState, runtime));
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static final Unit G(Project project, ValueResultKind valueResultKind, DotNetDebugSessionInfo dotNetDebugSessionInfo) {
        Intrinsics.checkNotNullParameter((Object)dotNetDebugSessionInfo, (String)"it");
        EVALUATED.log(project, (Object)RiderDebuggerStatisticsUtilKt.toStatisticsModel(valueResultKind), (Object)RiderDebuggerStatisticsUtilKt.getRuntime(dotNetDebugSessionInfo.getInfo()), (Object)RiderDebuggerStatisticsUtilKt.toStatisticsModel(dotNetDebugSessionInfo.getInfo().getTargetProcessOS()));
        return Unit.INSTANCE;
    }

    private static final List G(Class clazz) {
        if (!RunProfileState.class.isAssignableFrom(clazz)) {
            boolean bl = false;
            boolean bl2 = false;
            Logger logger2 = Logger.getInstance(RiderDebuggerStatisticsCollector.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Class " + clazz.getName() + " is not instance of RunProfileState");
            return CollectionsKt.emptyList();
        }
        return CollectionsKt.listOf((Object)RUN_PROFILE_STATE_FIELD.with((Object)clazz));
    }

    private static final List G(DFAState dFAState, RuntimeType runtimeType) {
        Object[] objectArray = new EventPair[]{DFA_STATE_FIELD.with((Object)dFAState), RUNTIME_FIELD.with((Object)runtimeType)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{RUN_PROFILE_STATE_FIELD};
        EventField[] eventFieldArray2 = eventFieldArray;
        eventFieldArray = new EventField[]{DFA_STATE_FIELD, RUNTIME_FIELD};
        STARTUP_ACTIVITY = EventLogGroup.registerIdeActivity$default((EventLogGroup)GROUP, (String)"launch", (EventField[])eventFieldArray2, (EventField[])eventFieldArray, null, (boolean)false, (int)24, null);
    }
}

