/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.modulesView.columns;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.xdebugger.impl.modulesView.actions.SimpleCopyAction;
import com.intellij.xdebugger.impl.modulesView.table.ModulesViewTable;
import com.intellij.xdebugger.impl.modulesView.table.columns.ModulesViewColumnInfo;
import com.intellij.xdebugger.impl.modulesView.table.columns.renderers.ModulesViewColumnRenderer;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.modulesView.AssemblyVersion;
import com.jetbrains.rider.debugger.modulesView.DotnetDebuggerModule;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0014J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/debugger/modulesView/columns/VersionColumn;", "Lcom/intellij/xdebugger/impl/modulesView/table/columns/ModulesViewColumnInfo;", "Lcom/jetbrains/rider/debugger/modulesView/DotnetDebuggerModule;", "Lcom/jetbrains/rider/debugger/modulesView/AssemblyVersion;", "VersionColumn", "()V", "valueOf", "item", "createRenderer", "Lcom/intellij/xdebugger/impl/modulesView/table/columns/renderers/ModulesViewColumnRenderer;", "getComparator", "Ljava/util/Comparator;", "isSearchable", "", "getCopyAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.rider"})
public final class VersionColumn
extends ModulesViewColumnInfo<DotnetDebuggerModule, AssemblyVersion> {
    public VersionColumn() {
        super(RiderDebuggerBundle.Companion.message("tab.modules.column.version", new Object[0]));
    }

    @NotNull
    public AssemblyVersion valueOf(@NotNull DotnetDebuggerModule item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getVersion();
    }

    @Override
    @NotNull
    protected ModulesViewColumnRenderer<AssemblyVersion> createRenderer() {
        return new ModulesViewColumnRenderer<AssemblyVersion>(){

            protected void createComponents(ModulesViewTable<?> table2, AssemblyVersion value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Intrinsics.checkNotNullParameter(table2, (String)"table");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.addComponent(table2, value2.toString(), 2, isSelected);
            }
        };
    }

    @NotNull
    public Comparator<DotnetDebuggerModule> getComparator() {
        return VersionColumn::G;
    }

    @Override
    public boolean isSearchable() {
        return true;
    }

    @Override
    @NotNull
    public AnAction getCopyAction() {
        return new SimpleCopyAction(RiderDebuggerBundle.Companion.message("tab.modules.column.version.copy", new Object[0]), VersionColumn::G);
    }

    private static final int G(DotnetDebuggerModule dotnetDebuggerModule, DotnetDebuggerModule dotnetDebuggerModule2) {
        Intrinsics.checkNotNullParameter((Object)dotnetDebuggerModule, (String)"t1");
        Intrinsics.checkNotNullParameter((Object)dotnetDebuggerModule2, (String)"t2");
        return dotnetDebuggerModule.getVersion().compareTo(dotnetDebuggerModule2.getVersion());
    }

    private static final Iterable G(DotnetDebuggerModule dotnetDebuggerModule) {
        Intrinsics.checkNotNullParameter((Object)dotnetDebuggerModule, (String)"it");
        return CollectionsKt.listOf((Object)dotnetDebuggerModule.getVersion().toString());
    }
}

