/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.memoryView;

import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.jetbrains.rider.model.debuggerWorker.TypeInformation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0016J\u0011\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/debugger/memoryView/RiderTypeInfo;", "Lcom/intellij/xdebugger/memory/ui/TypeInfo;", "", "typeInfo", "Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;", "count", "", "totalSize", "RiderTypeInfo", "(Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;JJ)V", "getTypeInfo", "()Lcom/jetbrains/rider/model/debuggerWorker/TypeInformation;", "getCount", "()J", "getTotalSize", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getInstances", "", "Lcom/intellij/xdebugger/memory/ui/ReferenceInfo;", "limit", "", "canGetInstanceInfo", "", "equals", "other", "", "hashCode", "compareTo", "toString", "intellij.rider"})
public final class RiderTypeInfo
implements TypeInfo,
Comparable<RiderTypeInfo> {
    @NotNull
    private final TypeInformation typeInfo;
    private final long count;
    private final long totalSize;

    public RiderTypeInfo(@NotNull TypeInformation typeInfo, long count, long totalSize) {
        Intrinsics.checkNotNullParameter((Object)typeInfo, (String)"typeInfo");
        this.typeInfo = typeInfo;
        this.count = count;
        this.totalSize = totalSize;
    }

    @NotNull
    public final TypeInformation getTypeInfo() {
        return this.typeInfo;
    }

    public final long getCount() {
        return this.count;
    }

    public final long getTotalSize() {
        return this.totalSize;
    }

    @NotNull
    public String name() {
        return this.typeInfo.getDisplayName();
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        throw new IllegalStateException("Should not use sync version, use RiderAsyncInstancesProvider.getInstancesAsync");
    }

    public boolean canGetInstanceInfo() {
        return true;
    }

    public boolean equals(@Nullable Object other) {
        RiderTypeInfo riderTypeInfo = other instanceof RiderTypeInfo ? (RiderTypeInfo)other : null;
        if (riderTypeInfo == null) {
            return false;
        }
        RiderTypeInfo riderTypeInfo2 = riderTypeInfo;
        return Intrinsics.areEqual((Object)riderTypeInfo2.typeInfo.getClrFullName(), (Object)this.typeInfo.getClrFullName());
    }

    public int hashCode() {
        return this.typeInfo.getClrFullName().hashCode();
    }

    @Override
    public int compareTo(@NotNull RiderTypeInfo other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.name().compareTo(other.name());
    }

    @NotNull
    public String toString() {
        return this.name();
    }
}

