/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.immediateWindow.consoleImpl;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.IdeaActionButtonLook;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.rider.debugger.DotnetDebuggerExtKt;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.debugger.immediateWindow.ImmediateWindowOperations;
import com.jetbrains.rider.debugger.immediateWindow.consoleImpl.ImmediateWindowConsoleImpl;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import icons.RiderIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u001a\f\u0010\b\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0000\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\u0004H\u0000\u001a\f\u0010\f\u001a\u00020\n*\u00020\u0004H\u0000\u001a\u0016\u0010\r\u001a\u00020\n*\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\f\u0010\u000f\u001a\u00020\n*\u00020\u0004H\u0000\u001a\f\u0010\u0010\u001a\u00020\n*\u00020\u0004H\u0000\u001a\u0006\u0010\u0011\u001a\u00020\u0003\u001a\u0006\u0010\u0012\u001a\u00020\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "createAddWatchAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImpl;", "enabled", "Lcom/jetbrains/rd/util/reactive/Property;", "", "createShowEvaluateDialogAction", "attachOnActionHandler", "", "setFocusOnWritableContent", "setToolbarColor", "changeConsolesTheme", "calledOnComponentCreation", "changeFontSize", "subscribeToThemeChanging", "createEnableBreakEventsOnEvaluationAction", "getImmediateToolbarActionLook", "Lcom/intellij/openapi/actionSystem/impl/IdeaActionButtonLook;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nImmediateWindowConsoleImplUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmediateWindowConsoleImplUtils.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImplUtilsKt\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n13#2:264\n15#3:265\n*S KotlinDebug\n*F\n+ 1 ImmediateWindowConsoleImplUtils.kt\ncom/jetbrains/rider/debugger/immediateWindow/consoleImpl/ImmediateWindowConsoleImplUtilsKt\n*L\n60#1:264\n60#1:265\n*E\n"})
public final class ImmediateWindowConsoleImplUtilsKt {
    @NotNull
    private static final Logger logger;

    @NotNull
    public static final AnAction createAddWatchAction(@NotNull ImmediateWindowConsoleImpl $this$createAddWatchAction, @NotNull Property<Boolean> enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createAddWatchAction), (String)"<this>");
        Intrinsics.checkNotNullParameter(enabled, (String)"enabled");
        String string = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.add.watch.action.text", new Object[0]);
        String string2 = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.add.watch.action.description", new Object[0]);
        Icon icon = AllIcons.Debugger.Watch;
        return (AnAction)new TooltipDescriptionProvider($this$createAddWatchAction, enabled, string, string2, icon){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_createAddWatchAction;
            final /* synthetic */ Property<Boolean> $enabled;
            {
                this.$this_createAddWatchAction = $receiver;
                this.$enabled = $enabled;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int n = (SystemInfo.isMac ? 4 : 2) | 1;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(10, n);
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke));
                this.registerCustomShortcutSet($receiver.getConsoleEditor().getComponent(), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)$receiver.getLifetime(), null, (int)1, null));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.addWatch();
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabled(((Boolean)this.$enabled.getValue()).booleanValue());
                super.update(e);
            }

            public final void addWatch() {
                ImmediateWindowOperations immediateWindowOperations = this.$this_createAddWatchAction.getCurrentOperations$intellij_rider();
                String string = this.$this_createAddWatchAction.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                immediateWindowOperations.addWatch(string);
            }
        };
    }

    @NotNull
    public static final AnAction createShowEvaluateDialogAction(@NotNull ImmediateWindowConsoleImpl $this$createShowEvaluateDialogAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$createShowEvaluateDialogAction), (String)"<this>");
        String string = RiderDebuggerBundle.Companion.message("immediate.window.action.evaluate.in.dialog.window.text", new Object[0]);
        Icon icon = AllIcons.Debugger.EvaluateExpression;
        return (AnAction)new DumbAware($this$createShowEvaluateDialogAction, string, icon){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_createShowEvaluateDialogAction;
            {
                this.$this_createShowEvaluateDialogAction = $receiver;
                super($super_call_param$1, null, $super_call_param$2);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DataContext dataContext2 = e.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
                Project project = DataContextKt.getProject((DataContext)dataContext2);
                if (project == null) {
                    throw new IllegalStateException("Not null project expected".toString());
                }
                Project project2 = project;
                XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
                if (xDebugSession == null) {
                    throw new IllegalStateException("Not null session expected".toString());
                }
                XDebugSession xDebugSession2 = xDebugSession;
                XDebuggerEvaluator xDebuggerEvaluator = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(xDebugSession2).getEvaluator();
                if (xDebuggerEvaluator == null) {
                    throw new IllegalStateException("Not null evaluator expected".toString());
                }
                XDebuggerEvaluator xDebuggerEvaluator2 = xDebuggerEvaluator;
                DotNetDebuggerEditorsProvider dotNetDebuggerEditorsProvider = DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(xDebugSession2).getEditorsProvider();
                DocumentEx documentEx = this.$this_createShowEvaluateDialogAction.getConsoleEditor().getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
                XExpression xExpression = dotNetDebuggerEditorsProvider.createExpression(project2, (Document)documentEx, (Language)CSharpLanguage.INSTANCE, EvaluationMode.EXPRESSION);
                XStackFrame xStackFrame = xDebugSession2.getCurrentStackFrame();
                XSourcePosition xSourcePosition = xStackFrame != null ? xStackFrame.getSourcePosition() : null;
                XDebuggerEvaluationDialog xDebuggerEvaluationDialog = new XDebuggerEvaluationDialog(xDebugSession2, (XDebuggerEditorsProvider)DotnetDebuggerExtKt.getDotnetDebugProcessOrThrow(xDebugSession2).getEditorsProvider(), xExpression, xSourcePosition, xDebuggerEvaluator2.isCodeFragmentEvaluationSupported());
                xDebuggerEvaluationDialog.show();
                String string = xExpression.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
                if (!StringsKt.isBlank((CharSequence)string)) {
                    xDebuggerEvaluationDialog.performOKAction();
                }
            }
        };
    }

    public static final void attachOnActionHandler(@NotNull ImmediateWindowConsoleImpl $this$attachOnActionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$attachOnActionHandler), (String)"<this>");
        BaseConsoleExecuteActionHandler baseConsoleExecuteActionHandler = new BaseConsoleExecuteActionHandler($this$attachOnActionHandler){
            final /* synthetic */ ImmediateWindowConsoleImpl $this_attachOnActionHandler;
            {
                this.$this_attachOnActionHandler = $receiver;
                super(false);
            }

            public void runExecuteAction(LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                String string = consoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                ImmediateWindowConsoleImplUtilsKt.access$getLogger$p().debug("User request, text: " + string2);
                if (StringsKt.isBlank((CharSequence)string2)) {
                    return;
                }
                this.$this_attachOnActionHandler.getCurrentOperations$intellij_rider().startEval(string2);
            }
        };
        ConsoleExecuteAction consoleExecuteAction = new ConsoleExecuteAction((LanguageConsoleView)$this$attachOnActionHandler, (ConsoleExecuteAction.ConsoleExecuteActionHandler)baseConsoleExecuteActionHandler, baseConsoleExecuteActionHandler.getEmptyExecuteAction(), arg_0 -> ImmediateWindowConsoleImplUtilsKt.G(arg_0 -> ImmediateWindowConsoleImplUtilsKt.G($this$attachOnActionHandler, arg_0), arg_0));
        consoleExecuteAction.registerCustomShortcutSet(consoleExecuteAction.getShortcutSet(), $this$attachOnActionHandler.getConsoleEditor().getComponent());
    }

    public static final void setFocusOnWritableContent(@NotNull ImmediateWindowConsoleImpl $this$setFocusOnWritableContent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setFocusOnWritableContent), (String)"<this>");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)$this$setFocusOnWritableContent.getProject());
        SelectionListener selectionListener2 = new SelectionListener(booleanRef, ideFocusManager, $this$setFocusOnWritableContent){
            final /* synthetic */ Ref.BooleanRef $isSelection;
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ ImmediateWindowConsoleImpl $this_setFocusOnWritableContent;
            {
                this.$isSelection = $isSelection;
                this.$focusManager = $focusManager;
                this.$this_setFocusOnWritableContent = $receiver;
            }

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getNewRange().isEmpty()) {
                    this.$isSelection.element = false;
                    return;
                }
                this.$isSelection.element = true;
                this.$focusManager.requestFocus((Component)this.$this_setFocusOnWritableContent.getHistoryViewer().getContentComponent(), true);
            }
        };
        $this$setFocusOnWritableContent.getHistoryViewer().getSelectionModel().addSelectionListener(selectionListener2);
        $this$setFocusOnWritableContent.getLifetime().onTermination(() -> ImmediateWindowConsoleImplUtilsKt.G($this$setFocusOnWritableContent, selectionListener2));
        $this$setFocusOnWritableContent.getHistoryViewer().addFocusListener(new FocusChangeListener(booleanRef, ideFocusManager, $this$setFocusOnWritableContent){
            final /* synthetic */ Ref.BooleanRef $isSelection;
            final /* synthetic */ IdeFocusManager $focusManager;
            final /* synthetic */ ImmediateWindowConsoleImpl $this_setFocusOnWritableContent;
            {
                this.$isSelection = $isSelection;
                this.$focusManager = $focusManager;
                this.$this_setFocusOnWritableContent = $receiver;
            }

            public void focusGained(Editor editor2) {
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                if (this.$isSelection.element) {
                    return;
                }
                this.$focusManager.requestFocus((Component)this.$this_setFocusOnWritableContent.getConsoleEditor().getContentComponent(), true);
            }
        });
    }

    public static final void setToolbarColor(@NotNull ImmediateWindowConsoleImpl $this$setToolbarColor) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setToolbarColor), (String)"<this>");
        $this$setToolbarColor.getToolbarManager().getToolbar().setBackground(EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultBackground());
    }

    public static final void changeConsolesTheme(@NotNull ImmediateWindowConsoleImpl $this$changeConsolesTheme, boolean calledOnComponentCreation) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$changeConsolesTheme), (String)"<this>");
        $this$changeConsolesTheme.getConsoleEditor().setColorsScheme($this$changeConsolesTheme.getConsoleEditor().createBoundColorSchemeDelegate(EditorColorsManager.getInstance().getSchemeForCurrentUITheme()));
        $this$changeConsolesTheme.getHistoryViewer().setColorsScheme($this$changeConsolesTheme.getHistoryViewer().createBoundColorSchemeDelegate(EditorColorsManager.getInstance().getSchemeForCurrentUITheme()));
        ImmediateWindowConsoleImplUtilsKt.setToolbarColor($this$changeConsolesTheme);
        if (ExperimentalUI.Companion.isNewUI() && calledOnComponentCreation) {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = new PropertyChangeListener($this$changeConsolesTheme, (Ref.ObjectRef<PropertyChangeListener>)objectRef){
                final /* synthetic */ ImmediateWindowConsoleImpl $this_changeConsolesTheme;
                final /* synthetic */ Ref.ObjectRef<PropertyChangeListener> $listener;
                {
                    this.$this_changeConsolesTheme = $receiver;
                    this.$listener = $listener;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    PropertyChangeEvent propertyChangeEvent = evt;
                    if (!Intrinsics.areEqual((Object)(propertyChangeEvent != null ? propertyChangeEvent.getPropertyName() : null), (Object)"background")) {
                        return;
                    }
                    this.$this_changeConsolesTheme.getToolbarManager().getToolbar().removePropertyChangeListener((PropertyChangeListener)this.$listener.element);
                    ImmediateWindowConsoleImplUtilsKt.setToolbarColor(this.$this_changeConsolesTheme);
                }
            };
            $this$changeConsolesTheme.getToolbarManager().getToolbar().addPropertyChangeListener((PropertyChangeListener)objectRef.element);
        }
        JPanel jPanel = $this$changeConsolesTheme.getToolbarManager().getGotItNestedToolbar();
        if (jPanel != null) {
            jPanel.setBackground(EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultBackground());
        }
        $this$changeConsolesTheme.getConsoleEditor().getColorsScheme().setColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY, null);
        $this$changeConsolesTheme.getHistoryViewer().getColorsScheme().setColor(ConsoleViewContentType.CONSOLE_BACKGROUND_KEY, null);
        $this$changeConsolesTheme.getConsoleEditor().getColorsScheme().setColor(ColorKey.createColorKey((String)"CONSOLE_PROMPT_COLOR"), ConsoleViewContentType.USER_INPUT.getAttributes().getForegroundColor());
        ImmediateWindowConsoleImplUtilsKt.changeFontSize($this$changeConsolesTheme);
    }

    public static /* synthetic */ void changeConsolesTheme$default(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ImmediateWindowConsoleImplUtilsKt.changeConsolesTheme(immediateWindowConsoleImpl, bl);
    }

    public static final void changeFontSize(@NotNull ImmediateWindowConsoleImpl $this$changeFontSize) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$changeFontSize), (String)"<this>");
        int n = UISettings.Companion.getInstance().getOverrideLafFonts() ? UISettings.Companion.getInstance().getFontSize() : JBFont.label().getSize();
        $this$changeFontSize.setFont($this$changeFontSize.getFont().deriveFont((float)n));
        $this$changeFontSize.getConsoleEditor().setFontSize(n);
        $this$changeFontSize.getHistoryViewer().setFontSize(n);
        EditorEx editorEx = $this$changeFontSize.getConsoleEditor();
        Intrinsics.checkNotNull((Object)editorEx, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        ((EditorImpl)editorEx).getColorsScheme().setConsoleFontSize(n);
        Integer n2 = $this$changeFontSize.getToolbarManager().heightOfAction();
        if (n2 == null) {
            boolean bl = false;
            logger.warn("Unable to change immediate size according to UI font size");
            return;
        }
        int n3 = n2;
        if (n3 != 0) {
            float f = (float)n3 + 12.0f;
            $this$changeFontSize.getToolbarManager().getToolbar().setBorder(BorderFactory.createMatteBorder(6, 0, 0, 0, $this$changeFontSize.getToolbarManager().getToolbar().getBackground()));
            Border border = new EmptyBorder(((int)f - $this$changeFontSize.getConsoleEditor().getLineHeight()) / 2, 0, 0, 0);
            $this$changeFontSize.getConsoleEditor().getContentComponent().setBorder(border);
            $this$changeFontSize.getHistoryViewer().getContentComponent().setBorder(border);
            $this$changeFontSize.getCurrentOperations$intellij_rider().applyCollapsedImmediateHeightChanges(f);
        }
    }

    public static final void subscribeToThemeChanging(@NotNull ImmediateWindowConsoleImpl $this$subscribeToThemeChanging) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$subscribeToThemeChanging), (String)"<this>");
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)$this$subscribeToThemeChanging);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> ImmediateWindowConsoleImplUtilsKt.G($this$subscribeToThemeChanging, arg_0));
    }

    @NotNull
    public static final AnAction createEnableBreakEventsOnEvaluationAction() {
        String string = RiderDebuggerBundle.Companion.message("rider.debug.ImmediateWindowConsoleImpl.stop.on.break.events.text", new Object[0]);
        Icon icon = RiderIcons.Debugger.EvaluateWithBreakpoints;
        return (AnAction)new DumbAwareToggleAction(string, icon){

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return PropertiesComponent.getInstance().getBoolean("debugger.immediate.window.stop.on.break.events", true);
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PropertiesComponent.getInstance().setValue("debugger.immediate.window.stop.on.break.events", state, true);
            }
        };
    }

    @NotNull
    public static final IdeaActionButtonLook getImmediateToolbarActionLook() {
        return new IdeaActionButtonLook(){
            private final JBColor BUTTON_SELECTED_BACKGROUND;
            {
                JBColor jBColor = JBColor.namedColor((String)"SearchOption.selectedBackground", (int)14345453, (int)6054244);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
                this.BUTTON_SELECTED_BACKGROUND = jBColor;
            }

            public void paintBorder(Graphics g2, JComponent component2, @ActionButtonComponent.ButtonState int state) {
                Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                if (component2.isFocusOwner() && component2.isEnabled()) {
                    Rectangle rectangle = new Rectangle(component2.getSize());
                    JBInsets.removeFrom((Rectangle)rectangle, (Insets)component2.getInsets());
                    IdeaActionButtonLook.SYSTEM_LOOK.paintLookBorder(g2, rectangle, JBUI.CurrentTheme.ActionButton.focusedBorder());
                } else {
                    super.paintBorder(g2, component2, 0);
                }
            }

            protected int getState(ActionButtonComponent button) {
                Intrinsics.checkNotNull((Object)button, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionButton");
                return ((ActionButton)button).isSelected() ? 2 : super.getState(button);
            }

            public void paintBackground(Graphics g2, JComponent component2, int state) {
                Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                if (((ActionButton)component2).isRollover()) {
                    super.paintBackground(g2, component2, state);
                    return;
                }
                if (state == 2 && ((ActionButton)component2).isEnabled()) {
                    Rectangle rectangle = new Rectangle(component2.getSize());
                    JBInsets.removeFrom((Rectangle)rectangle, (Insets)((ActionButton)component2).getInsets());
                    this.paintLookBackground(g2, rectangle, (Color)this.BUTTON_SELECTED_BACKGROUND);
                }
            }
        };
    }

    private static final boolean G(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, LanguageConsoleView languageConsoleView) {
        return RLifetimeKt.isAlive((Lifetime)immediateWindowConsoleImpl.getLifetime());
    }

    private static final boolean G(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final Unit G(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, SelectionListener selectionListener2) {
        immediateWindowConsoleImpl.getHistoryViewer().getSelectionModel().removeSelectionListener(selectionListener2);
        return Unit.INSTANCE;
    }

    private static final void G(ImmediateWindowConsoleImpl immediateWindowConsoleImpl) {
        ImmediateWindowConsoleImplUtilsKt.changeConsolesTheme$default(immediateWindowConsoleImpl, false, 1, null);
    }

    private static final void G(ImmediateWindowConsoleImpl immediateWindowConsoleImpl, LafManager lafManager) {
        Intrinsics.checkNotNullParameter((Object)lafManager, (String)"it");
        DebuggerUIUtil.invokeLater(() -> ImmediateWindowConsoleImplUtilsKt.G(immediateWindowConsoleImpl));
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(ImmediateWindowConsoleImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }
}

