/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception.view;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.components.RiderExceptionPaneKt;
import com.jetbrains.rider.debugger.exception.model.CompositeExceptionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModel;
import com.jetbrains.rider.ui.components.ComponentFactories;
import com.jetbrains.rider.ui.components.base.Viewable;
import com.jetbrains.rider.ui.components.exceptions.ExceptionPaneUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u000fH\u0003J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/debugger/exception/view/ExceptionContentPane;", "Lcom/jetbrains/rider/ui/components/base/Viewable;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "exceptionModel", "Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "lifeTime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "ExceptionContentPane", "(Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "selected", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "pane", "Ljavax/swing/JPanel;", "getPane", "()Ljavax/swing/JPanel;", "typeField", "Ljavax/swing/JLabel;", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getView", "G", "", "ex", "G", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.rider"})
public final class ExceptionContentPane
implements Viewable<JComponent>,
UiDataProvider {
    @NotNull
    private final CompositeExceptionModel exceptionModel;
    @NotNull
    private final Project project;
    @Nullable
    private ExceptionModel selected;
    @NotNull
    private final JPanel pane;
    @NotNull
    private final JLabel typeField;
    @NotNull
    private ConsoleViewImpl consoleView;

    public ExceptionContentPane(@NotNull CompositeExceptionModel exceptionModel, @NotNull Lifetime lifeTime, @NotNull Project project) {
        ComboBox comboBox2;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"exceptionModel");
        Intrinsics.checkNotNullParameter((Object)lifeTime, (String)"lifeTime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.exceptionModel = exceptionModel;
        this.project = project;
        MigLayout migLayout = new MigLayout("fill, novisualpadding, ins 0, gapx 0, gapy " + JBUI.scale((int)1) + "px, flowy", "", "[min!][grow]");
        this.pane = new JPanel(migLayout){};
        this.typeField = new JLabel();
        this.consoleView = ExceptionPaneUtils.INSTANCE.getWrappedConsoleView(this.project, lifeTime);
        AnAction anAction = ActionManager.getInstance().getAction("Rider.Debugger.Inner.Exception.Popup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        migLayout = (DefaultActionGroup)anAction;
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new MigLayout("novisualpadding, fillx, ins 0, gap 0", "[]" + JBUI.scale((int)5) + "[min!]"));
        boolean bl = false;
        if (this.exceptionModel.getList().size() > 1) {
            comboBox2 = ComponentFactories.Companion.simpleCombo(this.exceptionModel.getList(), arg_0 -> ExceptionContentPane.G(this, arg_0));
            SourceExKt.adviseNotNull((ISource)((ISource)RdSwingKt.selectedItemProperty((JComboBox)((JComboBox)comboBox2))), (Lifetime)lifeTime, arg_0 -> ExceptionContentPane.G(this, arg_0));
            jPanel2.add((Component)comboBox2, "pushx, wmin " + JBUI.scale((int)20));
        } else {
            jPanel2.add((Component)this.typeField, "pushx, wmin " + JBUI.scale((int)20) + ", gaptop " + JBUI.scale((int)5) + "px, gapbottom " + JBUI.scale((int)5) + "px");
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Rider.Debugger.Popup", (ActionGroup)migLayout, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        comboBox2 = actionToolbar;
        comboBox2.getComponent().setOpaque(false);
        comboBox2.getComponent().setBorder((Border)JBUI.Borders.empty());
        comboBox2.setTargetComponent((JComponent)jPanel2);
        comboBox2.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        jPanel2.add((Component)comboBox2.getComponent(), "wmin pref");
        JPanel jPanel3 = jPanel;
        this.pane.add(jPanel3);
        this.consoleView.setBorder((Border)JBUI.Borders.empty());
        this.pane.add((Component)this.consoleView, "grow");
        this.G(this.exceptionModel.getList().get(0));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JPanel getPane() {
        return this.pane;
    }

    @NotNull
    public JComponent getView() {
        return this.pane;
    }

    private final void G(ExceptionModel exceptionModel) {
        this.selected = exceptionModel;
        this.typeField.setText(this.G(exceptionModel));
        this.consoleView.clear();
        String string = exceptionModel.getFullInfo();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        this.consoleView.print(string, consoleViewContentType);
        this.consoleView.scrollTo(0);
    }

    @NlsSafe
    private final String G(ExceptionModel exceptionModel) {
        return StringsKt.substringAfterLast$default((String)exceptionModel.getType(), (String)".", null, (int)2, null);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(RiderExceptionPaneKt.getRIDER_POPUP_EXCEPTION_KEY(), (Object)this.exceptionModel);
    }

    private static final String G(ExceptionContentPane exceptionContentPane, ExceptionModel exceptionModel) {
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"it");
        return (String)(exceptionContentPane.exceptionModel.getList().size() == 1 ? "" : exceptionContentPane.exceptionModel.getList().indexOf(exceptionModel) + 1 + "/" + exceptionContentPane.exceptionModel.getList().size() + " ") + exceptionContentPane.G(exceptionModel);
    }

    private static final Unit G(ExceptionContentPane exceptionContentPane, ExceptionModel exceptionModel) {
        Intrinsics.checkNotNullParameter((Object)exceptionModel, (String)"it");
        exceptionContentPane.G(exceptionModel);
        return Unit.INSTANCE;
    }
}

