/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception.model;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.RiderDebuggerBundle;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModelSourceType;
import com.jetbrains.rider.model.debuggerWorker.ExceptionModelType;
import com.jetbrains.rider.stacktrace.IStacktrace;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 52\u00020\u0001:\u00015B?\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010-\u001a\u00020.R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0011\u0010+\u001a\u00020$8G\u00a2\u0006\u0006\u001a\u0004\b,\u0010&R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0013\u00103\u001a\u0004\u0018\u00010$8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010&\u00a8\u00066"}, d2={"Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel;", "", "list", "", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "exceptionSourceType", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelSourceType;", "exceptionHandlerType", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;", "softDebuggerException", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "CompositeExceptionModel", "(Ljava/util/List;Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelSourceType;Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;ZLcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getList", "()Ljava/util/List;", "getExceptionSourceType", "()Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelSourceType;", "getExceptionHandlerType", "()Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModelType;", "getSoftDebuggerException", "()Z", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "ld", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "active", "Lcom/jetbrains/rd/util/reactive/IProperty;", "getActive", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "message", "", "getMessage", "()Ljava/lang/String;", "type", "getType", "fullInfo", "getFullInfo", "exceptionTypeString", "getExceptionTypeString", "disable", "", "stacktrace", "Lcom/jetbrains/rider/stacktrace/IStacktrace;", "getStacktrace", "()Lcom/jetbrains/rider/stacktrace/IStacktrace;", "breakpointType", "getBreakpointType", "Companion", "intellij.rider"})
public final class CompositeExceptionModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ExceptionModel> list;
    @NotNull
    private final ExceptionModelSourceType exceptionSourceType;
    @NotNull
    private final ExceptionModelType exceptionHandlerType;
    private final boolean softDebuggerException;
    @Nullable
    private final XSourcePosition position;
    @NotNull
    private LifetimeDefinition ld;
    @NotNull
    private final IProperty<Boolean> active;

    public CompositeExceptionModel(@NotNull List<ExceptionModel> list2, @NotNull ExceptionModelSourceType exceptionSourceType, @NotNull ExceptionModelType exceptionHandlerType, boolean softDebuggerException, @Nullable XSourcePosition position, @NotNull Lifetime lifetime) {
        boolean bl;
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter((Object)exceptionSourceType, (String)"exceptionSourceType");
        Intrinsics.checkNotNullParameter((Object)exceptionHandlerType, (String)"exceptionHandlerType");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.list = list2;
        this.exceptionSourceType = exceptionSourceType;
        this.exceptionHandlerType = exceptionHandlerType;
        this.softDebuggerException = softDebuggerException;
        this.position = position;
        boolean bl2 = bl = !((Collection)this.list).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.ld = lifetime.createNested();
        this.active = (IProperty)new Property((Object)true);
    }

    @NotNull
    public final List<ExceptionModel> getList() {
        return this.list;
    }

    @NotNull
    public final ExceptionModelSourceType getExceptionSourceType() {
        return this.exceptionSourceType;
    }

    @NotNull
    public final ExceptionModelType getExceptionHandlerType() {
        return this.exceptionHandlerType;
    }

    public final boolean getSoftDebuggerException() {
        return this.softDebuggerException;
    }

    @Nullable
    public final XSourcePosition getPosition() {
        return this.position;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.ld.getLifetime();
    }

    @NotNull
    public final IProperty<Boolean> getActive() {
        return this.active;
    }

    @NlsSafe
    @NotNull
    public final String getMessage() {
        return this.list.get(0).getMessage();
    }

    @NlsSafe
    @NotNull
    public final String getType() {
        return this.list.get(0).getType();
    }

    @NotNull
    public final String getFullInfo() {
        return this.list.get(0).getFullInfo();
    }

    @Nls
    @NotNull
    public final String getExceptionTypeString() {
        if (this.exceptionHandlerType == ExceptionModelType.Unknown || this.exceptionSourceType == ExceptionModelSourceType.Unknown) {
            return RiderDebuggerBundle.Companion.message("rider.exception.popup.unknown.exception.message", new Object[0]);
        }
        String string = switch (WhenMappings.$EnumSwitchMapping$0[this.exceptionSourceType.ordinal()]) {
            case 1 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.unknown.exception.message", new Object[0]);
            case 2 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.exception.source.user.message", new Object[0]);
            case 3 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.exception.source.nonuser.message", new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
        String string2 = switch (WhenMappings.$EnumSwitchMapping$1[this.exceptionHandlerType.ordinal()]) {
            case 1 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.unknown.exception.message", new Object[0]);
            case 2 -> RiderDebuggerBundle.Companion.message("rider.exception.popup.unhandled.exception.message", new Object[0]);
            case 3 -> {
                if (this.softDebuggerException) {
                    yield RiderDebuggerBundle.Companion.message("rider.exception.popup.handled.exception.message", new Object[0]);
                }
                yield RiderDebuggerBundle.Companion.message("rider.exception.popup.others.handled.exception.message", new Object[0]);
            }
            case 4 -> {
                if (this.softDebuggerException) {
                    yield RiderDebuggerBundle.Companion.message("rider.exception.popup.handled.exception.message", new Object[0]);
                }
                yield RiderDebuggerBundle.Companion.message("rider.exception.popup.user.handled.exception.message", new Object[0]);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        Object[] objectArray = new Object[]{string, string2};
        return RiderDebuggerBundle.Companion.message("rider.exception.popup.exception.message", objectArray);
    }

    public final void disable() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.ld, (boolean)false, (int)1, null);
    }

    @NotNull
    public final IStacktrace getStacktrace() {
        return Companion.stacktrace(this.list.get(0));
    }

    @Nullable
    public final String getBreakpointType() {
        return this.list.get(0).getBreakpointType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/debugger/exception/model/CompositeExceptionModel$Companion;", "", "CompositeExceptionModel$Companion", "()V", "stacktrace", "Lcom/jetbrains/rider/stacktrace/IStacktrace;", "ex", "Lcom/jetbrains/rider/model/debuggerWorker/ExceptionModel;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IStacktrace stacktrace(@NotNull ExceptionModel ex) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            return new IStacktrace(ex){
                final /* synthetic */ ExceptionModel $ex;
                {
                    this.$ex = $ex;
                }

                public Object getId() {
                    return this.$ex;
                }

                public String getText() {
                    return this.$ex.getFullInfo();
                }

                public String getTitle() {
                    return this.$ex.getType();
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExceptionModelSourceType.values().length];
            try {
                nArray[ExceptionModelSourceType.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelSourceType.UserCode.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelSourceType.ExternalCode.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ExceptionModelType.values().length];
            try {
                nArray[ExceptionModelType.Unknown.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.Unhandled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.OthersHandled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionModelType.UserHandled.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

