/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.exception.EditorBalloonLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.ui.components.balloon.SimpleBalloon;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/debugger/exception/ExceptionBalloonLayouter;", "Lcom/jetbrains/rider/debugger/exception/EditorBalloonLayouter;", "parentLT", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "balloon", "Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;", "popupLayouter", "Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "ExceptionBalloonLayouter", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rider/ui/components/balloon/SimpleBalloon;Lcom/jetbrains/rider/services/popups/nova/layouter/PopupLayouter;Lcom/intellij/openapi/editor/LogicalPosition;)V", "getLogicalPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "balloonPosition", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/rider/debugger/exception/ExceptionBalloonLayouter$BalloonPosition;", "getBalloonPosition", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "update", "", "BalloonPosition", "intellij.rider"})
public final class ExceptionBalloonLayouter
extends EditorBalloonLayouter {
    @NotNull
    private final LogicalPosition logicalPosition;
    @NotNull
    private final IProperty<BalloonPosition> balloonPosition;

    public ExceptionBalloonLayouter(@NotNull Lifetime parentLT, @NotNull Project project, @NotNull Editor editor2, @NotNull SimpleBalloon balloon, @NotNull PopupLayouter popupLayouter, @NotNull LogicalPosition logicalPosition) {
        Intrinsics.checkNotNullParameter((Object)parentLT, (String)"parentLT");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)popupLayouter, (String)"popupLayouter");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        super(parentLT, project, editor2, balloon, popupLayouter);
        this.logicalPosition = logicalPosition;
        this.balloonPosition = (IProperty)new Property(null);
    }

    @NotNull
    public final LogicalPosition getLogicalPosition() {
        return this.logicalPosition;
    }

    @NotNull
    public final IProperty<BalloonPosition> getBalloonPosition() {
        return this.balloonPosition;
    }

    @Override
    protected void update() {
        super.update();
        this.balloonPosition.set((Object)this.G());
    }

    private final BalloonPosition G() {
        Rectangle rectangle = this.getBalloon().getComponent().getBounds();
        Point point = new Point(0, 0);
        SwingUtilities.convertPointToScreen(point, this.getBalloon().getComponent());
        Point point2 = this.getEditor().logicalPositionToXY(this.logicalPosition);
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"logicalPositionToXY(...)");
        Point point3 = point2;
        SwingUtilities.convertPointToScreen(point3, this.getEditor().getContentComponent());
        int n = point3.y;
        if (n >= point.y + rectangle.height) {
            return BalloonPosition.TOP;
        }
        if (n >= point.y) {
            return BalloonPosition.MIDDLE;
        }
        return BalloonPosition.BOTTOM;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/debugger/exception/ExceptionBalloonLayouter$BalloonPosition;", "", "ExceptionBalloonLayouter$BalloonPosition", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "MIDDLE", "intellij.rider"})
    public static final class BalloonPosition
    extends Enum<BalloonPosition> {
        public static final /* enum */ BalloonPosition TOP = new BalloonPosition();
        public static final /* enum */ BalloonPosition BOTTOM = new BalloonPosition();
        public static final /* enum */ BalloonPosition MIDDLE = new BalloonPosition();
        private static final /* synthetic */ BalloonPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BalloonPosition[] values() {
            return (BalloonPosition[])$VALUES.clone();
        }

        public static BalloonPosition valueOf(String value2) {
            return Enum.valueOf(BalloonPosition.class, value2);
        }

        @NotNull
        public static EnumEntries<BalloonPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = balloonPositionArray = new BalloonPosition[]{BalloonPosition.TOP, BalloonPosition.BOTTOM, BalloonPosition.MIDDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

