/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.debugger.exception;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.WindowMoveListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.debugger.components.RiderPopupBalloonState;
import com.jetbrains.rider.debugger.exception.ExBalloonController;
import com.jetbrains.rider.debugger.exception.ExceptionBalloonLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring;
import com.jetbrains.rider.services.popups.nova.layouter.Anchoring2D;
import com.jetbrains.rider.services.popups.nova.layouter.AnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.DockingLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.EditorAnchoringRect;
import com.jetbrains.rider.services.popups.nova.layouter.PopupLayouter;
import com.jetbrains.rider.services.popups.nova.layouter.SimplePopupLayouterSource;
import com.jetbrains.rider.ui.components.balloon.DraggableBalloon;
import com.jetbrains.rider.ui.components.resize.ResizeAbility;
import com.jetbrains.rider.ui.components.resize.Resizer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000[\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u001b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/debugger/exception/ExBalloonController;", "", "balloon", "Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "state", "Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "project", "Lcom/intellij/openapi/project/Project;", "parentLT", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ExBalloonController", "(Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/LogicalPosition;Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getBalloon", "()Lcom/jetbrains/rider/ui/components/balloon/DraggableBalloon;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "getState", "()Lcom/jetbrains/rider/debugger/components/RiderPopupBalloonState;", "getProject", "()Lcom/intellij/openapi/project/Project;", "resizer", "Lcom/jetbrains/rider/ui/components/resize/Resizer;", "moveListener", "com/jetbrains/rider/debugger/exception/ExBalloonController$moveListener$1", "Lcom/jetbrains/rider/debugger/exception/ExBalloonController$moveListener$1;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "active", "Lcom/jetbrains/rd/util/reactive/Property;", "", "G", "Lcom/jetbrains/rider/ui/components/resize/ResizeAbility;", "balloonPosition", "Lcom/jetbrains/rider/debugger/exception/ExceptionBalloonLayouter$BalloonPosition;", "hide", "", "show", "intellij.rider"})
public final class ExBalloonController {
    @NotNull
    private final DraggableBalloon balloon;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final RiderPopupBalloonState state;
    @NotNull
    private final Project project;
    @Nullable
    private Resizer resizer;
    @NotNull
    private final moveListener.1 moveListener;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private Property<Boolean> active;

    public ExBalloonController(@NotNull DraggableBalloon balloon, @NotNull EditorEx editor2, @NotNull LogicalPosition logicalPosition, @NotNull RiderPopupBalloonState state, @NotNull Project project, @NotNull Lifetime parentLT) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentLT, (String)"parentLT");
        this.balloon = balloon;
        this.editor = editor2;
        this.state = state;
        this.project = project;
        JComponent jComponent = this.balloon.getDragArea();
        this.moveListener = new WindowMoveListener(this, jComponent){
            final /* synthetic */ ExBalloonController this$0;
            {
                this.this$0 = $receiver;
                super((Component)$super_call_param$1);
            }

            protected Component getView(Component component2) {
                Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                return this.this$0.getBalloon().getComponent();
            }

            public void mouseDragged(MouseEvent event) {
                block0: {
                    super.mouseDragged(event);
                    this.this$0.getState().getPinned().set((Object)true);
                    Resizer resizer = ExBalloonController.access$getResizer$p(this.this$0);
                    if (resizer == null) break block0;
                    resizer.setResizeAbility(new ResizeAbility(false, false, false, false, 15, null));
                }
            }
        };
        this.lifetime = (Lifetime)parentLT.createNested();
        this.active = new Property((Object)false);
        jComponent = EditorAnchoringRect.Companion.createHorizontalSmartClipRect(this.lifetime, this.editor.getDocument().getLineStartOffset(logicalPosition.line), (Editor)this.editor);
        Function1 function1 = arg_0 -> ExBalloonController.G((AnchoringRect)jComponent, this, arg_0);
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        PopupLayouter popupLayouter = new SimplePopupLayouterSource(function1, string).createLayouter(this.lifetime);
        ExceptionBalloonLayouter exceptionBalloonLayouter = new ExceptionBalloonLayouter(this.lifetime, this.project, (Editor)this.editor, this.balloon, popupLayouter, logicalPosition);
        this.active.view(this.lifetime, (arg_0, arg_1) -> ExBalloonController.G(this, exceptionBalloonLayouter, arg_0, arg_1));
        this.state.getHideSignal().advise(this.lifetime, arg_0 -> ExBalloonController.G(this, arg_0));
    }

    @NotNull
    public final DraggableBalloon getBalloon() {
        return this.balloon;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final RiderPopupBalloonState getState() {
        return this.state;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    private final ResizeAbility G(ExceptionBalloonLayouter.BalloonPosition balloonPosition) {
        ExceptionBalloonLayouter.BalloonPosition balloonPosition2 = balloonPosition;
        return switch (balloonPosition2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[balloonPosition2.ordinal()]) {
            case -1 -> null;
            case 1 -> ResizeAbility.Companion.getTOP_RIGHT();
            case 2 -> ResizeAbility.Companion.getBOTTOM_RIGHT();
            case 3 -> ResizeAbility.Companion.getTOP_BOTTOM_RIGHT();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void hide() {
        this.active.set((Object)false);
        this.balloon.hide();
    }

    public final void show() {
        this.state.getPinned().set((Object)false);
        this.active.set((Object)true);
    }

    private static final PopupLayouter G(AnchoringRect anchoringRect, ExBalloonController exBalloonController, Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        Object[] objectArray = new Anchoring2D[]{new Anchoring2D(Anchoring.FarOutside, Anchoring.FarOutside), new Anchoring2D(Anchoring.FarOutside, Anchoring.NearOutside)};
        return (PopupLayouter)new DockingLayouter(lifetime, anchoringRect, CollectionsKt.listOf((Object[])objectArray), exBalloonController.project, 0, false, 48, null);
    }

    private static final Unit G(ExBalloonController exBalloonController) {
        exBalloonController.balloon.getDragArea().removeMouseListener((MouseListener)((Object)exBalloonController.moveListener));
        exBalloonController.balloon.getDragArea().removeMouseMotionListener((MouseMotionListener)((Object)exBalloonController.moveListener));
        exBalloonController.resizer = null;
        return Unit.INSTANCE;
    }

    private static final Unit G(ExBalloonController exBalloonController, ExceptionBalloonLayouter.BalloonPosition balloonPosition) {
        block0: {
            Resizer resizer = exBalloonController.resizer;
            if (resizer == null) break block0;
            resizer.setResizeAbility(exBalloonController.G(balloonPosition));
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(ExceptionBalloonLayouter exceptionBalloonLayouter) {
        exceptionBalloonLayouter.uninstall();
        return Unit.INSTANCE;
    }

    private static final Unit G(ExceptionBalloonLayouter exceptionBalloonLayouter, ExBalloonController exBalloonController, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"modelt");
        if (!bl) {
            exceptionBalloonLayouter.install();
            exceptionBalloonLayouter.getBalloonPosition().advise(lifetime, arg_0 -> ExBalloonController.G(exBalloonController, arg_0));
            lifetime.onTermination(() -> ExBalloonController.G(exceptionBalloonLayouter));
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(ExBalloonController exBalloonController, ExceptionBalloonLayouter exceptionBalloonLayouter, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        if (!bl) {
            return Unit.INSTANCE;
        }
        exBalloonController.balloon.getDragArea().addMouseListener((MouseListener)((Object)exBalloonController.moveListener));
        exBalloonController.balloon.getDragArea().addMouseMotionListener((MouseMotionListener)((Object)exBalloonController.moveListener));
        exBalloonController.resizer = new Resizer(exBalloonController.balloon.getComponent(), lifetime);
        lifetime.onTermination(() -> ExBalloonController.G(exBalloonController));
        exBalloonController.state.getPinned().view(lifetime, (arg_0, arg_1) -> ExBalloonController.G(exceptionBalloonLayouter, exBalloonController, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit G(ExBalloonController exBalloonController, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        exBalloonController.hide();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Resizer access$getResizer$p(ExBalloonController $this) {
        return $this.resizer;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExceptionBalloonLayouter.BalloonPosition.values().length];
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExceptionBalloonLayouter.BalloonPosition.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

